/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.signoff;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.security.UsersContainersValidationConfig;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffConfigurationId;
import com.dataiku.gh.core.models.signoff.SignoffUser;
import com.dataiku.gh.core.models.signoff.SignoffUsersGroup;
import com.dataiku.gh.core.services.blueprints.BlueprintVersionsUtils;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.signoff.IAdminBlueprintVersionSignoffConfigurationsService;
import com.dataiku.gh.core.services.signoff.ISignoffsDataService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.ISignoffsValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.core.visitors.ISignoffConfigurationVisitor;
import com.dataiku.gh.security.IPermissionsService;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.api.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminSignoffConfigurationsService
implements IAdminBlueprintVersionSignoffConfigurationsService {
    @Autowired
    private ISignoffsDataService signoffsDataService;
    @Autowired
    private ISignoffsValidationService signoffsValidationService;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;

    @Override
    @GHReadonlyTransaction
    public List<SignoffConfiguration> getBlueprintVersionSignoffsConfigurations(AuthCtx authCtx, BlueprintVersionId blueprintVersionId) throws IOException, DKUSecurityException {
        this.permissionsService.checkMayManageGovern(authCtx);
        return this.signoffsDataService.listSignoffsConfigurationsByBlueprintVersion(blueprintVersionId);
    }

    @Override
    @GHReadonlyTransaction
    public SignoffConfiguration getSignoffConfiguration(AuthCtx authCtx, SignoffConfigurationId signoffConfigurationId) throws IOException, DKUSecurityException {
        this.permissionsService.checkMayManageGovern(authCtx);
        return this.signoffsDataService.getSignoffConfiguration(signoffConfigurationId);
    }

    @Override
    @GHWriteTransaction
    public SignoffConfiguration saveSignoffConfiguration(AuthCtx authCtx, SignoffConfiguration wantedConfiguration) throws IOException, UnauthorizedException, LimitsStatusComputer.LicenseLimitException {
        return this.createOrSaveSignoffConfiguration(authCtx, wantedConfiguration, false, UsersContainersValidationConfig.buildValidateAll());
    }

    @Override
    @GHWriteTransaction
    public SignoffConfiguration importSignoffConfiguration(AuthCtx authCtx, SignoffConfiguration signoffConfiguration, UsersContainersValidationConfig.ValidationBehavior rolesImportValidationBehavior) throws UnauthorizedException, LimitsStatusComputer.LicenseLimitException, IOException {
        this.permissionsService.checkMayManageGovern(authCtx);
        String userIdentifier = authCtx.getIdentifier();
        this.prepareSignoffConfigurationForImport(signoffConfiguration, userIdentifier);
        return this.createOrSaveSignoffConfiguration(authCtx, signoffConfiguration, true, UsersContainersValidationConfig.build(rolesImportValidationBehavior, UsersContainersValidationConfig.ValidationBehavior.NONE, UsersContainersValidationConfig.ValidationBehavior.NONE, UsersContainersValidationConfig.ValidationBehavior.NONE));
    }

    @Override
    @GHWriteTransaction
    public SignoffConfiguration createSignoffConfiguration(AuthCtx authCtx, SignoffConfiguration signoffConfiguration) throws UnauthorizedException, LimitsStatusComputer.LicenseLimitException, IOException {
        return this.createOrSaveSignoffConfiguration(authCtx, signoffConfiguration, true, UsersContainersValidationConfig.buildValidateAll());
    }

    private SignoffConfiguration createOrSaveSignoffConfiguration(AuthCtx authCtx, SignoffConfiguration signoffConfiguration, boolean creation, UsersContainersValidationConfig usersContainersValidationConfig) throws UnauthorizedException, LimitsStatusComputer.LicenseLimitException, IOException {
        this.permissionsService.checkMayManageGovern(authCtx);
        SignoffConfigurationId signoffConfigurationId = signoffConfiguration.id;
        if (creation) {
            this.checkAllowedToModifySignoffConfigMoreThanPermissions(signoffConfigurationId);
        }
        String userIdentifier = authCtx.getIdentifier();
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.blueprintsDataService.getBlueprintVersion(signoffConfigurationId.blueprintVersionId);
        ValidatorUtils.validateThat(enrichedBlueprintVersion.blueprintVersion.workflowDefinition.findStepDefinitionById(signoffConfigurationId.stepId).isPresent(), "Unable to find the step with id '%s'", signoffConfigurationId);
        Optional previousConfiguration = Optional.ofNullable(enrichedBlueprintVersion.signoffsConfigurations).flatMap(signoffsConfigurations -> signoffsConfigurations.stream().filter(sc -> Strings.equals((String)sc.id.stepId, (String)signoffConfigurationId.stepId)).findAny());
        if (creation) {
            ValidatorUtils.validateThat(previousConfiguration.isEmpty(), "Sign-off configuration already exists: " + String.valueOf(signoffConfigurationId), new Object[0]);
        } else {
            ValidatorUtils.validateThat(previousConfiguration.isPresent(), "Sign-off configuration for step not found: " + String.valueOf(signoffConfigurationId), new Object[0]);
            if (!AdminSignoffConfigurationsService.areSignoffConfigurationsEqualsExceptPermissions((SignoffConfiguration)previousConfiguration.get(), signoffConfiguration)) {
                this.checkAllowedToModifySignoffConfigMoreThanPermissions(signoffConfigurationId);
            }
        }
        SignoffConfiguration newConfiguration = this.mergeSignoffConfigurations(previousConfiguration.orElse(new SignoffConfiguration()), signoffConfiguration, userIdentifier);
        return this.validateAndStoreBlueprintVersionSignoffConfigurations(newConfiguration, creation, usersContainersValidationConfig);
    }

    private void checkAllowedToModifySignoffConfigMoreThanPermissions(SignoffConfigurationId signoffConfigurationId) throws LimitsStatusComputer.LicenseLimitException {
        this.checkPermissionsService.checkGovernBlueprintDesignerAllowed();
        if (BlueprintVersionsUtils.blueprintVersionIsNotEditable(signoffConfigurationId.blueprintVersionId)) {
            throw new ValidationException("Cannot edit a sign-off configuration with ID `" + String.valueOf(signoffConfigurationId) + "` for a non-custom blueprint version `" + String.valueOf(signoffConfigurationId.blueprintVersionId) + "`");
        }
    }

    private static boolean areSignoffConfigurationsEqualsExceptPermissions(SignoffConfiguration conf1, SignoffConfiguration conf2) {
        SignoffConfiguration conf1Copy = (SignoffConfiguration)JSON.deepCopy((Object)conf1);
        AdminSignoffConfigurationsService.removePermissionsFromSignoffConfiguration(conf1Copy);
        SignoffConfiguration conf2Copy = (SignoffConfiguration)JSON.deepCopy((Object)conf2);
        AdminSignoffConfigurationsService.removePermissionsFromSignoffConfiguration(conf2Copy);
        return Objects.equals(conf1Copy, conf2Copy);
    }

    private static void removePermissionsFromSignoffConfiguration(SignoffConfiguration conf) {
        conf.feedbackUsersGroups.forEach(fug -> {
            fug.users = Collections.emptyList();
        });
        conf.approvers = Collections.emptyList();
    }

    @Override
    @GHWriteTransaction
    public void deleteSignoffConfiguration(AuthCtx authCtx, SignoffConfigurationId signoffConfigurationId) throws IOException, UnauthorizedException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkMayManageGovern(authCtx);
        this.checkPermissionsService.checkGovernBlueprintDesignerAllowed();
        if (BlueprintVersionsUtils.blueprintVersionIsNotEditable(signoffConfigurationId.blueprintVersionId)) {
            throw new ValidationException("Cannot delete a sign-off configuration with ID `" + String.valueOf(signoffConfigurationId) + "` for a non-custom blueprint version `" + String.valueOf(signoffConfigurationId.blueprintVersionId) + "`");
        }
        this.signoffsDataService.deleteSignoffConfiguration(signoffConfigurationId);
    }

    private SignoffConfiguration mergeSignoffConfigurations(SignoffConfiguration previousConfiguration, SignoffConfiguration targetConfiguration, String userIdentifier) {
        SignoffConfiguration finalConfiguration = new SignoffConfiguration();
        finalConfiguration.id = targetConfiguration.id;
        finalConfiguration.title = targetConfiguration.title;
        finalConfiguration.description = targetConfiguration.description;
        finalConfiguration.mandatory = targetConfiguration.mandatory;
        finalConfiguration.recurrenceConfiguration = targetConfiguration.recurrenceConfiguration;
        for (SignoffUser targetApprover : targetConfiguration.approvers) {
            Optional<SignoffUser> previousApprover = previousConfiguration.approvers.stream().filter(user -> user.usersContainer.equals(targetApprover.usersContainer)).findFirst();
            if (previousApprover.isPresent()) {
                finalConfiguration.approvers.add(previousApprover.get());
                continue;
            }
            targetApprover.updateAddedBy(userIdentifier);
            finalConfiguration.approvers.add(targetApprover);
        }
        for (SignoffUsersGroup targetUsersGroup : targetConfiguration.feedbackUsersGroups) {
            SignoffUsersGroup finalUsersGroup = new SignoffUsersGroup();
            finalUsersGroup.id = targetUsersGroup.id;
            finalUsersGroup.title = targetUsersGroup.title;
            Optional<SignoffUsersGroup> previousGroup = previousConfiguration.findFeedbackGroupById(targetUsersGroup.id);
            if (previousGroup.isPresent()) {
                Map previousGroupsUsersContainers = previousGroup.get().users.stream().collect(Collectors.toMap(user -> user.usersContainer, Function.identity()));
                for (SignoffUser targetUser : targetUsersGroup.users) {
                    SignoffUser previousSignoffUser = (SignoffUser)previousGroupsUsersContainers.get(targetUser.usersContainer);
                    if (previousSignoffUser != null) {
                        finalUsersGroup.users.add(previousSignoffUser);
                        continue;
                    }
                    targetUser.updateAddedBy(userIdentifier);
                    finalUsersGroup.users.add(targetUser);
                }
            } else {
                targetUsersGroup.users.forEach(user -> user.updateAddedBy(userIdentifier));
                finalUsersGroup.users.addAll(targetUsersGroup.users);
            }
            finalConfiguration.feedbackUsersGroups.add(finalUsersGroup);
        }
        return finalConfiguration;
    }

    private SignoffConfiguration validateAndStoreBlueprintVersionSignoffConfigurations(SignoffConfiguration signoffConfiguration, boolean creation, UsersContainersValidationConfig usersContainersValidationConfig) throws IOException {
        this.signoffsValidationService.validateSignoffConfigurationAndFixUsersContainers(signoffConfiguration, usersContainersValidationConfig);
        return this.signoffsDataService.storeSignoffConfiguration(signoffConfiguration, creation);
    }

    private void prepareSignoffConfigurationForImport(SignoffConfiguration signoffConfiguration, final String userIdentifier) {
        signoffConfiguration.accept(new ISignoffConfigurationVisitor(){

            @Override
            public void visit(SignoffConfiguration signoffConfiguration) {
                AdminSignoffConfigurationsService.this.prepareSignoffUserListForImport(signoffConfiguration.approvers, userIdentifier);
            }

            @Override
            public void visit(SignoffUsersGroup signoffUsersGroup) {
                AdminSignoffConfigurationsService.this.prepareSignoffUserListForImport(signoffUsersGroup.users, userIdentifier);
            }
        });
    }

    private void prepareSignoffUserListForImport(List<SignoffUser> signoffUserList, String userIdentifier) {
        if (CollectionUtils.isNotEmpty(signoffUserList)) {
            signoffUserList.forEach(signoffUser -> signoffUser.updateAddedBy(userIdentifier));
        }
    }
}

