/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.api.auth;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.dataiku.common.server.APIKeyBase;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.ApiKeyUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.core.services.security.mappings.IUsersMappingsService;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.security.model.AbstractGlobalScopePublicAPIKey;
import com.dataiku.gh.security.model.GlobalScopePublicAPIKeyWithGroups;
import com.dataiku.gh.security.model.LegacyGlobalScopePublicAPIKey;
import com.dataiku.gh.security.model.PersonalPublicAPIKey;
import com.dataiku.gh.server.services.PubSubService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PublicAPIKeysService {
    private static final long DAY_IN_MILLIS = 86400000L;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TransactionService transactionService;
    private final Map<LookupKey, LegacyGlobalScopePublicAPIKey> inMemoryKeys = new HashMap<LookupKey, LegacyGlobalScopePublicAPIKey>();
    private Map<LookupKey, PublicAPIKey> cachedKeys;
    public static final String GLOBAL_FILENAME = "public-apikeys.json";
    public static final String PERSONAL_FILENAME = "personal-apikeys.json";
    private long globalFileTs;
    private long personalFileTs;
    public boolean standalone;
    static Logger logger = Logger.getLogger((String)"dip.services.apikeys");

    private synchronized void dropCache() {
        this.cachedKeys = null;
    }

    private synchronized void putInCache(PublicAPIKey key) {
        this.cachedKeys.put(new LookupKey(null, key.id), key);
    }

    private synchronized void fillCacheIfNeeded() throws IOException {
        Object list;
        RelFile rf;
        if (this.standalone) {
            return;
        }
        if (this.haveFilesBeenModified()) {
            logger.warn((Object)"Invalidating API keys cache");
            this.cachedKeys = null;
            this.resetRefTs();
        }
        if (this.cachedKeys != null) {
            return;
        }
        TransactionRef tr = TransactionContext.retrieveRead();
        this.cachedKeys = new HashMap<LookupKey, PublicAPIKey>();
        try {
            rf = RelFile.global((String)GLOBAL_FILENAME);
            if (tr.exists(rf)) {
                list = (AbstractGlobalScopePublicAPIKey.KeyList)tr.readObject(rf, AbstractGlobalScopePublicAPIKey.KeyList.class);
                Iterator<Object> iterator = ((ArrayList)list).iterator();
                while (iterator.hasNext()) {
                    AbstractGlobalScopePublicAPIKey abstractGlobalScopePublicAPIKey = (AbstractGlobalScopePublicAPIKey)((Object)iterator.next());
                    this.putInCache(abstractGlobalScopePublicAPIKey);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to read global keys", (Throwable)e);
            this.dropCache();
        }
        try {
            rf = RelFile.global((String)PERSONAL_FILENAME);
            if (tr.exists(rf)) {
                list = (PersonalPublicAPIKey.ListFile)tr.readObject(rf, PersonalPublicAPIKey.ListFile.class);
                for (PersonalPublicAPIKey personalPublicAPIKey : ((PersonalPublicAPIKey.ListFile)list).keys) {
                    this.putInCache(personalPublicAPIKey);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to read global keys", (Throwable)e);
            this.dropCache();
        }
        if (this.cachedKeys != null) {
            logger.info((Object)("Put in cache " + this.cachedKeys.size() + " entries"));
        }
    }

    private boolean haveFilesBeenModified() throws IOException {
        RelFile globalrf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (tr.isFile(globalrf = RelFile.global((String)GLOBAL_FILENAME)) && tr.getLastModified(globalrf) != this.globalFileTs) {
            return true;
        }
        RelFile personalrf = RelFile.global((String)PERSONAL_FILENAME);
        return tr.isFile(personalrf) && tr.getLastModified(personalrf) != this.personalFileTs;
    }

    private void resetRefTs() throws IOException {
        RelFile personalrf;
        RelFile globalrf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (tr.isFile(globalrf = RelFile.global((String)GLOBAL_FILENAME))) {
            this.globalFileTs = tr.getLastModified(globalrf);
        }
        if (tr.isFile(personalrf = RelFile.global((String)PERSONAL_FILENAME))) {
            this.personalFileTs = tr.getLastModified(personalrf);
        }
    }

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init API keys service");
        DSSMetrics.registry().register("dku.apikeys.inMemoryKeys.total", (Metric)new Gauge<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer getValue() {
                PublicAPIKeysService publicAPIKeysService = PublicAPIKeysService.this;
                synchronized (publicAPIKeysService) {
                    return PublicAPIKeysService.this.inMemoryKeys.size() / 2;
                }
            }
        });
        logger.debug((Object)"Done init API keys service");
    }

    public synchronized List<AbstractGlobalScopePublicAPIKey> listGlobalAPIKeys() throws IOException {
        RelFile rf = RelFile.global((String)GLOBAL_FILENAME);
        TransactionRef tr = TransactionContext.retrieveRead();
        AbstractGlobalScopePublicAPIKey.KeyList keys = (AbstractGlobalScopePublicAPIKey.KeyList)tr.readObject(rf, AbstractGlobalScopePublicAPIKey.KeyList.class);
        if (ApiKeyUtils.useHashedApiKeys()) {
            keys.forEach(APIKeyBase::redactKeySecret);
        }
        return keys.stream().filter(key -> !key.isManagedKey()).collect(Collectors.toList());
    }

    public synchronized AbstractGlobalScopePublicAPIKey createGlobalAPIKey(AbstractGlobalScopePublicAPIKey newKey) throws IOException {
        newKey.id = SecretKeyGenerator.generate((int)16);
        if (StringUtils.isBlank((String)newKey.key)) {
            newKey.key = ApiKeyUtils.generateApiKeySecret();
        }
        newKey.createdOn = new Date().getTime();
        newKey.managedKey = false;
        RelFile rf = RelFile.global((String)GLOBAL_FILENAME);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AbstractGlobalScopePublicAPIKey keyCopy = newKey.deepCopy();
        keyCopy.key = ApiKeyUtils.hashIfNecessary((String)keyCopy.key);
        keyCopy.expiresOn = keyCopy.expiry > 0 ? keyCopy.createdOn + (long)keyCopy.expiry * 86400000L : 0L;
        AbstractGlobalScopePublicAPIKey.KeyList list = (AbstractGlobalScopePublicAPIKey.KeyList)t.readObject(rf, AbstractGlobalScopePublicAPIKey.KeyList.class);
        list.add(keyCopy);
        t.writeObject(rf, (Object)list);
        this.dropCache();
        this.fillCacheIfNeeded();
        if (!this.standalone) {
            this.cachedKeys.put(new LookupKey(newKey.key, null), keyCopy);
        }
        this.onGlobalAPIKeyCreate(keyCopy);
        return newKey;
    }

    public AbstractGlobalScopePublicAPIKey getGlobalAPIKeyById(String keyId) throws IOException {
        return this.getGlobalAPIKeyByIdInternal(keyId, !ApiKeyUtils.useHashedApiKeys());
    }

    public AbstractGlobalScopePublicAPIKey getGlobalAPIKeyByIdWithSecret(String keyId) throws IOException {
        return this.getGlobalAPIKeyByIdInternal(keyId, true);
    }

    private synchronized AbstractGlobalScopePublicAPIKey getGlobalAPIKeyByIdInternal(String keyId, boolean withSecret) throws IOException {
        RelFile rf = RelFile.global((String)GLOBAL_FILENAME);
        TransactionRef t = TransactionContext.retrieveRead();
        AbstractGlobalScopePublicAPIKey.KeyList list = (AbstractGlobalScopePublicAPIKey.KeyList)t.readObject(rf, AbstractGlobalScopePublicAPIKey.KeyList.class);
        for (AbstractGlobalScopePublicAPIKey key : list) {
            if (!key.id.equals(keyId)) continue;
            if (!withSecret) {
                key.redactKeySecret();
            }
            return key;
        }
        throw ErrorContext.iae((String)"Key not found");
    }

    public synchronized AbstractGlobalScopePublicAPIKey getGlobalAPIKeyFromKey(String keyKey) throws IOException {
        RelFile rf = RelFile.global((String)GLOBAL_FILENAME);
        TransactionRef t = TransactionContext.retrieveRead();
        AbstractGlobalScopePublicAPIKey.KeyList list = (AbstractGlobalScopePublicAPIKey.KeyList)t.readObject(rf, AbstractGlobalScopePublicAPIKey.KeyList.class);
        for (AbstractGlobalScopePublicAPIKey key : list) {
            if (!ApiKeyUtils.compareKeySecret((String)keyKey, (String)key.getKey())) continue;
            if (ApiKeyUtils.useHashedApiKeys()) {
                key.redactKeySecret();
            }
            return key;
        }
        throw ErrorContext.iae((String)"Key not found");
    }

    public void updateGlobalAPIKeyByKey(String keyToFind, AbstractGlobalScopePublicAPIKey updatedKey) throws IOException {
        this.updateGlobalAPIKey(updatedKey, key -> key.getKey().equals(keyToFind));
    }

    public void updateGlobalAPIKeyById(AbstractGlobalScopePublicAPIKey updatedKey) throws IOException {
        this.updateGlobalAPIKey(updatedKey, key -> key.id.equals(updatedKey.id));
    }

    private synchronized void updateGlobalAPIKey(AbstractGlobalScopePublicAPIKey updatedKey, Predicate<AbstractGlobalScopePublicAPIKey> keyFilter) throws IOException {
        RelFile rf = RelFile.global((String)GLOBAL_FILENAME);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AbstractGlobalScopePublicAPIKey.KeyList list = (AbstractGlobalScopePublicAPIKey.KeyList)t.readObject(rf, AbstractGlobalScopePublicAPIKey.KeyList.class);
        int foundIdx = -1;
        for (int i = 0; i < list.size(); ++i) {
            AbstractGlobalScopePublicAPIKey _fk = (AbstractGlobalScopePublicAPIKey)((Object)list.get(i));
            if (!keyFilter.test(_fk)) continue;
            if (updatedKey instanceof LegacyGlobalScopePublicAPIKey && _fk instanceof GlobalScopePublicAPIKeyWithGroups) {
                throw ErrorContext.iae((String)"Converting a global API key with groups into a global API key without groups is not allowed");
            }
            foundIdx = i;
            updatedKey.key = _fk.key;
            updatedKey.managedKey = _fk.managedKey;
            break;
        }
        if (foundIdx == -1) {
            throw ErrorContext.iae((String)"Key to update not found");
        }
        updatedKey.expiresOn = updatedKey.expiry > 0 ? updatedKey.createdOn + (long)updatedKey.expiry * 86400000L : 0L;
        list.set(foundIdx, updatedKey);
        t.writeObject(rf, (Object)list);
        this.dropCache();
        this.fillCacheIfNeeded();
        this.onGlobalAPIKeySave(updatedKey);
    }

    public AbstractGlobalScopePublicAPIKey deleteGlobalAPIKeyByKey(String keyKey) throws IOException {
        return this.deleteGlobalAPIKey(key -> ApiKeyUtils.compareKeySecret((String)keyKey, (String)key.getKey()));
    }

    public AbstractGlobalScopePublicAPIKey deleteGlobalAPIKeyById(String keyId) throws IOException {
        return this.deleteGlobalAPIKey(key -> key.id.equals(keyId));
    }

    private synchronized AbstractGlobalScopePublicAPIKey deleteGlobalAPIKey(Predicate<AbstractGlobalScopePublicAPIKey> keyFilter) throws IOException {
        RelFile rf = RelFile.global((String)GLOBAL_FILENAME);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AbstractGlobalScopePublicAPIKey.KeyList list = (AbstractGlobalScopePublicAPIKey.KeyList)t.readObject(rf, AbstractGlobalScopePublicAPIKey.KeyList.class);
        int foundIdx = -1;
        AbstractGlobalScopePublicAPIKey foundKey = null;
        for (int i = 0; i < list.size(); ++i) {
            foundKey = (AbstractGlobalScopePublicAPIKey)((Object)list.get(i));
            if (foundKey.isManagedKey() || !keyFilter.test(foundKey)) continue;
            foundIdx = i;
            break;
        }
        if (foundIdx == -1) {
            throw ErrorContext.iae((String)"Key to delete not found");
        }
        list.remove(foundIdx);
        t.writeObject(rf, (Object)list);
        this.dropCache();
        this.fillCacheIfNeeded();
        this.onGlobalAPIKeyDelete(foundKey.id);
        return foundKey;
    }

    public synchronized List<LegacyGlobalScopePublicAPIKey> listInMemoryAPIKeys() {
        return this.inMemoryKeys.values().stream().distinct().filter(key -> !ApiKeyUtils.isInMemoryKeyExpired((APIKeyBase)key)).map(LegacyGlobalScopePublicAPIKey::deepCopy).peek(APIKeyBase::redactKeySecret).collect(Collectors.toList());
    }

    public synchronized void invalidateInMemoryAPIKeys() {
        this.inMemoryKeys.clear();
    }

    public synchronized LegacyGlobalScopePublicAPIKey getInMemoryAPIKey(String requestedBy, String label, String dssUserForImpersonation, UsersDAO.GroupPermissions permissions) {
        List<LegacyGlobalScopePublicAPIKey> expiredKeys = ((Stream)this.inMemoryKeys.values().stream().distinct().parallel()).filter(ApiKeyUtils::isInMemoryKeyExpired).collect(Collectors.toList());
        expiredKeys.forEach(key -> {
            this.inMemoryKeys.remove((Object)new LookupKey(key.key, null));
            this.inMemoryKeys.remove((Object)new LookupKey(null, key.id));
        });
        Optional<LegacyGlobalScopePublicAPIKey> optionalPublicAPIKey = ((Stream)this.inMemoryKeys.values().stream().distinct().parallel()).filter(ApiKeyUtils::isInMemoryKeyValid).filter(k -> k.createdBy.equals(requestedBy) && StringUtils.equals((String)k.dssUserForImpersonation, (String)dssUserForImpersonation) && k.getGlobalPermissions().hasSameResolvedPermissionsAs(permissions)).findFirst();
        if (optionalPublicAPIKey.isPresent()) {
            return optionalPublicAPIKey.get();
        }
        LegacyGlobalScopePublicAPIKey newKey = new LegacyGlobalScopePublicAPIKey();
        newKey.label = label;
        newKey.createdBy = requestedBy.isEmpty() ? "pintercom" : requestedBy;
        newKey.createdOn = new Date().getTime();
        newKey.setGlobalPermissions(permissions);
        newKey.dssUserForImpersonation = dssUserForImpersonation;
        newKey.id = ApiKeyUtils.generateInMemoryApiKeyId();
        newKey.key = ApiKeyUtils.generateInMemoryApiKeySecret();
        this.inMemoryKeys.put(new LookupKey(null, newKey.id), newKey);
        this.inMemoryKeys.put(new LookupKey(newKey.key, null), newKey);
        logger.info((Object)("Created new in-memory public API key: " + newKey.id + " (for " + newKey.createdBy + ")"));
        DSSMetrics.registry().meter("dku.apikeys.inMemoryKeys.created").mark();
        return newKey;
    }

    public synchronized LegacyGlobalScopePublicAPIKey getInMemoryAPIKey(String requestedBy, String label, String dssUserForImpersonation) {
        return this.getInMemoryAPIKey(requestedBy, label, dssUserForImpersonation, new UsersDAO.GroupPermissions().withAdmin(true));
    }

    public void putInMemoryAPIKeyInThePast(String keyId) {
        LegacyGlobalScopePublicAPIKey imk = this.inMemoryKeys.get((Object)new LookupKey(null, keyId));
        imk.createdOn -= 86400000L;
    }

    public synchronized List<PersonalPublicAPIKey> listMyPersonalAPIKeys(AuthCtx ctx) throws IOException {
        if (ctx.getAuthSource() != AuthCtx.AuthSource.USER_FROM_UI) {
            throw new SecurityException("Only users may do this");
        }
        RelFile rf = RelFile.global((String)PERSONAL_FILENAME);
        TransactionRef tr = TransactionContext.retrieveRead();
        ArrayList<PersonalPublicAPIKey> list = new ArrayList<PersonalPublicAPIKey>();
        for (PersonalPublicAPIKey pu : ((PersonalPublicAPIKey.ListFile)tr.readObjectDefault((RelFile)rf, PersonalPublicAPIKey.ListFile.class)).keys) {
            if (!pu.user.equals(ctx.getAssociatedDSSUser())) continue;
            if (ApiKeyUtils.useHashedApiKeys()) {
                pu.redactKeySecret();
            }
            list.add(pu);
        }
        return list;
    }

    public synchronized PersonalPublicAPIKey createPersonalAPIKey(AuthCtx ctx, String label, String description) throws IOException {
        switch (ctx.getAuthSource()) {
            case USER_FROM_UI: {
                return this.createPersonalAPIKeyInternal(ctx, ctx.getAssociatedDSSUser(), label, description);
            }
        }
        throw new SecurityException("Only users may do this");
    }

    public synchronized void updatePersonalAPIKey(String keyId, String label, String description) throws IOException {
        RelFile rf = RelFile.global((String)PERSONAL_FILENAME);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        PersonalPublicAPIKey.ListFile list = (PersonalPublicAPIKey.ListFile)tr.readObjectDefault(rf, PersonalPublicAPIKey.ListFile.class);
        int foundIdx = -1;
        PersonalPublicAPIKey foundKey = null;
        for (int i = 0; i < list.keys.size(); ++i) {
            PersonalPublicAPIKey apiKey = list.keys.get(i);
            if (!apiKey.id.equals(keyId)) continue;
            foundIdx = i;
            foundKey = apiKey;
            break;
        }
        if (foundIdx == -1 || foundKey == null) {
            throw ErrorContext.iae((String)"Key to update not found");
        }
        foundKey.label = label;
        foundKey.description = description;
        list.keys.set(foundIdx, foundKey);
        tr.writeObject(rf, (Object)list);
        this.dropCache();
        this.fillCacheIfNeeded();
    }

    private synchronized void updatePersonalAPIKeysExpiry() throws IOException {
        RelFile rf = RelFile.global((String)PERSONAL_FILENAME);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        PersonalPublicAPIKey.ListFile list = (PersonalPublicAPIKey.ListFile)tr.readObjectDefault(rf, PersonalPublicAPIKey.ListFile.class);
        int foundIdx = -1;
        Object foundKey = null;
        long expiryInDays = this.getApiKeysExpiryInMillis();
        for (int i = 0; i < list.keys.size(); ++i) {
            PersonalPublicAPIKey apiKey = list.keys.get(i);
            apiKey.expiresOn = expiryInDays > 0L ? apiKey.createdOn + expiryInDays : 0L;
            list.keys.set(i, apiKey);
        }
        tr.writeObject(rf, (Object)list);
    }

    public synchronized PersonalPublicAPIKey createPersonalAPIKeyInternal(AuthCtx ctx, String user, String label, String description) throws IOException {
        return this.createPersonalAPIKeyInternal(ctx, user, label, description, null);
    }

    public synchronized PersonalPublicAPIKey createPersonalAPIKeyInternal(AuthCtx ctx, String user, String label, String description, @Nullable String secret) throws IOException {
        PersonalPublicAPIKey pu = new PersonalPublicAPIKey();
        pu.label = label;
        pu.id = SecretKeyGenerator.generate((int)16);
        pu.key = StringUtils.isNotBlank((String)secret) ? secret : ApiKeyUtils.generateApiKeySecret();
        pu.description = description;
        pu.createdOn = new Date().getTime();
        pu.createdBy = ctx.getAssociatedDSSUser();
        pu.user = user;
        long apiKeyExpiryInMillis = this.getApiKeysExpiryInMillis();
        if (apiKeyExpiryInMillis > 0L) {
            pu.expiresOn = pu.createdOn + apiKeyExpiryInMillis;
        }
        PersonalPublicAPIKey keyCopy = pu.deepCopy();
        keyCopy.key = ApiKeyUtils.hashIfNecessary((String)keyCopy.key);
        RelFile rf = RelFile.global((String)PERSONAL_FILENAME);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        PersonalPublicAPIKey.ListFile list = (PersonalPublicAPIKey.ListFile)tr.readObjectDefault(rf, PersonalPublicAPIKey.ListFile.class);
        list.keys.add(keyCopy);
        tr.writeObject(rf, (Object)list);
        this.dropCache();
        this.fillCacheIfNeeded();
        if (!this.standalone) {
            this.cachedKeys.put(new LookupKey(pu.key, null), keyCopy);
        }
        return pu;
    }

    public synchronized PersonalPublicAPIKey deletePersonalAPIKeyById(String id) throws IOException {
        RelFile rf = RelFile.global((String)PERSONAL_FILENAME);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        PersonalPublicAPIKey.ListFile list = (PersonalPublicAPIKey.ListFile)t.readObjectDefault(rf, PersonalPublicAPIKey.ListFile.class);
        int foundIdx = -1;
        PersonalPublicAPIKey foundKey = null;
        for (int i = 0; i < list.keys.size(); ++i) {
            foundKey = list.keys.get(i);
            if (!foundKey.id.equals(id)) continue;
            foundIdx = i;
            break;
        }
        if (foundKey == null) {
            throw ErrorContext.iae((String)"Key to delete not found");
        }
        list.keys.remove(foundIdx);
        t.writeObject(rf, (Object)list);
        this.dropCache();
        this.fillCacheIfNeeded();
        return foundKey;
    }

    public synchronized PublicAPIKey getKey(String key) throws IOException {
        LegacyGlobalScopePublicAPIKey globalScopePublicAPIKey = this.inMemoryKeys.get((Object)new LookupKey(key, null));
        if (globalScopePublicAPIKey != null && !ApiKeyUtils.isInMemoryKeyExpired((APIKeyBase)globalScopePublicAPIKey)) {
            return globalScopePublicAPIKey;
        }
        this.fillCacheIfNeeded();
        if (this.cachedKeys == null) {
            logger.warn((Object)"No cached keys !");
            return null;
        }
        return this.getKeyFromCache(key);
    }

    private PublicAPIKey getKeyFromCache(String key) {
        PublicAPIKey foundKey = this.cachedKeys.get((Object)new LookupKey(key, null));
        if (foundKey != null && this.isApiKeyValid(foundKey)) {
            return foundKey;
        }
        for (PublicAPIKey cachedKey : this.cachedKeys.values()) {
            if (!StringUtils.isNotBlank((String)cachedKey.key) || !this.isApiKeyValid(cachedKey) || !ApiKeyUtils.compareKeySecret((String)key, (String)cachedKey.key)) continue;
            this.cachedKeys.put(new LookupKey(key, null), cachedKey);
            return cachedKey;
        }
        return null;
    }

    public synchronized PublicAPIKey getKeyById(String id) throws IOException {
        if (id.startsWith("dkuimk-")) {
            LegacyGlobalScopePublicAPIKey globalScopePublicAPIKey = this.inMemoryKeys.get((Object)new LookupKey(null, id));
            if (globalScopePublicAPIKey != null && !ApiKeyUtils.isInMemoryKeyExpired((APIKeyBase)globalScopePublicAPIKey)) {
                return globalScopePublicAPIKey;
            }
            return null;
        }
        this.fillCacheIfNeeded();
        if (this.cachedKeys == null) {
            logger.warn((Object)"No cached keys !");
            return null;
        }
        PublicAPIKey key = this.cachedKeys.get((Object)new LookupKey(null, id));
        return this.isApiKeyValid(key) ? key : null;
    }

    public synchronized List<PersonalPublicAPIKey> getPersonalKeys() throws IOException {
        RelFile rf = RelFile.global((String)PERSONAL_FILENAME);
        TransactionRef tr = TransactionContext.retrieveRead();
        List<PersonalPublicAPIKey> keys = ((PersonalPublicAPIKey.ListFile)tr.readObjectDefault((RelFile)rf, PersonalPublicAPIKey.ListFile.class)).keys;
        if (ApiKeyUtils.useHashedApiKeys()) {
            keys.forEach(APIKeyBase::redactKeySecret);
        }
        return keys;
    }

    public Optional<PersonalPublicAPIKey> getPersonalKeyById(String id) throws IOException {
        return this.getPersonalKeys().stream().filter(key -> key.id.equals(id)).findAny();
    }

    private boolean isApiKeyValid(PublicAPIKey key) {
        return key.expiresOn == 0L || key.expiresOn > System.currentTimeMillis();
    }

    private long getApiKeysExpiryInMillis() {
        return (long)ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().security.apiKeysLifetimeDays * 86400000L;
    }

    public synchronized void updateApiKeysLifetime() throws Exception {
        this.updatePersonalAPIKeysExpiry();
        this.dropCache();
        this.fillCacheIfNeeded();
    }

    private void onGlobalAPIKeyCreate(AbstractGlobalScopePublicAPIKey apiKey) throws IOException {
        if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.GOVERN) {
            ((IUsersMappingsService)SpringUtils.getBean(IUsersMappingsService.class)).onGlobalAPIKeyCreate(apiKey);
        }
    }

    private void onGlobalAPIKeySave(AbstractGlobalScopePublicAPIKey apiKey) throws IOException {
        if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.GOVERN) {
            ((IUsersMappingsService)SpringUtils.getBean(IUsersMappingsService.class)).onGlobalAPIKeySave(apiKey);
        }
    }

    private void onGlobalAPIKeyDelete(String apiKeyId) throws IOException {
        if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.GOVERN) {
            ((IUsersMappingsService)SpringUtils.getBean(IUsersMappingsService.class)).onGlobalAPIKeyDelete(apiKeyId);
        }
    }

    private static class LookupKey
    extends ImmutableValueObject {
        final String key;
        final String id;

        LookupKey(String key, String id) {
            this.key = key;
            this.id = id;
        }
    }
}

