/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip;

import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class SmartObjectRef {
    public String objectId;
    public ITaggingService.TaggableType objectType;
    @Nullable
    public String projectKey;
    private static Set<ITaggingService.TaggableType> typesAllowingPointInName = Sets.newHashSet((Object[])new ITaggingService.TaggableType[]{ITaggingService.TaggableType.RECIPE});

    public SmartObjectRef(@Nullable String projectKey, ITaggingService.TaggableType objectType, String objectId) {
        this.projectKey = projectKey;
        this.objectType = objectType;
        this.objectId = objectId;
    }

    public SmartObjectRef(ITaggingService.TaggableType objectType, String objectId) {
        this(null, objectType, objectId);
    }

    public static SmartObjectRef localRef(ITaggingService.TaggableType objectType, String objectId) {
        return new SmartObjectRef(objectType, objectId);
    }

    public static SmartObjectRef fromResolved(ITaggingService.TaggableType objectType, String projectKey, String objectId, String contextProjectKey) {
        if (contextProjectKey.equals(projectKey)) {
            return new SmartObjectRef(objectType, objectId);
        }
        return new SmartObjectRef(projectKey, objectType, objectId);
    }

    public static SmartObjectRef fromSmartName(ITaggingService.TaggableType objectType, String objectSmartName) {
        if (!typesAllowingPointInName.contains((Object)objectType)) {
            SmartObjectRef.checkSmartName(objectSmartName);
        }
        if (objectSmartName.contains(".") && !typesAllowingPointInName.contains((Object)objectType)) {
            String[] chunks = StringUtils.split((String)objectSmartName, (String)".");
            return new SmartObjectRef(chunks[0], objectType, chunks[1]);
        }
        return new SmartObjectRef(objectType, objectSmartName);
    }

    private static void checkSmartName(String objectSmartName) {
        Preconditions.checkArgument((objectSmartName != null ? 1 : 0) != 0, (Object)"object name not specified");
        if (objectSmartName.startsWith(".")) {
            throw new IllegalArgumentException("DSS identifiers cannot start with '.', a project key is required");
        }
        if (objectSmartName.endsWith(".")) {
            throw new IllegalArgumentException("DSS identifiers cannot end with '.', an id is required");
        }
        if (StringUtils.countMatches((String)objectSmartName, (String)".") > 1) {
            throw new IllegalArgumentException("DSS identifiers cannot contain several dots '.'");
        }
    }

    public String toString() {
        if (this.projectKey == null) {
            return "<" + String.valueOf((Object)this.objectType) + " " + this.objectId + "/>";
        }
        return "<" + String.valueOf((Object)this.objectType) + " " + this.projectKey + "." + this.objectId + "/>";
    }

    public String getProjectKey(String contextProjectKey) {
        return this.projectKey == null ? contextProjectKey : this.projectKey;
    }

    public String getSmartName() {
        if (this.projectKey == null) {
            return this.objectId;
        }
        return this.projectKey + "." + this.objectId;
    }

    public String getFullId(String contextProjectKey) {
        return this.getProjectKey(contextProjectKey) + "." + this.objectId;
    }

    public boolean isForeign() {
        return this.projectKey != null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof SmartObjectRef)) {
            return false;
        }
        SmartObjectRef ref = (SmartObjectRef)o;
        return StringUtils.equals((String)this.projectKey, (String)ref.projectKey) && StringUtils.equals((String)this.objectId, (String)ref.objectId) && this.objectType == ref.objectType;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.projectKey).append((Object)this.objectId).append((Object)this.objectType).toHashCode();
    }

    public TaggableObjectsService.TaggableObjectRef toTaggableObjectRef(String contextProjectKey) {
        return new TaggableObjectsService.TaggableObjectRef(this.getProjectKey(contextProjectKey), this.objectType, this.objectId);
    }

    public static class SmartObjectRefWithName
    extends SmartObjectRef {
        @JSON.FileTransient
        public String objectDisplayName;
        public String savedModelMLCategory;

        public SmartObjectRefWithName(SmartObjectRef ref, String objectDisplayName) {
            super(ref.projectKey, ref.objectType, ref.objectId);
            this.objectDisplayName = objectDisplayName;
        }

        public void setSavedModelMLCategory(SavedModel sm) {
            this.savedModelMLCategory = sm.getMLCategory();
        }
    }
}

