/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DimensionalityReductionTableExtractor
implements ModelExtractor<List<List<String>>> {
    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (model instanceof ClusteringModelDetails) {
            ArrayList<List<String>> output = new ArrayList<List<String>>();
            ClusteringModelDetails clusteringModelDetails = (ClusteringModelDetails)model;
            if (clusteringModelDetails.preprocessing != null && clusteringModelDetails.preprocessing.reduce != null) {
                if (clusteringModelDetails.preprocessing.reduce.enabled) {
                    output.add(Arrays.asList("Reduction", "Perform dimensionality reduction (PCA)"));
                    output.add(Arrays.asList("Kept variance (%)", Integer.toString((int)Math.ceil(clusteringModelDetails.preprocessing.reduce.kept_variance * 100.0f))));
                } else {
                    output.add(Arrays.asList("Reduction", "Do not perform dimensionality reduction"));
                }
            } else {
                output.add(Arrays.asList("Reduction", "Do not perform dimensionality reduction"));
            }
            return output;
        }
        throw new IOException(String.format("Extractor '%s' does not support model details of type '%s'", this.getClass().getSimpleName(), model.getClass().getSimpleName()));
    }
}

