/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public interface MLFlowModelVersionInfoExtractor<T> {
    public static final SimpleDateFormat sdf = MLFlowModelVersionInfoExtractor.createUTCDateFormat();

    public static SimpleDateFormat createUTCDateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    public T extract(MLFlowModelVersionInfo var1) throws IOException;

    public static MLFlowModelVersionInfoExtractor<String> createPythonVersionExtractor() {
        return mmvi -> mmvi.pythonVersion == null ? "unknown" : mmvi.pythonVersion;
    }

    public static MLFlowModelVersionInfoExtractor<String> createTrainingDateExtractor() {
        return mmvi -> sdf.format(new Date(mmvi.timeCreated));
    }

    public static MLFlowModelVersionInfoExtractor<List<List<String>>> createFlavorTableExtractor() {
        return mmvi -> {
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("Label name");
            headers.add("Label value");
            return MLFlowModelVersionInfoExtractor.createLabelTableExtractor(headers, mmvi.flavorsLabels);
        };
    }

    public static MLFlowModelVersionInfoExtractor<List<List<String>>> createPyfuncLabelTableExtractor() {
        return mmvi -> {
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("Pyfunc flavor label name");
            headers.add("Pyfunc flavor label value");
            return MLFlowModelVersionInfoExtractor.createLabelTableExtractor(headers, mmvi.pyfuncLabels);
        };
    }

    public static List<List<String>> createLabelTableExtractor(List<String> headers, List<SimpleKeyValue> labels) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        result.add(headers);
        if (labels != null) {
            labels.forEach(label -> {
                if (label != null) {
                    result.add(Arrays.asList(label.key == null ? "" : label.key, label.value == null ? "" : label.value));
                }
            });
        }
        return result;
    }

    public static MLFlowModelVersionInfoExtractor<String> createOriginExtractor() {
        return mmvi -> mmvi.origin == null ? "mlflow" : "experiment";
    }

    public static MLFlowModelVersionInfoExtractor<String> createExperimentIdExtractor() {
        return mmvi -> mmvi.origin == null ? "unknown" : mmvi.origin.experimentId;
    }

    public static MLFlowModelVersionInfoExtractor<String> createRunIdExtractor() {
        return mmvi -> mmvi.origin == null ? "unknown" : mmvi.origin.runId;
    }

    public static MLFlowModelVersionInfoExtractor<String> createArtifactURIExtractor() {
        return mmvi -> mmvi.origin == null ? "unknown" : mmvi.origin.artifactURI;
    }
}

