/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.helpers;

import com.dataiku.dip.analysis.model.prediction.TimestepParams;
import java.io.IOException;
import java.time.Month;

public class TimeSeriesUtil {
    public static String prettyTimeStep(long numberOfTimeunits, TimestepParams.Timeunit timeunit) {
        Object prettyTimeUnit = timeunit.name().toLowerCase().replace('_', ' ');
        if (numberOfTimeunits != 1L) {
            prettyTimeUnit = (String)prettyTimeUnit + "s";
        }
        return numberOfTimeunits + " " + (String)prettyTimeUnit;
    }

    public static String prettyEndOfWeekDay(TimestepParams timestepParams) throws IOException {
        switch (timestepParams.endOfWeekDay) {
            case 1: {
                return "Sunday";
            }
            case 2: {
                return "Monday";
            }
            case 3: {
                return "Tuesday";
            }
            case 4: {
                return "Wednesday";
            }
            case 5: {
                return "Thursday";
            }
            case 6: {
                return "Friday";
            }
            case 7: {
                return "Saturday";
            }
        }
        throw new IOException("Unknown end of week day: " + timestepParams.endOfWeekDay);
    }

    public static String prettySelectedDate(TimestepParams timestepParams) throws IOException {
        Object period = "the month";
        int dayIndex = timestepParams.monthlyAlignment;
        Object day = switch (dayIndex) {
            case 0, 31 -> "Last day";
            case 1 -> "First day";
            case 21 -> dayIndex + "st";
            case 2, 22 -> dayIndex + "nd";
            case 3, 23 -> dayIndex + "rd";
            default -> dayIndex + "th";
        };
        if (timestepParams.timeunit == TimestepParams.Timeunit.QUARTER) {
            period = "the quarter ending in " + (switch (timestepParams.unitAlignment) {
                case 1 -> "Jan, Apr, Jul, Oct";
                case 2 -> "Feb, May, Aug, Nov";
                case 0, 3 -> "Mar, Jun, Sep, Dec";
                default -> throw new IOException("Unknown month for quarter of selected date: " + timestepParams.unitAlignment);
            });
        } else if (timestepParams.timeunit == TimestepParams.Timeunit.HALF_YEAR) {
            period = "the half year ending in " + (switch (timestepParams.unitAlignment) {
                case 1 -> "January and July";
                case 2 -> "February and August";
                case 3 -> "March and September";
                case 4 -> "April and October";
                case 5 -> "May and November";
                case 0, 6 -> "June and December";
                default -> throw new IOException("Unknown month for half year of selected date: " + timestepParams.unitAlignment);
            });
        } else if (timestepParams.timeunit == TimestepParams.Timeunit.YEAR) {
            int monthIndex = timestepParams.unitAlignment;
            if (monthIndex == 0) {
                monthIndex = 12;
            }
            period = Month.of(monthIndex).name();
        }
        return (String)day + " of " + (String)period;
    }
}

