/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractPythonRecipeRunner;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class PythonPredictionTrainRecipeSubrunner
extends AbstractPythonRecipeRunner {
    private final FullModelId fmi;
    private final File outModelFolder;
    private final ContainerExecRuntimeConfig predictionContainerConfig;
    private Map<String, String> envVars = new HashMap<String, String>();
    private final String[] noContainerCommandArgs;
    private final AbstractPredictionTrainingRecipePayloadParams desc;
    private final String command;
    private final RemoteRunsRegistry.ExecutionType executionType;
    private boolean automaticPermissionHandling = true;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.prediction.train");

    public PythonPredictionTrainRecipeSubrunner(JobActivity activity, FullModelId fmi, File outModelFolder, ContainerExecRuntimeConfig predictionContainerConfig, AbstractPredictionTrainingRecipePayloadParams desc, RemoteRunsRegistry.ExecutionType executionType, String command, String ... cmdArgs) {
        super(activity);
        this.fmi = fmi;
        this.outModelFolder = outModelFolder;
        this.predictionContainerConfig = predictionContainerConfig;
        this.noContainerCommandArgs = cmdArgs;
        this.desc = desc;
        this.command = command;
        this.executionType = executionType;
    }

    @Override
    protected EnvironmentStash prepareEnvStash(File tmpDir, Map<String, String> extraEnv, ContainerExecRuntimeConfig containerConfig, String envName) throws IOException, SQLException, CodedException, DKUSecurityException, InterruptedException {
        EnvironmentStash envStash = super.prepareEnvStash(tmpDir, extraEnv, containerConfig, envName);
        envStash.env.put("DKU_ENABLE_GLOBAL_EMBEDDING_CACHE", Boolean.toString(true));
        return envStash;
    }

    @Override
    public void enrichModuleProcess(ProcessBuilder builder) {
        builder.environment().putAll(this.envVars);
    }

    public void forceEnvVars(Map<String, String> envVars) {
        this.envVars = envVars;
    }

    public void disableAutomaticPermissionHandling() {
        logger.info((Object)"Disabling automatic permission handling");
        this.automaticPermissionHandling = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() throws Exception {
        JSON.prettyToFile((Object)this.desc.script, (File)new File(this.outModelFolder, "script.json"));
        if (this.automaticPermissionHandling) {
            logger.info((Object)"Automatic permission handling");
            FilesystemACLUtils.grantFSReadACLs(this.authCtxService.getAuthCtx(), this.projectKey, this.fmi.getFolderEnsuringSecurity());
            FilesystemACLUtils.grantFSFullACLs(this.authCtxService.getAuthCtx(), this.projectKey, this.outModelFolder);
        }
        String envName = this.desc.envName;
        CodeEnvModel.UsedCodeEnvRef codeEnvRef = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName);
        logger.info((Object)("Run training in code env " + StringUtils.defaultIfBlank((String)envName, (String)"built-in") + " (set at deploy-time)"));
        File additionalLogsDir = FlowJobUtils.getJobMadeDir("training-recipe", "additional-logs");
        File mainLogFile = FlowJobUtils.getJobTouchedFile("training-recipe", "python.log");
        try (AutoDelete outputTmpDir = FlowJobUtils.getTmpFolder("prediction-train-recipe", "pyrun");){
            if (this.predictionContainerConfig == null) {
                this.executeModule(envName, (File)outputTmpDir, this.command, this.noContainerCommandArgs);
                return;
            }
            List<String> readableAndWritablePaths = Collections.singletonList(this.outModelFolder.getAbsolutePath());
            switch (this.predictionContainerConfig.type) {
                case DOCKER: {
                    this.executeDockerCodeRecipe(codeEnvRef, this.predictionContainerConfig, this.outModelFolder, mainLogFile, outputTmpDir, this.executionType, JSON.json((Object)this.desc), Collections.emptyMap(), readableAndWritablePaths, readableAndWritablePaths);
                    return;
                }
                case KUBERNETES: {
                    HashMap<String, String> extraEnv = new HashMap<String, String>();
                    this.executeKubernetesCodeRecipe(codeEnvRef, this.predictionContainerConfig, this.outModelFolder, mainLogFile, additionalLogsDir, outputTmpDir, this.executionType, JSON.json((Object)this.desc), extraEnv, readableAndWritablePaths, readableAndWritablePaths, new KubernetesExecUtils.KubernetesFailureCodeProvider(){

                        @Override
                        public InfoMessage.MessageCode codeForOOMKilled() {
                            return RecipeCodes.ERR_RECIPE_ML_TRAINING_K8S_OOM;
                        }
                    });
                    return;
                }
            }
            return;
        }
    }

    @Override
    public void init() throws Exception {
    }
}

