/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.azureml;

import com.dataiku.dip.apideployer.datamodel.config.AzureMLAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deployments.AzureMLDeploymentConfigManager;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLEnvironment;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLModel;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineDeployment;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineEndpoint;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResourceIdentifier;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLVersionedResourceIdentifier;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLHttpClient;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AzureMLDataModelBuilder {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.actual.azureml.data-model-builder");

    private AzureMLDataModelBuilder() {
    }

    @Nonnull
    public static AzureMLModel buildModelFromLocalConfig(@Nonnull AzureMLAPIDeployment deployment, @Nonnull AzureMLAPIDeploymentInfra infra, @Nonnull VariablesContext vc, @Nonnull AzureMLVersionedResourceIdentifier modelId) {
        AzureMLDeploymentConfigManager deploymentConfigManager = new AzureMLDeploymentConfigManager(deployment, infra, vc);
        AzureMLModel model = new AzureMLModel(modelId);
        model.name = modelId.name;
        model.description = "Model created from DSS";
        model.tags = deploymentConfigManager.prepareTags();
        return model;
    }

    public static AzureMLModel buildModelFromRemoteConfig_NT(@Nonnull AzureMLHttpClient azureMLClient, @Nonnull AzureMLVersionedResourceIdentifier modelId) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)modelId.name) && StringUtils.isNotBlank((CharSequence)modelId.version)) {
            Optional<AzureMLModel> deployedModel = azureMLClient.retrieveModel_NT(modelId);
            if (!deployedModel.isPresent()) {
                logger.warn((Object)String.format("Model '%s' is not present in AzureML. Updating the deployment should create it.", modelId.name));
            }
            return deployedModel.orElse(null);
        }
        return null;
    }

    @Nonnull
    public static AzureMLEnvironment buildEnvironmentFromLocalConfig(@Nonnull AzureMLAPIDeployment deployment, @Nonnull AzureMLAPIDeploymentInfra infra, @Nonnull VariablesContext vc, @Nonnull AzureMLVersionedResourceIdentifier environmentId, String containerImageUri) {
        AzureMLDeploymentConfigManager deploymentConfigManager = new AzureMLDeploymentConfigManager(deployment, infra, vc);
        AzureMLEnvironment environment = new AzureMLEnvironment(environmentId, deployment.publishedServiceId);
        environment.name = environmentId.name;
        environment.description = "Environment created from DSS";
        environment.tags = deploymentConfigManager.prepareTags();
        environment.image = containerImageUri;
        return environment;
    }

    public static AzureMLEnvironment buildEnvironmentFromRemoteConfig_NT(@Nonnull AzureMLHttpClient azureMLClient, @Nonnull AzureMLVersionedResourceIdentifier environmentId) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)environmentId.name) && StringUtils.isNotBlank((CharSequence)environmentId.version)) {
            Optional<AzureMLEnvironment> deployedEnvironment = azureMLClient.retrieveEnvironment_NT(environmentId);
            if (!deployedEnvironment.isPresent()) {
                logger.warn((Object)String.format("Environment '%s' is not present in AzureML. Updating the deployment should create it.", environmentId));
            }
            return deployedEnvironment.orElse(null);
        }
        return null;
    }

    @Nonnull
    public static AzureMLOnlineEndpoint buildOnlineEndpointFromLocalConfig(@Nonnull AzureMLAPIDeployment deployment, @Nonnull AzureMLAPIDeploymentInfra infra, @Nonnull VariablesContext vc, @Nonnull AzureMLResourceIdentifier onlineEndpointId, @Nullable String onlineDeploymentName) {
        AzureMLDeploymentConfigManager deploymentConfigManager = new AzureMLDeploymentConfigManager(deployment, infra, vc);
        AzureMLOnlineEndpoint onlineEndpoint = new AzureMLOnlineEndpoint(onlineEndpointId);
        onlineEndpoint.name = onlineEndpointId.name;
        onlineEndpoint.description = "Online Endpoint created from DSS";
        onlineEndpoint.tags = deploymentConfigManager.prepareTags();
        onlineEndpoint.authMode = deploymentConfigManager.getAuthMode();
        onlineEndpoint.publicNetworkAccess = deploymentConfigManager.getMappedPublicInboundNetworkAccess();
        if (StringUtils.isNotBlank((CharSequence)onlineDeploymentName)) {
            onlineEndpoint.traffic.put(onlineDeploymentName, 100);
        }
        return onlineEndpoint;
    }

    public static AzureMLOnlineEndpoint buildOnlineEndpointFromRemoteConfig_NT(@Nonnull AzureMLHttpClient azureMLClient, @Nonnull AzureMLResourceIdentifier onlineEndpointId) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)onlineEndpointId.name)) {
            Optional<AzureMLOnlineEndpoint> deployedOnlineEndpoint = azureMLClient.retrieveOnlineEndpoint_NT(onlineEndpointId);
            if (!deployedOnlineEndpoint.isPresent()) {
                logger.trace(() -> String.format("Online Endpoint '%s' is not present in AzureML. Updating the deployment should create it.", onlineEndpointId.name));
            }
            return deployedOnlineEndpoint.orElse(null);
        }
        return null;
    }

    @Nonnull
    public static AzureMLOnlineDeployment buildOnlineDeploymentFromLocalConfig(@Nonnull AzureMLAPIDeployment deployment, @Nonnull AzureMLAPIDeploymentInfra infra, @Nonnull VariablesContext vc, @Nonnull AzureMLResourceIdentifier onlineDeploymentId, String endpointName, String modelRef, String environmentRef) {
        AzureMLDeploymentConfigManager deploymentConfigManager = new AzureMLDeploymentConfigManager(deployment, infra, vc);
        AzureMLOnlineDeployment onlineDeployment = new AzureMLOnlineDeployment(onlineDeploymentId);
        onlineDeployment.name = onlineDeploymentId.name;
        onlineDeployment.description = "Online Deployment created from DSS";
        onlineDeployment.tags = deploymentConfigManager.prepareTags();
        onlineDeployment.modelURI = modelRef;
        onlineDeployment.endpointName = endpointName;
        onlineDeployment.environment = environmentRef;
        onlineDeployment.instanceType = deploymentConfigManager.getInstanceType();
        onlineDeployment.instanceCount = deploymentConfigManager.getInstanceCount();
        onlineDeployment.appInsightsEnabled = deploymentConfigManager.getAppInsightsEnabled();
        onlineDeployment.egressPublicNetworkAccess = deploymentConfigManager.getMappedPublicOutboundNetworkAccess();
        onlineDeployment.environmentVariables = deploymentConfigManager.getEnvironmentVariablesMap();
        onlineDeployment.livenessProbe = deploymentConfigManager.getLivenessProbe();
        onlineDeployment.readinessProbe = deploymentConfigManager.getReadinessProbe();
        return onlineDeployment;
    }

    public static AzureMLOnlineDeployment buildOnlineDeploymentFromRemoteConfig_NT(@Nonnull AzureMLHttpClient azureMLClient, @Nonnull AzureMLResourceIdentifier onlineDeploymentId) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)onlineDeploymentId.name)) {
            Optional<AzureMLOnlineDeployment> deployedOnlineDeployment = azureMLClient.retrieveOnlineDeployment_NT(onlineDeploymentId);
            if (!deployedOnlineDeployment.isPresent()) {
                logger.trace(() -> String.format("Online Deployment '%s' is not present in AzureML. Updating the deployment should create it.", onlineDeploymentId.name));
            }
            return deployedOnlineDeployment.orElse(null);
        }
        return null;
    }
}

