/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.builtin;

import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Field;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.FieldList;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.StandardSQLTypeName;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;

public class AvroSchemaConverter {
    public com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Schema convertSchemaToBigQuerySchema(Schema schema) {
        return com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Schema.of((Iterable)this.convertFieldsToBigQueryFieldList(schema.getFields()));
    }

    private FieldList convertFieldsToBigQueryFieldList(List<Schema.Field> fields) {
        ArrayList<Field> bigQueryFields = new ArrayList<Field>(fields.size());
        for (Schema.Field field : fields) {
            bigQueryFields.add(this.convertFieldToBigQueryField(field));
        }
        return FieldList.of(bigQueryFields);
    }

    private Field convertFieldToBigQueryField(Schema.Field field) {
        Field.Mode bigQueryFieldMode = AvroSchemaConverter.getBigQueryFieldMode(field.schema());
        Schema effectiveSchema = AvroSchemaConverter.getEffectiveSchema(field.schema(), bigQueryFieldMode);
        Field.Builder bigQueryFieldBuilder = switch (effectiveSchema.getType()) {
            case Schema.Type.RECORD -> this.createBigQueryRecordFieldBuilder(field, effectiveSchema);
            case Schema.Type.STRING -> this.createBigQueryStringFieldBuilder(field, effectiveSchema);
            case Schema.Type.BYTES -> this.createBigQueryBytesFieldBuilder(field, effectiveSchema);
            case Schema.Type.INT -> this.createBigQueryIntFieldBuilder(field, effectiveSchema);
            case Schema.Type.LONG -> this.createBigQueryLongFieldBuilder(field, effectiveSchema);
            case Schema.Type.DOUBLE -> this.createBigQueryDoubleFieldBuilder(field);
            case Schema.Type.BOOLEAN -> this.createBigQueryBooleanFieldBuilder(field);
            default -> throw new IllegalArgumentException(String.format("Unexpected schema type: %s", effectiveSchema.getType()));
        };
        bigQueryFieldBuilder.setMode(bigQueryFieldMode);
        return bigQueryFieldBuilder.build();
    }

    private static Schema getEffectiveSchema(Schema schema, Field.Mode bigQueryFieldMode) {
        switch (bigQueryFieldMode) {
            case NULLABLE: {
                return (Schema)schema.getTypes().get(1);
            }
            case REPEATED: {
                return schema.getElementType();
            }
        }
        return schema;
    }

    private static Schema getEffectiveSchema(Schema schema) {
        return AvroSchemaConverter.getEffectiveSchema(schema, AvroSchemaConverter.getBigQueryFieldMode(schema));
    }

    private static Field.Mode getBigQueryFieldMode(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            ArrayList types = new ArrayList(schema.getTypes());
            if (types.size() != 2) {
                throw new IllegalArgumentException(String.format("Unexpected number of types in union: %d", types.size()));
            }
            Schema.Type nullSchemaType = ((Schema)types.get(0)).getType();
            if (nullSchemaType != Schema.Type.NULL) {
                throw new IllegalArgumentException(String.format("Unexpected first type of union: %s", nullSchemaType));
            }
            return Field.Mode.NULLABLE;
        }
        if (schema.getType() == Schema.Type.ARRAY) {
            return Field.Mode.REPEATED;
        }
        return Field.Mode.REQUIRED;
    }

    private Field.Builder createBigQueryRecordFieldBuilder(Schema.Field field, Schema effectiveSchema) {
        return Field.newBuilder((String)field.name(), (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (FieldList)this.convertFieldsToBigQueryFieldList(effectiveSchema.getFields()));
    }

    private Field.Builder createBigQueryStringFieldBuilder(Schema.Field field, Schema effectiveSchema) {
        StandardSQLTypeName bigQueryFieldType = "datetime".equals(effectiveSchema.getProp("logicalType")) ? StandardSQLTypeName.DATETIME : ("GEOGRAPHY".equals(effectiveSchema.getProp("sqlType")) ? StandardSQLTypeName.GEOGRAPHY : StandardSQLTypeName.STRING);
        return Field.newBuilder((String)field.name(), (StandardSQLTypeName)bigQueryFieldType, (Field[])new Field[0]);
    }

    private Field.Builder createBigQueryBytesFieldBuilder(Schema.Field field, Schema effectiveSchema) {
        if (effectiveSchema.getLogicalType() != null && "decimal".equals(effectiveSchema.getLogicalType().getName())) {
            int defaultPrecision;
            StandardSQLTypeName bigQueryFieldType;
            int scale;
            if (effectiveSchema.getObjectProp("precision") == null || effectiveSchema.getObjectProp("scale") == null) {
                throw new IllegalArgumentException("Missing bytes (decimal) schema precision and/or scale");
            }
            int precision = (Integer)effectiveSchema.getObjectProp("precision");
            if (precision <= (scale = ((Integer)effectiveSchema.getObjectProp("scale")).intValue()) + 29 && scale <= 9) {
                bigQueryFieldType = StandardSQLTypeName.NUMERIC;
                defaultPrecision = 38;
            } else {
                bigQueryFieldType = StandardSQLTypeName.BIGNUMERIC;
                defaultPrecision = 77;
            }
            Field.Builder builder = Field.newBuilder((String)field.name(), (StandardSQLTypeName)bigQueryFieldType, (Field[])new Field[0]);
            if (precision != defaultPrecision) {
                builder.setPrecision(Long.valueOf(precision));
                if (scale != 0) {
                    builder.setScale(Long.valueOf(scale));
                }
            }
            return builder;
        }
        return Field.newBuilder((String)field.name(), (StandardSQLTypeName)StandardSQLTypeName.BYTES, (Field[])new Field[0]);
    }

    private Field.Builder createBigQueryIntFieldBuilder(Schema.Field field, Schema effectiveSchema) {
        LogicalType logicalType = effectiveSchema.getLogicalType();
        if (logicalType == null) {
            throw new IllegalArgumentException("Missing int schema logicalType");
        }
        if (!"date".equals(logicalType.getName())) {
            throw new IllegalArgumentException(String.format("Unexpected int schema logicalType: %s", logicalType.getName()));
        }
        return Field.newBuilder((String)field.name(), (StandardSQLTypeName)StandardSQLTypeName.DATE, (Field[])new Field[0]);
    }

    private Field.Builder createBigQueryLongFieldBuilder(Schema.Field field, Schema effectiveSchema) {
        StandardSQLTypeName bigQueryFieldType = effectiveSchema.getLogicalType() != null && "timestamp-micros".equals(effectiveSchema.getLogicalType().getName()) ? StandardSQLTypeName.TIMESTAMP : (effectiveSchema.getLogicalType() != null && "time-micros".equals(effectiveSchema.getLogicalType().getName()) ? StandardSQLTypeName.TIME : StandardSQLTypeName.INT64);
        return Field.newBuilder((String)field.name(), (StandardSQLTypeName)bigQueryFieldType, (Field[])new Field[0]);
    }

    private Field.Builder createBigQueryDoubleFieldBuilder(Schema.Field field) {
        return Field.newBuilder((String)field.name(), (StandardSQLTypeName)StandardSQLTypeName.FLOAT64, (Field[])new Field[0]);
    }

    private Field.Builder createBigQueryBooleanFieldBuilder(Schema.Field field) {
        return Field.newBuilder((String)field.name(), (StandardSQLTypeName)StandardSQLTypeName.BOOL, (Field[])new Field[0]);
    }

    public Schema flattenSchema(Schema schema) {
        Schema effectiveSchema = AvroSchemaConverter.getEffectiveSchema(schema);
        if (effectiveSchema.getType() == Schema.Type.RECORD) {
            String name = effectiveSchema.getName();
            String doc = effectiveSchema.getDoc();
            String namespace = effectiveSchema.getNamespace();
            boolean isError = effectiveSchema.isError();
            List<Schema.Field> fields = this.flattenFields(effectiveSchema.getFields());
            return Schema.createRecord((String)name, (String)doc, (String)namespace, (boolean)isError, fields);
        }
        return effectiveSchema;
    }

    private List<Schema.Field> flattenFields(List<Schema.Field> fields) {
        ArrayList<Schema.Field> flatFields = new ArrayList<Schema.Field>(fields.size());
        for (Schema.Field field : fields) {
            flatFields.add(new Schema.Field(field.name(), this.flattenSchema(field.schema()), field.doc(), field.defaultVal()));
        }
        return flatFields;
    }
}

