/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cuspol;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.cuspol.CustomJavaPolicyHooksService;
import com.dataiku.dip.cuspol.CustomPolicyHookCodes;
import com.dataiku.dip.cuspol.CustomPolicyHooks;
import com.dataiku.dip.cuspol.ICustomPolicyHooksRegistry;
import com.dataiku.dip.cuspol.LoadedJavaPolicyHooks;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.custom.CustomLLMClientAdapter;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.plugin.tools.PluginClazzLoader;
import com.dataiku.dip.plugins.model.PluginComponentRef;
import com.dataiku.dip.projects.importexport.model.ProjectExportOptions;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.services.IPubSubService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomPolicyHooksRegistry
implements ICustomPolicyHooksRegistry {
    @Autowired
    private CustomJavaPolicyHooksService service;
    @Autowired
    private IPubSubService pubSub;
    private final Map<PluginComponentRef, LoadedJavaPolicyHooks> loadedHooksLibrary = new LinkedHashMap<PluginComponentRef, LoadedJavaPolicyHooks>();
    private List<CustomPolicyHooks> cachedPolicyHooks = new ArrayList<CustomPolicyHooks>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.custom_policy_hooks_registry");

    @PostConstruct
    public void init() throws Exception {
        DSSEventListener listener = evt -> {
            if (!ListUtils.isEqualList(evt.previousSettings.customPolicyHooksPluginComponentOrder, evt.newSettings.customPolicyHooksPluginComponentOrder)) {
                this.clearHooks();
            }
        };
        this.pubSub.subscribe("general-settings-changed", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CustomPolicyHooks> getHooks() {
        CustomPolicyHooksRegistry customPolicyHooksRegistry = this;
        synchronized (customPolicyHooksRegistry) {
            if (this.cachedPolicyHooks != null) {
                return this.cachedPolicyHooks;
            }
        }
        List<CustomPolicyHooks> hooks = this.reloadHooks();
        CustomPolicyHooksRegistry customPolicyHooksRegistry2 = this;
        synchronized (customPolicyHooksRegistry2) {
            this.cachedPolicyHooks = hooks;
            return hooks;
        }
    }

    private synchronized void clearHooks() {
        this.cachedPolicyHooks = null;
    }

    private List<CustomPolicyHooks> reloadHooks() {
        logger.info((Object)"Reloading custom policy hooks");
        List<LoadedJavaPolicyHooks> sortedHooks = this.buildSortedHooks();
        ArrayList<CustomPolicyHooks> cachedHooks = new ArrayList<CustomPolicyHooks>();
        for (LoadedJavaPolicyHooks loadedHook : sortedHooks) {
            CustomPolicyHooks hook = this.getHooksInstance(loadedHook);
            if (hook == null) continue;
            cachedHooks.add(hook);
        }
        return cachedHooks;
    }

    @Override
    public synchronized void register(LoadedJavaPolicyHooks loaded) {
        PluginComponentRef ref = new PluginComponentRef(loaded.getOwnerPluginId(), loaded.getId());
        this.loadedHooksLibrary.put(ref, loaded);
        this.clearHooks();
    }

    @Override
    public synchronized void unregister(LoadedJavaPolicyHooks loaded) {
        PluginComponentRef ref = new PluginComponentRef(loaded.getOwnerPluginId(), loaded.getId());
        this.loadedHooksLibrary.remove(ref);
        this.clearHooks();
    }

    private CustomPolicyHooks getHooksInstance(LoadedJavaPolicyHooks loaded) {
        try {
            ClassLoader classLoader = this.service.getClassloader(loaded.getType());
            CustomPolicyHooks hooks = (CustomPolicyHooks)new PluginClazzLoader(classLoader).loadClazz(loaded.desc.hooksClass);
            SpringUtils.getInstance().autowire((Object)hooks);
            return hooks;
        }
        catch (Error | Exception e) {
            logger.errorV(e, "Cannot instantiate hooks class for plugin: %s (%s). Please check for a plugin update or fix the plugin", new Object[]{loaded.getOwnerPluginId(), this.service.getPluginDesc((String)loaded.ownerPluginId).meta.label});
            return null;
        }
    }

    private synchronized List<LoadedJavaPolicyHooks> buildSortedHooks() {
        ArrayList<LoadedJavaPolicyHooks> ret = new ArrayList<LoadedJavaPolicyHooks>();
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        HashSet<PluginComponentRef> browsedRefs = new HashSet<PluginComponentRef>();
        for (PluginComponentRef pluginComponentRef : gs.customPolicyHooksPluginComponentOrder) {
            browsedRefs.add(pluginComponentRef);
            if (!this.loadedHooksLibrary.containsKey(pluginComponentRef)) continue;
            ret.add(this.loadedHooksLibrary.get(pluginComponentRef));
        }
        for (Map.Entry entry : this.loadedHooksLibrary.entrySet()) {
            if (browsedRefs.contains(entry.getKey())) continue;
            ret.add((LoadedJavaPolicyHooks)entry.getValue());
        }
        return ret;
    }

    @Override
    public void onPreDatasetCreation(AuthCtx user, SerializedDataset serializedDataset, DatasetSaveService.DatasetCreationContext creationContext) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                hook.onPreDatasetCreation(user, serializedDataset, creationContext);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot create dataset", (Throwable)e);
        }
    }

    @Override
    public void onPreDatasetRename(AuthCtx user, SerializedDataset serializedDatasetBefore, String newName) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                hook.onPreDatasetRename(user, serializedDatasetBefore, newName);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot rename dataset", (Throwable)e);
        }
        RWTransactionRef transactionRef = TransactionContext.retrieveWrite();
        transactionRef.onPostCommit(() -> {
            try {
                this.onPostDatasetRename(user, serializedDatasetBefore, newName);
            }
            catch (CodedException e) {
                logger.error((Object)"Error running onPostDatasetRename", (Throwable)e);
            }
        });
    }

    @Override
    public void onPostDatasetRename(AuthCtx user, SerializedDataset serializedDatasetBefore, String newName) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                hook.onPostDatasetRename(user, serializedDatasetBefore, newName);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot run onPostDatasetRename", (Throwable)e);
        }
    }

    @Override
    public void onPreMLModelCreation(AuthCtx user, SerializedDataset serializedDataset, AnalysisCoreParams analysis, MLTask mlTask) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                hook.onPreMLModelCreation(user, serializedDataset, analysis, mlTask);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot save object", (Throwable)e);
        }
    }

    @Override
    public void onPreSharedItemsSave(AuthCtx user, SerializedProject before, SerializedProject after) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                hook.onPreSharedItemsSave(user, before, after);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot save shared items", (Throwable)e);
        }
    }

    @Override
    public void onPreDataExport(AuthCtx user, ExportInput input, ExportParams params, ExportStatus.ExportMethod exportMethod) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                hook.onPreDataExport(user, input, params, exportMethod);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot export data", (Throwable)e);
        }
    }

    @Override
    public void onPreProjectExport(AuthCtx user, String projectKey, ProjectExportOptions exportOptions) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                hook.onPreProjectExport(user, projectKey, exportOptions);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot export project", (Throwable)e);
        }
    }

    @Override
    public void onPreConnectionSave(AuthCtx user, DSSConnection before, DSSConnection after) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                hook.onPreConnectionSave(user, before, after);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot save connection", (Throwable)e);
        }
    }

    @Override
    public void onPreObjectDelete(AuthCtx user, @Nullable TaggableObjectsService.TaggableObject taggableObject) throws CodedException {
        if (taggableObject == null) {
            return;
        }
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                hook.onPreObjectDelete(user, taggableObject);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot delete object", (Throwable)e);
        }
        RWTransactionRef transactionRef = TransactionContext.retrieveWrite();
        transactionRef.onPostCommit(() -> {
            try {
                this.onPostObjectDelete(user, taggableObject);
            }
            catch (CodedException e) {
                logger.error((Object)"Error running onPostObjectSave", (Throwable)e);
            }
        });
    }

    @Override
    public void onPostObjectDelete(AuthCtx user, @Nullable TaggableObjectsService.TaggableObject taggableObject) throws CodedException {
        if (taggableObject == null) {
            return;
        }
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                hook.onPostObjectDelete(user, taggableObject);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot run onPostObjectDelete", (Throwable)e);
        }
    }

    @Override
    public void onPreObjectSave(AuthCtx user, @Nullable TaggableObjectsService.TaggableObject before, TaggableObjectsService.TaggableObject after) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                hook.onPreObjectSave(user, before, after);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot save object", (Throwable)e);
        }
        RWTransactionRef transactionRef = TransactionContext.retrieveWrite();
        transactionRef.onPostCommit(() -> {
            try {
                this.onPostObjectSave(user, before, after);
            }
            catch (CodedException e) {
                logger.error((Object)"Error running onPostObjectSave", (Throwable)e);
            }
        });
    }

    @Override
    public void onPostObjectSave(AuthCtx user, @Nullable TaggableObjectsService.TaggableObject before, TaggableObjectsService.TaggableObject after) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                hook.onPostObjectSave(user, before, after);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot run onPostObjectSave", (Throwable)e);
        }
    }

    @Override
    public void onPreUserSave(AuthCtx user, UsersDAO.User before, UsersDAO.User after, UsersService.UserSaveContext userSaveContext) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                hook.onPreUserSave(user, before, after, userSaveContext);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot save user", (Throwable)e);
        }
    }

    @Override
    public void onPreSQLConnectionDirectUse(AuthCtx user, String contextProjectKey, String connectionName) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                hook.onPreSQLConnectionDirectUse(user, contextProjectKey, connectionName);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot use SQL connection", (Throwable)e);
        }
    }

    @Override
    public boolean hasProjectPermissions(AuthCtx user, SerializedProject project, Privileges.ProjectLevelPrivilegeType privilegeType) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                if (hook.hasProjectPermissions(user, project, privilegeType)) continue;
                return false;
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot check project permissions", (Throwable)e);
        }
        return true;
    }

    @Override
    public void onAboutToSendLLMQuery(AuthCtx user, EnrichedLLMStructuredRef llm, String contextProjectKey, AnyLoc usedDataset, LLMClient.SingleCompletionQuery query, LLMClient.CompletionSettings settings) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                if (!hook.wantsToHandleLLMCompletionQueries()) continue;
                hook.onAboutToSendLLMQuery(user, llm, contextProjectKey, usedDataset, CustomLLMClientAdapter.toLegacyFormat(query, settings));
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot send query to LLM", (Throwable)e);
        }
    }

    @Override
    public void onAboutToSendLLMQuery(AuthCtx user, EnrichedLLMStructuredRef llm, String contextProjectKey, AnyLoc usedDataset, LLMClient.EmbeddingQuery query) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                if (!hook.wantsToHandleLLMEmbeddingQueries()) continue;
                hook.onAboutToSendLLMQuery(user, llm, contextProjectKey, usedDataset, query);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot send query to LLM", (Throwable)e);
        }
    }

    @Override
    public void onLLMResponseReceived(AuthCtx user, EnrichedLLMStructuredRef llm, String contextProjectKey, AnyLoc usedDataset, LLMClient.SingleCompletionQuery query, LLMClient.CompletionSettings settings, LLMClient.SimpleCompletionResponseOrError response) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                if (!hook.wantsToHandleLLMCompletionResponses()) continue;
                hook.onLLMResponseReceived(user, llm, contextProjectKey, usedDataset, CustomLLMClientAdapter.toLegacyFormat(query, settings), response);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot send query to LLM", (Throwable)e);
        }
    }

    @Override
    public void onLLMResponseReceived(AuthCtx user, EnrichedLLMStructuredRef llm, String contextProjectKey, AnyLoc usedDataset, LLMClient.EmbeddingQuery query, LLMClient.SimpleEmbeddingResponseOrError response) throws CodedException {
        try {
            for (CustomPolicyHooks hook : this.getHooks()) {
                if (!hook.wantsToHandleLLMEmbeddingResponses()) continue;
                hook.onLLMResponseReceived(user, llm, contextProjectKey, usedDataset, query, response);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)CustomPolicyHookCodes.ERR_CUSTOM_POLICY_HOOK_ERROR, "Cannot send query to LLM", (Throwable)e);
        }
    }

    @Override
    public boolean wantsToHandleLLMCompletionQueries() {
        return this.getHooks().stream().anyMatch(h -> h.wantsToHandleLLMCompletionQueries());
    }

    @Override
    public boolean wantsToHandleLLMEmbeddingQueries() {
        return this.getHooks().stream().anyMatch(h -> h.wantsToHandleLLMEmbeddingQueries());
    }

    @Override
    public boolean wantsToHandleLLMCompletionResponses() {
        return this.getHooks().stream().anyMatch(h -> h.wantsToHandleLLMCompletionResponses());
    }

    @Override
    public boolean wantsToHandleLLMEmbeddingResponses() {
        return this.getHooks().stream().anyMatch(h -> h.wantsToHandleLLMEmbeddingResponses());
    }

    @Override
    public boolean supportsHandlingLLMStreamedCompletionResponses() {
        return this.getHooks().stream().allMatch(h -> !h.wantsToHandleLLMCompletionResponses() || h.supportsHandlingLLMStreamedCompletionResponses());
    }

    @Override
    public LLMClient.StreamedCompletionResponseConsumer getHandlerForLLMStreamedCompletionResponse() {
        final List consumers = this.getHooks().stream().flatMap(h -> {
            if (h.wantsToHandleLLMCompletionResponses()) {
                assert (h.supportsHandlingLLMStreamedCompletionResponses());
                return Stream.of(h.getHandlerForLLMStreamedCompletionResponse());
            }
            return Stream.empty();
        }).collect(Collectors.toList());
        LLMClient.StreamedCompletionResponseConsumer multiConsumer = new LLMClient.StreamedCompletionResponseConsumer(){

            @Override
            public void onStreamStarted() throws Exception {
                for (LLMClient.StreamedCompletionResponseConsumer consumer : consumers) {
                    consumer.onStreamStarted();
                }
            }

            @Override
            public void onStreamChunk(LLMClient.StreamedCompletionResponseChunk chunk) throws Exception {
                for (LLMClient.StreamedCompletionResponseConsumer consumer : consumers) {
                    consumer.onStreamChunk(chunk);
                }
            }

            @Override
            public void onStreamComplete(LLMClient.StreamedCompletionResponseFooter footer) throws Exception {
                for (LLMClient.StreamedCompletionResponseConsumer consumer : consumers) {
                    consumer.onStreamComplete(footer);
                }
            }
        };
        return multiConsumer;
    }
}

