/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.custom;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.exceptions.DuplicateComponentException;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.PluginDesc;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.IsolatedClassLoaderBuilder;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.util.Strings;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractElementService<Desc, LoadedDesc extends IElementLoadedDesc> {
    public static final String ENV_VAR_DKU_CUSTOM_RECIPE_RESOURCE_FOLDER = "DKU_CUSTOM_RECIPE_RESOURCE_FOLDER";
    public static final String ENV_VAR_DKU_CUSTOM_RESOURCE_FOLDER = "DKU_CUSTOM_RESOURCE_FOLDER";
    public static final String ENV_VAR_DKU_PLUGIN_RESOURCES = "DKU_PLUGIN_RESOURCES";
    public static final String DKU_CONTAINER_PLUGIN_FOLDER = "/home/dataiku/plugin";
    public static final String DKU_CONTAINER_PLUGIN_RESOURCE_FOLDER = "/home/dataiku/plugin/resource";
    @Autowired
    protected IPluginsRegistryService pluginsService;
    private final Cache<String, ClassLoader> classLoaderCache = CacheBuilder.newBuilder().build();
    protected Map<String, LoadedDesc> loadedDescs = Collections.synchronizedMap(new HashMap());
    private static final Logger logger = Logger.getLogger((String)"dku.plugins.code");

    public abstract String getFolderName();

    public abstract String getPrefix();

    protected abstract String getCodeExtension(LoadedDesc var1);

    protected abstract void removeElement(LoadedDesc var1);

    protected abstract String makeType(String var1, String var2);

    protected abstract LoadedDesc load(String var1, String var2, String var3, File var4) throws IOException, DuplicateComponentException;

    public abstract Class<Desc> getDescClass();

    public abstract Class<LoadedDesc> getLoadedDescClass();

    public abstract InfoMessage.InfoMessages validate(String var1, String var2, Desc var3);

    public LoadedDesc getLoadedDescByElementType(String elementType) {
        return (LoadedDesc)((IElementLoadedDesc)this.loadedDescs.get(elementType));
    }

    public LoadedDesc getLoadedDescById(String id) {
        for (Map.Entry<String, LoadedDesc> e : this.loadedDescs.entrySet()) {
            if (!((IElementLoadedDesc)e.getValue()).getId().equals(id)) continue;
            return (LoadedDesc)((IElementLoadedDesc)e.getValue());
        }
        return null;
    }

    public synchronized void removeComponentTypeForOnePlugin(String pluginId) {
        ArrayList<IElementLoadedDesc> toRemove = new ArrayList<IElementLoadedDesc>();
        for (IElementLoadedDesc desc : this.loadedDescs.values()) {
            if (!pluginId.equals(desc.getOwnerPluginId())) continue;
            toRemove.add(desc);
        }
        for (IElementLoadedDesc loaded : toRemove) {
            this.classLoaderCache.invalidate((Object)loaded.getType());
            this.loadedDescs.remove(loaded.getType());
            this.removeElement(loaded);
        }
    }

    public synchronized List<LoadedDesc> reloadComponentTypeForOnePlugin(String pluginId, File pluginDir, String typeGroup, List<InstalledPluginDesc.ComponentLoadingFailure> loadingFailures) {
        this.removeComponentTypeForOnePlugin(pluginId);
        ArrayList<LoadedDesc> inPlugin = new ArrayList<LoadedDesc>();
        File dir = new File(pluginDir, this.getFolderName());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Loading elements of type " + String.valueOf(this.getClass()) + " from  " + String.valueOf(dir)));
        }
        if (dir.isDirectory()) {
            for (File elementDirectory : dir.listFiles()) {
                File file = new File(elementDirectory, this.getPrefix() + ".json");
                if (!file.isFile()) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Loading custom code element from " + String.valueOf(elementDirectory)));
                }
                String elementId = elementDirectory.getName();
                String elementType = this.makeType(pluginId, elementId);
                String folderName = this.getFolderName() + "/" + elementDirectory.getName();
                try {
                    LoadedDesc loaded = this.load(elementType, pluginId, elementId, file);
                    loaded.setFolderName(folderName);
                    this.classLoaderCache.invalidate((Object)loaded.getType());
                    this.loadedDescs.put(loaded.getType(), loaded);
                    inPlugin.add(loaded);
                }
                catch (DuplicateComponentException | JsonSyntaxException e) {
                    logger.warn((Object)("Loading code element from " + String.valueOf(elementDirectory) + " failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    loadingFailures.add(new InstalledPluginDesc.ComponentLoadingFailure(this.getPrefix(), typeGroup, elementType, elementId, folderName, e.getMessage()));
                }
                catch (Exception e) {
                    logger.warn((Object)("Loading code element from " + String.valueOf(elementDirectory) + " failed"), (Throwable)e);
                    loadingFailures.add(new InstalledPluginDesc.ComponentLoadingFailure(this.getPrefix(), typeGroup, elementType, elementId, folderName, e.getMessage()));
                }
            }
        }
        return inPlugin;
    }

    public Collection<LoadedDesc> list() {
        return this.loadedDescs.values();
    }

    public synchronized String getCode(String elementType) throws IOException {
        if (!this.loadedDescs.containsKey(elementType)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Element " + elementType + " not found.");
        }
        IElementLoadedDesc lpd = (IElementLoadedDesc)this.loadedDescs.get(elementType);
        File pluginDir = this.pluginsService.getActualPluginFolder(lpd.getOwnerPluginId());
        File exporterDirectory = new File(new File(pluginDir, this.getFolderName()), lpd.getId());
        return FileUtils.readFileToString((File)new File(exporterDirectory, this.getPrefix() + this.getCodeExtension(lpd)), (String)"utf8");
    }

    public synchronized File getCodeFile(String elementType) {
        if (!this.loadedDescs.containsKey(elementType)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Element " + elementType + " not found.");
        }
        IElementLoadedDesc lpd = (IElementLoadedDesc)this.loadedDescs.get(elementType);
        File pluginDir = this.pluginsService.getActualPluginFolder(lpd.getOwnerPluginId());
        File exporterDirectory = new File(new File(pluginDir, this.getFolderName()), lpd.getId());
        return new File(exporterDirectory, this.getPrefix() + this.getCodeExtension(lpd));
    }

    public synchronized String getCodeFileRelativePathInPluginFolder(String elementType) {
        if (!this.loadedDescs.containsKey(elementType)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Element " + elementType + " not found.");
        }
        IElementLoadedDesc lpd = (IElementLoadedDesc)this.loadedDescs.get(elementType);
        File elementFolder = new File(this.getFolderName(), lpd.getId());
        return new File(elementFolder, this.getPrefix() + this.getCodeExtension(lpd)).getPath();
    }

    public String getResourceFolder(String elementType) {
        if (!this.loadedDescs.containsKey(elementType)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Element " + elementType + " not found.");
        }
        IElementLoadedDesc loadedDesc = (IElementLoadedDesc)this.loadedDescs.get(elementType);
        File resourceDir = this.pluginsService.getPluginResourceFolder(loadedDesc.getOwnerPluginId());
        return resourceDir.getAbsolutePath();
    }

    public void putResourceFolderEnvironmentVariable(Map<String, String> env, String type, boolean isRunningLocally, String legacyVariableName) {
        String resourceFolder;
        String string = resourceFolder = isRunningLocally ? this.getResourceFolder(type) : DKU_CONTAINER_PLUGIN_RESOURCE_FOLDER;
        if (Strings.isNotEmpty((String)resourceFolder)) {
            env.put(legacyVariableName, resourceFolder);
            env.put(ENV_VAR_DKU_CUSTOM_RESOURCE_FOLDER, resourceFolder);
        }
    }

    public PluginSettingsResolver.ResolvedSettings getExpandedPluginSettings(String elementType, AuthCtx authCtx, @Nullable String projectKey, JsonObject config) throws IOException, DKUSecurityException {
        IElementLoadedDesc loadedDesc = (IElementLoadedDesc)this.loadedDescs.get(elementType);
        config = (JsonObject)JSON.deepCopy((Object)config);
        return new PluginSettingsResolver(authCtx, projectKey).withPluginsRegistry(this.pluginsService).getPluginSettings(loadedDesc.getParams(), config, loadedDesc.getOwnerPluginId());
    }

    public synchronized ClassLoader getClassloader(String elementType) throws IOException {
        if (!this.loadedDescs.containsKey(elementType)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Element " + elementType + " not found.");
        }
        ClassLoader classLoader = (ClassLoader)this.classLoaderCache.getIfPresent((Object)elementType);
        if (classLoader == null) {
            classLoader = this.getClassloader((IElementLoadedDesc)this.loadedDescs.get(elementType));
            this.classLoaderCache.put((Object)elementType, (Object)classLoader);
        }
        return classLoader;
    }

    public synchronized ClassLoader getClassloader(LoadedDesc lpd) throws IOException {
        IsolatedClassLoaderBuilder classLoaderBuilder = new IsolatedClassLoaderBuilder();
        File libDir = this.pluginsService.getPluginJavalibFolder(lpd.getOwnerPluginId());
        classLoaderBuilder.withJarsInRecursiveDir(libDir);
        File pluginDir = this.pluginsService.getActualPluginFolder(lpd.getOwnerPluginId());
        File directory = new File(new File(pluginDir, this.getFolderName()), lpd.getId());
        File[] files = directory.listFiles(pathname -> pathname.getName().endsWith(".jar"));
        if (files != null) {
            for (File file : files) {
                classLoaderBuilder.withJarFile(file);
            }
        }
        return classLoaderBuilder.build();
    }

    public PluginDesc getPluginDesc(String pluginId) {
        return this.pluginsService.getDesc(pluginId);
    }

    public List<LoadedDesc> listDescs(String pluginId) {
        ArrayList ret = Lists.newArrayList();
        for (IElementLoadedDesc element : this.list()) {
            if (!StringUtils.equals((String)pluginId, (String)element.getOwnerPluginId())) continue;
            ret.add(element);
        }
        return ret;
    }

    public LoadedDesc getOrNull(String presetType) {
        return (LoadedDesc)((IElementLoadedDesc)this.loadedDescs.get(presetType));
    }

    public LoadedDesc getOrNull(String pluginId, String parameterSetId) {
        return this.getOrNull(this.makeType(pluginId, parameterSetId));
    }
}

