/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dao.AnalysisCoreDAO;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedAnalysisCoreDAO
extends AbstractStandardDAO<AnalysisCoreParams>
implements AnalysisCoreDAO {
    @Override
    protected AnalysisCoreParams getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile rf;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(rf = this.getDAOFile(projectKey, id))) {
            return null;
        }
        AnalysisCoreParams acp = unsafe ? (AnalysisCoreParams)t.readObjectUnsafe(rf, AnalysisCoreParams.class) : (AnalysisCoreParams)t.readObject(rf, AnalysisCoreParams.class);
        acp.id = id;
        acp.projectKey = projectKey;
        return acp;
    }

    @Override
    protected List<AnalysisCoreParams> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<AnalysisCoreParams> ret = new ArrayList<AnalysisCoreParams>();
        RelFile analysesFolder = this.analysesFolder(projectKey);
        if (!t.isDirectory(analysesFolder)) {
            return ret;
        }
        for (RelFile analysisFolder : t.listFiles(analysesFolder)) {
            RelFile params = new RelFile(analysisFolder, new String[]{"core_params.json"});
            if (!t.exists(params)) continue;
            try {
                AnalysisCoreParams acp = unsafe ? (AnalysisCoreParams)t.readObjectUnsafe(params, AnalysisCoreParams.class) : (AnalysisCoreParams)t.readObject(params, AnalysisCoreParams.class);
                acp.id = analysisFolder.getLeafName();
                acp.projectKey = projectKey;
                ret.add(acp);
            }
            catch (Exception e) {
                this.logger.warn((Object)"Failed to read analysis core params", (Throwable)e);
            }
        }
        return ret;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile analysesFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory(analysesFolder = this.analysesFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(analysesFolder).size();
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.ANALYSIS.toHumanReadableString();
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.deleteFile(this.getDAOFile(projectKey, id));
    }

    private RelFile analysesFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "analysis"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Analysis id is not specified");
        return new RelFile(this.analysesFolder(projectKey), new String[]{id, "core_params.json"});
    }
}

