/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.ExtensionFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedZonesDAO
extends AbstractStandardDAO<Zone>
implements ZonesDAO {
    @Override
    protected Zone getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile file;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(file = this.getDAOFile(projectKey, id))) {
            return null;
        }
        try {
            Zone zone = unsafe ? (Zone)t.readObjectUnsafe(file, Zone.class) : (Zone)t.readObject(file, Zone.class);
            zone.setProjectKey(projectKey);
            zone.setId(id);
            return zone;
        }
        catch (Exception e) {
            throw new IOException("Failed to parse zone " + projectKey + "." + id + " from file " + String.valueOf(file), e);
        }
    }

    @Override
    protected List<Zone> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<Zone> ret = new ArrayList<Zone>();
        RelFile zonesFolder = this.getZonesFolder(projectKey);
        if (!t.isDirectory(zonesFolder)) {
            return ret;
        }
        for (RelFile f : t.listFiles(zonesFolder, (RelFileFilter)ExtensionFilter.json())) {
            try {
                String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                Zone sd = (Zone)this.getMandatory(projectKey, id, unsafe);
                ret.add(sd);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Error in zone file:" + String.valueOf(f)), (Throwable)e);
            }
        }
        return ret;
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Zone name is not specified");
        return new RelFile(this.getZonesFolder(projectKey), new String[]{id + ".json"});
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.FLOW_ZONE.toHumanReadableString();
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RelFile file;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.isFile(file = this.getDAOFile(projectKey, id))) {
            throw new NotFoundException("Zone does not exist: " + projectKey + "." + id);
        }
        t.deleteFile(file);
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile zonesFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory(zonesFolder = this.getZonesFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(zonesFolder).size();
    }

    private RelFile getZonesFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "zones"});
    }

    @Override
    public void save(String projectKey, Zone zone) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)zone.getName()), (Object)"Name of the zone is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)zone.getColor()), (Object)"Color of the zone is not specified");
        if (zone.getId() == null || "".equals(zone.getId())) {
            zone.setId(this.generateUniqueId(projectKey));
        }
        zone.setProjectKey(projectKey);
        super.save(zone);
    }
}

