/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.sql.NonLoopingSQLEngineVisualRecipeRunner;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.code.hive.HiveConfHelper;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.hive.HiveRecipeRunner;
import com.dataiku.dip.recipes.code.impala.ImpalaExecutor;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLExecutor;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeEngineParams;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.PrestoSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class MultiEngineRecipeRunner
implements RecipeRunner,
AbortableRecipeRunner,
RecipeRunnerWithPayload,
FlowRunnable {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected VariablesService variablesService;
    @Autowired
    protected VisualSQLRecipesBaseService visualRecipesBaseService;
    @Autowired
    protected JobAuthCtxService authCtxService;
    protected AbortableRecipeRunner executor;
    protected JobActivity activity;
    protected FlowRecipe recipe;
    protected boolean abortNotified;
    protected String payload;
    static Logger logger = Logger.getLogger((String)"dku.recipe.visual");

    protected abstract String generateSQL(SQLDialect var1) throws Exception;

    protected abstract void initBuiltinExecutor(VisualSQLRecipesBaseService.SQLBasedEngineStatus var1) throws Exception;

    public MultiEngineRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        this.activity.initStatus();
    }

    @Override
    public synchronized void init() throws Exception {
        if (this.abortNotified) {
            throw new ActivityAbortedException();
        }
        SerializedRecipe.SerializedRecipeAndPayload srp = new PreRunSchemaPropagationHandler(this.activity, this.recipe).propagateIfNeeded();
        if (srp != null && srp.payload != null) {
            this.setPayload(srp.payload);
        }
        RecipeMeta meta = RecipeRegistry.getMeta(this.recipe.getModel().type);
        RecipeStatusComputer computer = meta.buildStatusComputer(this.recipe.getModel(), this.payload);
        VisualSQLRecipeStatus recipeStatus = (VisualSQLRecipeStatus)computer.fastStatusIgnorePartitions(this.authCtxService.getAuthCtx());
        this.setExecutor(recipeStatus);
    }

    protected void setExecutor(VisualSQLRecipeStatus status) throws Exception {
        VisualSQLRecipesBaseService.SQLBasedEngineStatus engineToUse = status.getSelectedSQLBasedEngine();
        if (engineToUse == null || !engineToUse.isSelectable) {
            throw new Exception("No allowed engine could be selected");
        }
        logger.info((Object)("Selected engine type: " + engineToUse.type));
        switch (engineToUse.type) {
            case "SQL": {
                JobContext.getCurrentActivitySummary().engineType = "SQL";
                this.initSqlExecutor();
                break;
            }
            case "HIVE": {
                JobContext.getCurrentActivitySummary().engineType = "HIVE";
                this.initHiveExecutor(status.engineParams.hive);
                break;
            }
            case "IMPALA": {
                JobContext.getCurrentActivitySummary().engineType = "IMPALA";
                this.initImpalaExecutor(status.engineParams.impala);
                break;
            }
            case "SPARK": {
                JobContext.getCurrentActivitySummary().engineType = "SPARK";
                this.initSparkExecutor(status.engineParams.sparkSQL);
                break;
            }
            case "DSS": {
                JobContext.getCurrentActivitySummary().engineType = "DSS";
                this.initBuiltinExecutor(engineToUse);
            }
        }
    }

    protected void initHiveExecutor(final HiveRecipeMeta.HiveRecipeParams hParams) throws Exception {
        HiveRecipeRunner hiveRunner = new HiveRecipeRunner(this.activity){

            @Override
            protected String getSql() throws Exception {
                return MultiEngineRecipeRunner.this.generateSQL(new HiveSQLDialect());
            }

            @Override
            protected String getPreQueries() throws Exception {
                return hParams.preQueries;
            }

            @Override
            protected HiveRecipeMeta.HiveExecutionEngine getExecutionEngine() throws Exception {
                return hParams.executionEngine;
            }

            @Override
            protected boolean addDkuUdf() throws Exception {
                return hParams.addDkuUdf;
            }

            @Override
            protected List<SimpleKeyValue> getExtraConf() throws IOException, DKUSecurityException {
                return new HiveConfHelper().getResolvedConf(MultiEngineRecipeRunner.this.authCtxService.getAuthCtx(), MultiEngineRecipeRunner.this.recipe.getProjectKey(), hParams);
            }

            @Override
            protected boolean canOverrideDatabase() {
                return false;
            }
        };
        SpringUtils.getInstance().autowire((Object)hiveRunner);
        hiveRunner.init();
        this.executor = hiveRunner;
    }

    protected void initImpalaExecutor(ImpalaExecutor.ImpalaExecutorParams impalaParams) throws Exception {
        ArrayList preQueries = null;
        if (!StringUtils.isBlank((String)impalaParams.preQueries)) {
            Splitter splitter = new Splitter(new ImpalaSQLDialect().getSemicolonExclusionPortionFinders());
            preQueries = Lists.newArrayList((Object[])splitter.split(impalaParams.preQueries));
        }
        ImpalaExecutor impalaExecutor = new ImpalaExecutor(this.activity, impalaParams, this.generateSQL(new ImpalaSQLDialect()), preQueries, null);
        SpringUtils.getInstance().autowire((Object)impalaExecutor);
        this.executor = impalaExecutor;
    }

    protected void initSparkExecutor(SparkSQLExecutor.SparkSQLExecutorParams sparkParams) throws Exception {
        SparkSQLExecutor sparkExecutor = new SparkSQLExecutor(this.activity, sparkParams, this.generateSQL(new SparkSQLDialect()));
        SpringUtils.getInstance().autowire((Object)sparkExecutor);
        sparkExecutor.init();
        this.executor = sparkExecutor;
    }

    protected void initSqlExecutor() throws Exception {
        NonLoopingSQLEngineVisualRecipeRunner sqlRunner = new NonLoopingSQLEngineVisualRecipeRunner(this.activity){

            @Override
            protected QueryBunch getQueryBunch(AbstractSQLConnection conn) throws Exception {
                return new QueryBunch(MultiEngineRecipeRunner.this.generateSQL(conn.getDialect()));
            }
        };
        SpringUtils.getInstance().autowire((Object)sqlRunner);
        sqlRunner.init();
        this.executor = sqlRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBeforeAborting() {
        AbortableRecipeRunner abortableRunner;
        MultiEngineRecipeRunner multiEngineRecipeRunner = this;
        synchronized (multiEngineRecipeRunner) {
            if (this.abortNotified) {
                return;
            }
            this.abortNotified = true;
            abortableRunner = this.executor;
        }
        if (abortableRunner != null) {
            abortableRunner.notifyBeforeAborting();
        }
    }

    @Override
    public void run() throws Exception {
        if (this.executor == null) {
            throw new Error("Recipe could not run, no runner selected");
        }
        Stopwatch recipeRunDuration = Stopwatch.createStarted();
        logger.info((Object)("Selected executor: " + this.executor.getClass().getName()));
        this.executor.run();
        logger.info((Object)("Recipe run time: " + recipeRunDuration.elapsed(TimeUnit.SECONDS) + " s"));
    }

    public static boolean shouldSpecifySourcePartitionInWhereClause(SQLDialect dialect, VisualSQLRecipeEngineParams engineParams) {
        if (dialect instanceof PrestoSQLDialect) {
            return true;
        }
        if (dialect instanceof HiveSQLDialect) {
            return engineParams.hive.executionEngine != HiveRecipeMeta.HiveExecutionEngine.HIVECLI_LOCAL;
        }
        if (dialect instanceof SparkSQLDialect) {
            return engineParams.sparkSQL.useGlobalMetastore;
        }
        return true;
    }
}

