/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin;

import com.dataiku.dip.dataflow.exec.geojoin.GeoUtils;
import org.geotools.filter.spatial.DWithinImpl;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.DWithin;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeodesicDwithin
extends DWithinImpl {
    private static final GeodeticCalculator calculator = new GeodeticCalculator((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    private final GeoUtils.MinMaxDegrees minMaxDegreeBounds;

    public GeodesicDwithin(Expression e1, Expression e2, double meters, String units, MultiValuedFilter.MatchAction matchAction) {
        super(e1, e2, matchAction);
        super.setDistance(meters);
        super.setUnits(units);
        Geometry geometry = GeoUtils.geometryFromLiteralExpression(e1, e2);
        this.minMaxDegreeBounds = GeoUtils.minMaxDegrees(geometry.getEnvelopeInternal(), (Double)meters);
    }

    public boolean evaluateInternal(Geometry left, Geometry right) {
        if (left == null) {
            return false;
        }
        DistanceOp op = new DistanceOp(left, right);
        if (op.distance() <= this.minMaxDegreeBounds.min) {
            return true;
        }
        if (op.distance() > this.minMaxDegreeBounds.max) {
            return false;
        }
        Coordinate[] nearestPoints = op.nearestPoints();
        Coordinate p1 = nearestPoints[0];
        Coordinate p2 = nearestPoints[1];
        calculator.setStartingGeographicPoint(p1.x, p1.y);
        calculator.setDestinationGeographicPoint(p2.x, p2.y);
        return calculator.getOrthodromicDistance() <= this.getDistance();
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        ReferencedEnvelope envelope;
        if (visitor instanceof ExtractBoundsFilterVisitor && (envelope = GeodesicDwithin.extractEnvelope(this.minMaxDegreeBounds.max, (BinarySpatialOperator)this)) != null) {
            return envelope;
        }
        return visitor.visit((DWithin)this, extraData);
    }

    public static ReferencedEnvelope extractEnvelope(double distance, BinarySpatialOperator op) {
        Expression lg = op.getExpression1();
        Expression rg = op.getExpression2();
        Geometry geom = null;
        if (lg instanceof Literal) {
            g = (Geometry)((Literal)lg).getValue();
            if (rg instanceof PropertyName) {
                geom = g;
            }
        } else if (rg instanceof Literal) {
            g = (Geometry)((Literal)rg).getValue();
            if (lg instanceof PropertyName) {
                geom = g;
            }
        }
        if (geom != null) {
            Envelope envelopeInternal = geom.getEnvelopeInternal();
            envelopeInternal.expandBy(distance);
            return new ReferencedEnvelope(envelopeInternal, null);
        }
        return null;
    }
}

