/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.pivot.AbstractPivotRecipeSQLlikeExecutor;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementsModalitiesSnapshot;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.HiveServer2ConnectionPoolService;
import com.dataiku.dip.recipes.code.hive.HiveConfHelper;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.hive.HiveRecipeRunner;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class PivotRecipeHiveExecutor
extends AbstractPivotRecipeSQLlikeExecutor {
    private static final HiveSQLDialect dialect = new HiveSQLDialect();
    private HiveRecipeMeta.HiveRecipeParams hiveParams;
    @Autowired
    protected HiveServer2ConnectionPoolService hiveServer2ConnectionPoolService;
    private static Logger logger = Logger.getLogger((String)"dip.recipe.pivot.hive.executor");

    public PivotRecipeHiveExecutor(VisualSQLRecipesBaseService.SQLBasedEngineStatus engine, JobActivity activity, PivotRecipePayloadParams params, HiveRecipeMeta.HiveRecipeParams hiveParams) {
        super(engine, activity, params);
        this.hiveParams = hiveParams;
    }

    @Override
    protected boolean schemaComparisonIsCaseSensitive() {
        return false;
    }

    @Override
    protected SQLUtils.SQLTable getSQLTable() throws IOException {
        return DatasetUtils.getResolvedTableWithSparkSQLFallback(this.inputDS, this.getInputDialect(), this.params.engineParams);
    }

    @Override
    protected SQLDialect getOutputDialect() throws IOException {
        return dialect;
    }

    @Override
    protected void execute(List<PivotElementsModalitiesSnapshot.PivotElementsModalities> pivotElementsModalities) throws Exception {
        final HiveRecipeRunnerCustom runner = new HiveRecipeRunnerCustom(pivotElementsModalities, this.activity);
        try (AutoCloseable hook = this.startAbortableTask(new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"Aborting pivoting query");
                runner.notifyBeforeAborting();
            }
        });){
            SpringUtils.getInstance().autowire((Object)runner);
            runner.init();
            runner.run();
        }
    }

    @Override
    protected SQLDialect getInputDialect() throws IOException {
        return dialect;
    }

    @Override
    protected AbstractSQLConnection getInputSQLConnection() throws IOException, DKUSecurityException {
        String inputImpalaDb = HiveSchemaHandler.getResolvedHiveDatabaseFromDataset(this.inputDS);
        List<SimpleKeyValue> hiveConf = new HiveConfHelper().getResolvedConf(this.authCtxService.getAuthCtx(), this.recipe.getModel().projectKey, this.hiveParams);
        HiveConnection connection = HiveConfigurator.configureConnectionForDatabase(this.authCtxService.getAuthCtx(), inputImpalaDb, hiveConf, this.hiveServer2ConnectionPoolService);
        return connection;
    }

    private class HiveRecipeRunnerCustom
    extends HiveRecipeRunner {
        private List<PivotElementsModalitiesSnapshot.PivotElementsModalities> pivotElementsModalities;

        public HiveRecipeRunnerCustom(List<PivotElementsModalitiesSnapshot.PivotElementsModalities> pivotElementsModalities, JobActivity activity) {
            super(activity);
            this.pivotElementsModalities = pivotElementsModalities;
        }

        @Override
        protected String getSql() throws Exception {
            return PivotRecipeHiveExecutor.this.generateSQL(this.pivotElementsModalities, dialect);
        }

        @Override
        protected String getPreQueries() throws Exception {
            return PivotRecipeHiveExecutor.this.hiveParams.preQueries;
        }

        @Override
        protected HiveRecipeMeta.HiveExecutionEngine getExecutionEngine() throws Exception {
            return PivotRecipeHiveExecutor.this.hiveParams.executionEngine;
        }

        @Override
        protected boolean addDkuUdf() throws Exception {
            return PivotRecipeHiveExecutor.this.hiveParams.addDkuUdf;
        }

        @Override
        protected List<SimpleKeyValue> getExtraConf() throws IOException, DKUSecurityException {
            return new HiveConfHelper().getResolvedConf(PivotRecipeHiveExecutor.this.authCtxService.getAuthCtx(), PivotRecipeHiveExecutor.this.recipe.getModel().projectKey, PivotRecipeHiveExecutor.this.hiveParams);
        }

        @Override
        protected boolean canOverrideDatabase() {
            return false;
        }
    }
}

