/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.pivot.ContainerizedPivotExecutor;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeBuiltinExecutor;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeExecutor;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeHiveExecutor;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeImpalaExecutor;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeSQLExecutor;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeSparkExecutor;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeStatusComputer;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.server.recipes.PivotRecipeService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.JSON;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class PivotRecipeRunner
implements AbortableRecipeRunner,
RecipeRunner,
RecipeRunnerWithPayload,
ContainerizedDSSEngineAble {
    @Autowired
    private PivotRecipeService service;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private VisualSQLRecipesBaseService visualSQLRecipesBaseService;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    private final JobActivity activity;
    private final FlowRecipe recipe;
    private PivotRecipePayloadParams params;
    private PivotRecipeExecutor executor;
    private String payload;
    private boolean isRunningInContainer;
    private static final Logger logger = Logger.getLogger((String)"dku.recipe.pivot");

    public PivotRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        this.activity.initStatus();
    }

    @Override
    public void setPayload(String payload) {
        this.payload = payload;
        this.params = this.service.loadParams(payload, this.recipe.getModel());
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    public void init() throws Exception {
        assert (this.params != null);
        PivotRecipeStatusComputer.PivotRecipeStatus status = new PivotRecipeStatusComputer.PivotRecipeStatus();
        PivotRecipeStatusComputer.checkParamsNoColumns(this.params, status);
        RecipeEnginesPreferenceConfig repc = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.getProjectKey(), this.recipe.getModel().type, this.params.enginesPreferences);
        this.visualSQLRecipesBaseService.initEngines(this.authCtxService.getAuthCtx(), this.activity, status, this.recipe.getProjectKey());
        this.visualSQLRecipesBaseService.selectEngine(this.authCtxService.getAuthCtx(), this.activity, this.params.engineType, status, this.recipe.getModel().type, repc);
        SQLDialect dialect = this.visualSQLRecipesBaseService.getDialect(this.authCtxService.getAuthCtx(), this.activity, status.getSelectedSQLBasedEngine());
        PivotRecipeStatusComputer.checkParamsColumns(this.params, status, dialect);
        if (status.isInvalid()) {
            throw new IllegalArgumentException("Invalid params " + status.gatherAllMessages().report());
        }
        this.recipe.validateExactly1Source();
        this.executor = this.getExecutor();
        logger.info((Object)("Using executor: " + this.executor.getClass().getName()));
        this.executor.init();
    }

    private PivotRecipeExecutor getExecutor() throws Exception {
        PivotRecipeStatusComputer dc = new PivotRecipeStatusComputer(this.recipe.getModel(), this.payload);
        PivotRecipeStatusComputer.PivotRecipeStatus recipeStatus = dc.fastStatusIgnorePartitions(this.authCtxService.getAuthCtx());
        VisualSQLRecipesBaseService.SQLBasedEngineStatus engineToUse = (VisualSQLRecipesBaseService.SQLBasedEngineStatus)recipeStatus.selectedEngine;
        logger.info((Object)("Selected engine: " + engineToUse.type));
        JobContext.getCurrentActivitySummary().engineType = engineToUse.type;
        switch (engineToUse.type) {
            case "SQL": {
                return new PivotRecipeSQLExecutor(engineToUse, this.activity, this.params);
            }
            case "SPARK": {
                return new PivotRecipeSparkExecutor(engineToUse, this.activity, this.params, this.params.engineParams.sparkSQL);
            }
            case "IMPALA": {
                return new PivotRecipeImpalaExecutor(engineToUse, this.activity, this.params, this.params.engineParams.impala);
            }
            case "HIVE": {
                return new PivotRecipeHiveExecutor(engineToUse, this.activity, this.params, this.params.engineParams.hive);
            }
            case "DSS": {
                ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, this.params.engineParams.containerSelection, this.recipe.getModel(), this.payload);
                if (containerConfig != null) {
                    logger.info((Object)"Run in container");
                    return new ContainerizedPivotExecutor(this.recipe, this.activity, containerConfig);
                }
                return new PivotRecipeBuiltinExecutor(engineToUse, this.activity, this.params);
            }
        }
        throw new IllegalArgumentException("No engine selected");
    }

    @Override
    public void run() throws Exception {
        logger.info((Object)"Run pivot recipe");
        try {
            logger.info((Object)("Params: " + JSON.pretty((Object)this.params)));
        }
        catch (Exception e) {
            logger.error((Object)"Params could not be printed.", (Throwable)e);
        }
        assert (this.executor != null);
        this.executor.run();
    }

    @Override
    public void notifyBeforeAborting() {
        if (this.executor != null) {
            this.executor.notifyBeforeAborting();
        }
    }
}

