/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph.utils;

import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowLabelingTask;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowRetrievableKnowledge;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.dataflow.graph.utils.GraphSerializerCommon;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.AnyLoc;
import org.apache.commons.lang.NotImplementedException;

public class GraphIds {
    public static String forDataset(String fullName) {
        return GraphSerializerCommon.graphVizEscape("dataset_" + fullName);
    }

    public static String forDataset(FlowDataset fds) {
        return GraphIds.forDataset(fds.getFullName());
    }

    public static String forDataset(String projectKey, String name) {
        return GraphIds.forDataset(projectKey + "." + name);
    }

    public static String forDatasetSM(String projectKey, String name) {
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, name);
        return GraphIds.forDataset(loc.getProjectKey(), loc.getId());
    }

    public static String forSavedModel(FlowSavedModel fds) {
        return GraphSerializerCommon.graphVizEscape("savedmodel_" + fds.getFullId());
    }

    public static String forSavedModel(String projectKey, String id) {
        return GraphSerializerCommon.graphVizEscape("savedmodel_" + projectKey + "." + id);
    }

    public static String forModelEvaluationStore(FlowModelEvaluationStore fds) {
        return GraphSerializerCommon.graphVizEscape("modelevaluationstore_" + fds.getFullId());
    }

    public static String forModelEvaluationStore(String projectKey, String id) {
        return GraphSerializerCommon.graphVizEscape("modelevaluationstore_" + projectKey + "." + id);
    }

    public static String forStreamingEndpoint(FlowStreamingEndpoint fds) {
        return GraphSerializerCommon.graphVizEscape("streamingendpoint_" + fds.getFullId());
    }

    public static String forStreamingEndpoint(String projectKey, String id) {
        return GraphSerializerCommon.graphVizEscape("streamingendpoint_" + projectKey + "." + id);
    }

    public static String forRetrievableKnowledge(FlowRetrievableKnowledge fds) {
        return GraphSerializerCommon.graphVizEscape("retrievableknowledge_" + fds.getFullId());
    }

    public static String forRetrievableKnowledge(String projectKey, String id) {
        return GraphSerializerCommon.graphVizEscape("retrievableknowledge_" + projectKey + "." + id);
    }

    public static String forLabelingTask(FlowLabelingTask flt) {
        return GraphSerializerCommon.graphVizEscape("labelingtask_" + flt.getFullId());
    }

    public static String forLabelingTask(String projectKey, String id) {
        return GraphSerializerCommon.graphVizEscape("labelingtask_" + projectKey + "." + id);
    }

    public static String forManagedFolder(FlowManagedFolder fds) {
        return GraphSerializerCommon.graphVizEscape("managedfolder_" + fds.getFullId());
    }

    public static String forManagedFolder(String projectKey, String id) {
        return GraphSerializerCommon.graphVizEscape("managedfolder_" + projectKey + "." + id);
    }

    public static String forRecipe(FlowRecipe fr) {
        return GraphSerializerCommon.graphVizEscape("recipe_" + fr.getName());
    }

    public static String forRunnable(FlowRunnable fr) {
        if (fr instanceof FlowRecipe) {
            return GraphIds.forRecipe((FlowRecipe)fr);
        }
        if (fr instanceof FlowLabelingTask) {
            return GraphIds.forLabelingTask((FlowLabelingTask)fr);
        }
        throw new NotImplementedException("flow runnable type not supported");
    }

    public static String forZone(Zone zone, String id) {
        return zone != null ? GraphIds.forZone(zone.getId(), id) : null;
    }

    public static String forZone(String zoneId, String id) {
        if (zoneId != null) {
            return GraphSerializerCommon.graphVizEscape(String.format("zone_%s_", zoneId)) + id;
        }
        return id;
    }

    public static String forRecipe(String recipeName) {
        return GraphSerializerCommon.graphVizEscape("recipe_" + recipeName);
    }

    public static String forProject(String projectKey) {
        return GraphSerializerCommon.graphVizEscape("project_" + projectKey);
    }

    public static String forProjectFolder(String projectFolderId) {
        return GraphSerializerCommon.graphVizEscape("projectfolder_" + projectFolderId);
    }

    public static String forExposedObjects(String fromProjectKey, String toProjectKey) {
        return GraphSerializerCommon.graphVizEscape("exposed_from_" + fromProjectKey + "_to_" + toProjectKey);
    }

    public static String forComputable(FlowComputable fds) {
        switch (fds.getType()) {
            case DATASET: {
                return GraphIds.forDataset((FlowDataset)fds);
            }
            case SAVED_MODEL: {
                return GraphIds.forSavedModel((FlowSavedModel)fds);
            }
            case MODEL_EVALUATION_STORE: {
                return GraphIds.forModelEvaluationStore((FlowModelEvaluationStore)fds);
            }
            case MANAGED_FOLDER: {
                return GraphIds.forManagedFolder((FlowManagedFolder)fds);
            }
            case STREAMING_ENDPOINT: {
                return GraphIds.forStreamingEndpoint((FlowStreamingEndpoint)fds);
            }
            case RETRIEVABLE_KNOWLEDGE: {
                return GraphIds.forRetrievableKnowledge((FlowRetrievableKnowledge)fds);
            }
        }
        throw new Error("Unreachable");
    }

    public static String forRef(TaggableObjectsService.TaggableObjectRef ref) {
        switch (ref.type) {
            case DATASET: {
                return GraphIds.forDataset(ref.projectKey, ref.id);
            }
            case MANAGED_FOLDER: {
                return GraphIds.forManagedFolder(ref.projectKey, ref.id);
            }
            case STREAMING_ENDPOINT: {
                return GraphIds.forStreamingEndpoint(ref.projectKey, ref.id);
            }
            case SAVED_MODEL: {
                return GraphIds.forSavedModel(ref.projectKey, ref.id);
            }
            case MODEL_EVALUATION_STORE: {
                return GraphIds.forModelEvaluationStore(ref.projectKey, ref.id);
            }
            case RETRIEVABLE_KNOWLEDGE: {
                return GraphIds.forRetrievableKnowledge(ref.projectKey, ref.id);
            }
            case RECIPE: {
                return GraphIds.forRecipe(ref.id);
            }
            case LABELING_TASK: {
                return GraphIds.forLabelingTask(ref.projectKey, ref.id);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)ref.type) + " is not a flow type");
    }
}

