/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.jobrunner;

import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.jobrunner.ActivityRunner;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionScope;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class FlowRunnableUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow.activity.runner");

    public static void abort(List<ActivityRunner.FlowRunnableThread> runnables, List<FlowRunnable> additionalRunnables, int poolSize) {
        ExecutorService es = Executors.newFixedThreadPool(poolSize);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        ArrayList futures = new ArrayList();
        if (runnables != null) {
            for (ActivityRunner.FlowRunnableThread flowRunnableThread : runnables) {
                futures.add(es.submit(() -> {
                    try (TransactionScope scope = TransactionContext.with((TransactionRef)t);){
                        if (frt.isAlive() && frt.getStoredException() == null) {
                            frt.setStoredException(new ActivityAbortedException());
                            FlowRunnable runnable = frt.getFlowRunnable();
                            if (runnable instanceof AbortableRecipeRunner) {
                                ((AbortableRecipeRunner)runnable).notifyBeforeAborting();
                            }
                        }
                    }
                }));
            }
        }
        if (additionalRunnables != null) {
            for (FlowRunnable flowRunnable : additionalRunnables) {
                if (!(flowRunnable instanceof AbortableRecipeRunner)) continue;
                futures.add(es.submit(() -> {
                    try (TransactionScope scope = TransactionContext.with((TransactionRef)t);){
                        ((AbortableRecipeRunner)additional).notifyBeforeAborting();
                    }
                }));
            }
        }
        es.shutdown();
        try {
            if (!es.awaitTermination(1L, TimeUnit.HOURS)) {
                logger.warn((Object)"Abort Executor has terminated in a timeout!!");
            }
            for (Future future : futures) {
                if (future == null || !future.isDone()) continue;
                try {
                    future.get();
                }
                catch (Exception e) {
                    logger.error((Object)"Error when running abort notification future", (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn((Object)"Interrupted while waiting on abort runnables", (Throwable)e);
        }
    }
}

