/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master.locking;

import com.dataiku.dip.dataflow.kernel.master.locking.AcquirabilityTestResult;
import com.dataiku.dip.dataflow.kernel.master.locking.SchedulingConstraintPolicy;
import java.util.List;

public class SemaphoreSchedulingConstraintPolicy<PermitRequest>
implements SchedulingConstraintPolicy<PermitRequest> {
    private final int totalPermits;

    public SemaphoreSchedulingConstraintPolicy(int totalPermits) {
        this.totalPermits = totalPermits;
    }

    @Override
    public SchedulingConstraintPolicy.ConstraintChecker<PermitRequest> newConstraintChecker(final List<PermitRequest> acquiredPermits) {
        return new SchedulingConstraintPolicy.ConstraintChecker<PermitRequest>(){

            @Override
            public AcquirabilityTestResult canBeAcquired(PermitRequest candidatePermit) {
                if (acquiredPermits.size() < SemaphoreSchedulingConstraintPolicy.this.totalPermits) {
                    return AcquirabilityTestResult.yes();
                }
                return AcquirabilityTestResult.no("Limit of " + SemaphoreSchedulingConstraintPolicy.this.totalPermits + " reached");
            }
        };
    }
}

