/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.memimpl;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SinkProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class MemTableAppendingOutput
extends SinkProcessorOutput {
    private MemTable table;
    private long maxMemoryUsed = -1L;
    private long memoryUsed = 0L;

    public MemTableAppendingOutput(MemTable table) {
        this.table = table;
    }

    public void emitRow(Row row) throws Exception {
        this.table.rows.add((MemRow)row);
        this.memoryUsed += ((MemRow)row).getMemoryUsed();
        if (this.maxMemoryUsed > 0L && this.memoryUsed >= this.maxMemoryUsed) {
            throw new MemTableSizeLimitReachedException(this.table.rows.size(), this.memoryUsed);
        }
    }

    public void setMaxMemoryUsed(long size) {
        this.maxMemoryUsed = size;
    }

    public static class MemTableSizeLimitReachedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public MemTableSizeLimitReachedException(int nbRows, long memoryUsed) {
            this(nbRows, memoryUsed, null);
        }

        public MemTableSizeLimitReachedException(int nbRows, long memoryUsed, String processorName) {
            super(MemTableSizeLimitReachedException.buildMessage(nbRows, memoryUsed, processorName));
        }

        private static String buildMessage(int nbRows, long memoryUsed, String processorName) {
            if (StringUtils.isNotBlank((String)processorName)) {
                return "When processing '" + processorName + "', the first " + nbRows + " rows already used " + memoryUsed / 0x100000L + " MB";
            }
            return "The first " + nbRows + " rows already used " + memoryUsed / 0x100000L + " MB";
        }
    }
}

