/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.window;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.sort.RowAndSortMark;
import com.dataiku.dip.datalayer.window.WindowAggregation;
import com.dataiku.dip.datalayer.window.WindowSlider;

public class FirstOrLastAggregation
extends WindowAggregation {
    private final WindowSlider slider;
    private long count = 0L;

    public static SchemaColumn buildOutputSchemaColumn(String name, SchemaColumn schemaColumn) {
        return new SchemaColumn(name, schemaColumn.getType());
    }

    public FirstOrLastAggregation(Column column, Column result, SchemaColumn schemaColumn, WindowSlider slider) {
        super(column, result, schemaColumn, FirstOrLastAggregation.buildOutputSchemaColumn(result.getName(), schemaColumn));
        this.slider = slider;
    }

    @Override
    public boolean needsReset() {
        return false;
    }

    @Override
    public void reset() {
        this.count = 0L;
    }

    @Override
    public void expandInternal(Object value) {
        ++this.count;
    }

    @Override
    public void shrinkInternal(Object value) {
        --this.count;
    }

    @Override
    public Object produceValueInternal() {
        throw new RuntimeException("unreachable");
    }

    @Override
    public void produceValue(Row row) {
        RowAndSortMark current = this.slider.current();
        if (this.count > 0L && current != null && current.row != null && current.row.row != null) {
            row.put(this.result, current.row.row.get(this.column));
        }
    }
}

