/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.window;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.sort.RowValueAccessorFactory;
import com.dataiku.dip.datalayer.sort.RowsComparator;
import com.dataiku.dip.datalayer.window.WindowAggregation;
import com.dataiku.dip.expressions.Expression;
import java.util.Comparator;
import javax.annotation.Nonnull;

public class FirstOrLastOrderedByColumnAggregation
extends WindowAggregation {
    private final Comparator<Object> orderColumnComparator;
    private final RowValueAccessorFactory.ValueReader orderColumnReader;
    private final Expression condition;
    private final boolean notNull;
    private Object currentOrderValue;
    private Object current;
    private boolean empty;

    public static SchemaColumn buildOutputSchemaColumn(String name, SchemaColumn schemaColumn) {
        return new SchemaColumn(name, schemaColumn.getType());
    }

    public FirstOrLastOrderedByColumnAggregation(Column column, Column result, SchemaColumn schemaColumn, Column orderColumn, boolean isFirst, @Nonnull SchemaColumn orderSchemaColumn, Expression condition, boolean notNull) {
        super(column, result, schemaColumn, FirstOrLastOrderedByColumnAggregation.buildOutputSchemaColumn(result.getName(), schemaColumn));
        this.condition = condition;
        this.notNull = notNull;
        this.orderColumnReader = RowValueAccessorFactory.getReader(orderSchemaColumn, orderColumn);
        this.orderColumnComparator = RowValueAccessorFactory.getComparator(orderSchemaColumn, orderColumn, isFirst, RowsComparator.NullsOrdering.AUTO);
    }

    @Override
    public boolean needsReset() {
        return false;
    }

    @Override
    public void reset() {
        this.currentOrderValue = null;
        this.current = null;
        this.empty = true;
    }

    @Override
    public void expand(Row row) {
        if (this.condition != null && !this.condition.isTrueish(row)) {
            return;
        }
        Object value = this.valueReader.read(row);
        if (this.notNull && value == null) {
            return;
        }
        Object orderValue = this.orderColumnReader.read(row);
        if (this.empty || this.orderColumnComparator.compare(orderValue, this.currentOrderValue) < 0) {
            this.currentOrderValue = orderValue;
            this.current = value;
            this.empty = false;
        }
    }

    @Override
    public void shrinkInternal(Object value) {
        throw new Error("only for grouping");
    }

    @Override
    public Object produceValueInternal() {
        return this.current;
    }

    @Override
    public void expandInternal(Object value) {
        throw new Error("unreachable");
    }
}

