/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalineage;

import com.dataiku.dip.datalineage.ColumnRelationDiff;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@UIModel
public class ManualDataLineage {
    public List<ColumnRelationDiff> columnRelationsPatch = new ArrayList<ColumnRelationDiff>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.dataLineage.manual");

    public ManualDataLineage() {
    }

    public ManualDataLineage(ManualDataLineage other) {
        for (ColumnRelationDiff relationsPatch : other.columnRelationsPatch) {
            if (relationsPatch.relation == null) continue;
            this.columnRelationsPatch.add(new ColumnRelationDiff(relationsPatch));
        }
    }

    public ManualDataLineage withSmartNames(String projectKey) {
        ManualDataLineage lineage = new ManualDataLineage(this);
        lineage.columnRelationsPatch = lineage.columnRelationsPatch.stream().flatMap(diff -> {
            try {
                diff.relation.inputDataset = AnyLoc.resolveSmart(projectKey, diff.relation.inputDataset).getSmartName(projectKey);
                return Stream.of(diff);
            }
            catch (Exception e) {
                logger.info((Object)("Could not set dataset name in manual column relation: " + String.valueOf(diff) + ". " + e.getMessage()));
                return Stream.empty();
            }
        }).collect(Collectors.toList());
        return lineage;
    }

    public boolean renameInputDataset(String contextProjectKey, String oldFullName, String newFullName) {
        boolean renamed = false;
        AnyLoc oldLoc = AnyLoc.resolveFull(oldFullName);
        String projectKey = oldLoc.getProjectKey();
        AnyLoc newLoc = AnyLoc.resolveFull(newFullName);
        String newSmartName = newLoc.getSmartName(contextProjectKey);
        for (ColumnRelationDiff diff : this.columnRelationsPatch) {
            try {
                if (!AnyLoc.resolveSmart(projectKey, diff.relation.inputDataset).equals(oldLoc)) continue;
                diff.relation.inputDataset = newSmartName;
                renamed = true;
            }
            catch (Exception e) {
                logger.info((Object)("Could not rename dataset in manual column relation: " + String.valueOf(diff) + ". " + e.getMessage()));
            }
        }
        return renamed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManualDataLineage that = (ManualDataLineage)o;
        return Objects.equals(this.columnRelationsPatch, that.columnRelationsPatch);
    }

    public int hashCode() {
        return Objects.hashCode(this.columnRelationsPatch);
    }
}

