/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamDatasetUtils;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HDFSDatasetTestHandler
extends FSLikeDatasetTestHandler {
    private static Logger logger = Logger.getLogger((String)"dku.input.hdfs");

    public HDFSDatasetTestHandler(AuthCtx authCtx, HDFSDatasetHandler handlerForData, DatasetHandler handlerForName, Dataset dataset) {
        super(authCtx, handlerForData, handlerForName, dataset);
    }

    @Override
    public InputSplit testConnection(FSLikeDatasetTestHandler.FSLikeDatasetTestResult ret) throws Exception {
        HDFSDatasetHandler.Config config = this.dataset.getParamsAs(HDFSDatasetHandler.Config.class);
        if (StringUtils.isBlank((String)config.path)) {
            ret.connectionError = new SerializedError((Throwable)new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Missing 'path' parameter"), false);
            return null;
        }
        try {
            InputSplit sampleSplit = this.handlerForData.getSampleSplit();
            if (sampleSplit instanceof StreamsInputSplit) {
                ret.empty = StreamDatasetUtils.isStreamEmpty((StreamsInputSplit)sampleSplit);
            }
            ret.connectionOK = true;
            return sampleSplit;
        }
        catch (Exception e) {
            logger.warn((Object)"HDFS dataset test failed", (Throwable)e);
            ret.connectionError = new SerializedError((Throwable)e, false);
            return null;
        }
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        InfoMessage.InfoMessages ret = FSDatasetUtils.checkDatasetName(newDatasetName);
        if (StringUtils.contains((String)newDatasetName, (char)'-')) {
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_UNSAFE_NAME, "Dataset names containing '-' are not compatible with Hive");
        }
        return ret;
    }
}

