/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.hdfs;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.cluster.ImpalaSettings;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.datasets.fs.hdfs.ACLUtils;
import com.dataiku.dip.datasets.fs.hdfs.HDFSLocatableHandler;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsUtils;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.impersonation.GroupImpersonationTarget;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.utils.PathUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.security.UserGroupInformation;
import org.springframework.beans.factory.annotation.Autowired;

public class HDFSPermissionsHandler {
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private ImpersonationResolverService impersonationService;
    @Autowired
    private AuthCtxCreationService authCtxService;
    @Autowired
    private TransactionService transactionService;
    private final HDFSLocatableHandler handler;
    private final HDFSProvider provider;
    private final Map<String, FileSystem> fsCache = new HashMap<String, FileSystem>();
    private final AnyLoc objectLoc;
    private final String connectionRootWithinURIAuthority;
    private final String configuredRootPathWithinAuthority;
    private final String effectiveRootPathWithinAuthority;
    private final boolean singleFile;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.hdfs.permissions");

    public HDFSPermissionsHandler(HDFSLocatableHandler handler) throws IOException, DKUSecurityException, CodedException, InterruptedException {
        this.handler = handler;
        this.provider = handler.getHDFSProvider();
        this.objectLoc = handler.getLoc();
        this.connectionRootWithinURIAuthority = handler.getConnectionRootWithinURIAuthority();
        this.configuredRootPathWithinAuthority = handler.getConfiguredRootPathWithinAuthority();
        this.effectiveRootPathWithinAuthority = handler.getEffectiveRootWithinAuthority();
        this.singleFile = handler.isSingleFile();
        SpringUtils.getInstance().autowire((Object)this);
    }

    public HDFSPermissionsHandler(HDFSDatasetHandler handler) throws IOException, DKUSecurityException, CodedException, InterruptedException {
        this(new HDFSLocatableHandler(handler));
    }

    public HDFSPermissionsHandler(ManagedFolderHandler handler) throws IOException, DKUSecurityException, CodedException, InterruptedException {
        this(new HDFSLocatableHandler(handler));
    }

    public Path getHDFSPath(String pathInDataset) throws IOException, InterruptedException, DKUSecurityException {
        String fsPath = this.singleFile ? this.effectiveRootPathWithinAuthority : PathUtils.concatLNT((String[])new String[]{this.effectiveRootPathWithinAuthority, pathInDataset});
        logger.info((Object)("make HDFS path for pathInDataset=" + pathInDataset + " out=" + fsPath));
        return new Path(fsPath);
    }

    public void setGatewayACLNoCreate(AuthCtx authCtx) throws IOException, InterruptedException, DKUSecurityException {
        if (!this.impersonationService.isEnabled()) {
            return;
        }
        logger.info((Object)("Setting gateway ACL (no-create): " + this.objectLoc.getFullName()));
        String lockName = "datasets.hdfs.permissions." + this.objectLoc.getFullName();
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            Path configuredRootPath;
            FileSystem niFS = this.provider.getFSForAclSynchronizationMode();
            if (niFS != null && niFS.isDirectory(configuredRootPath = new Path(this.configuredRootPathWithinAuthority))) {
                this.setGatewayACLOnExistingFolder(authCtx, niFS, configuredRootPath);
            }
        }
    }

    public void setGatewayACLCreate(AuthCtx authCtx) throws IOException, InterruptedException, DKUSecurityException {
        if (!this.impersonationService.isEnabled()) {
            return;
        }
        logger.info((Object)("Setting gateway ACL (create): " + this.objectLoc.getFullName()));
        String lockName = "datasets.hdfs.permissions." + this.objectLoc.getFullName();
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            FileSystem niFS = this.provider.getFSForAclSynchronizationMode();
            if (niFS != null) {
                Path configuredRootPath = new Path(this.configuredRootPathWithinAuthority);
                if (!niFS.isDirectory(configuredRootPath)) {
                    logger.info((Object)("Set gateway ACL: mkdir " + String.valueOf(configuredRootPath)));
                    if (!niFS.mkdirs(configuredRootPath)) {
                        throw new IOException("Failed to mkdir " + String.valueOf(configuredRootPath));
                    }
                }
                this.setGatewayACLOnExistingFolder(authCtx, niFS, configuredRootPath);
            }
        }
    }

    private void setGatewayACLOnExistingFolder(AuthCtx authCtx, FileSystem niFS, Path configuredRootPath) throws IOException, DKUSecurityException, InterruptedException {
        List<AclEntry> gatewayACLs = this.getGatewayACLElements(authCtx);
        ACLUtils.dedupACLs(gatewayACLs);
        logger.info((Object)("Setting Gateway ACLs  on:" + String.valueOf(configuredRootPath) + " -> " + StringUtils.join(gatewayACLs, (String)",")));
        niFS.setAcl(configuredRootPath, gatewayACLs);
        if (this.provider.allowsWrite()) {
            for (Path hdfsPath : this.getHDFSPathsBetweenConnectionRootAndDatasetConfiguredRoot()) {
                HDFSPermissionsUtils utils = new HDFSPermissionsUtils();
                List<AclEntry> connectionLevelACLs = utils.getConnectionLevelACL(authCtx, this.objectLoc.getProjectKey());
                logger.info((Object)("Setting connection-level ACLs on:" + String.valueOf(hdfsPath) + " -> " + StringUtils.join(connectionLevelACLs, (String)",")));
                niFS.setAcl(hdfsPath, connectionLevelACLs);
            }
        }
    }

    public List<Path> getHDFSPathsBetweenConnectionRootAndDatasetConfiguredRoot() throws IOException, InterruptedException, DKUSecurityException {
        return HDFSPermissionsHandler.buildHDFSPathsBetweenConnectionRootAndDatasetConfiguredRoot(this.connectionRootWithinURIAuthority, this.configuredRootPathWithinAuthority);
    }

    public static List<Path> buildHDFSPathsBetweenConnectionRootAndDatasetConfiguredRoot(String connectionRootWithinURIAuthority, String configuredRootPathWithinAuthority) throws IOException, InterruptedException, DKUSecurityException {
        ArrayList<Path> ret = new ArrayList<Path>();
        Path p = new Path(connectionRootWithinURIAuthority);
        if (configuredRootPathWithinAuthority.startsWith(connectionRootWithinURIAuthority)) {
            Object[] chunks = StringUtils.splitByWholeSeparator((String)configuredRootPathWithinAuthority.substring(connectionRootWithinURIAuthority.length()), (String)"/");
            logger.info((Object)("connectionRoot=" + connectionRootWithinURIAuthority + " configured=" + configuredRootPathWithinAuthority + " chunks=" + StringUtils.join((Object[])chunks, (String)"--")));
            if (chunks.length > 1) {
                for (String chunk : (String[])Arrays.copyOfRange(chunks, 0, chunks.length - 1)) {
                    logger.info((Object)("Path = " + String.valueOf(p) + " chunk=" + String.valueOf(chunk)));
                    p = new Path(p, chunk);
                    ret.add(p);
                }
            }
        }
        return ret;
    }

    private List<AclEntry> getGatewayACLElements(AuthCtx authCtx) throws IOException, DKUSecurityException {
        String dssUserHadoopName = UserGroupInformation.getLoginUser().getShortUserName();
        Validate.notNull((Object)dssUserHadoopName);
        List<AclEntry> acls = this.getGroupACLEntries();
        acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.USER, dssUserHadoopName, FsAction.ALL));
        ClusterSettings clusterSettings = new ClusterSelector().selectForProject(authCtx, this.objectLoc.getProjectKey());
        HiveSettings hiveSettings = clusterSettings.getHiveSettings();
        ImpalaSettings impalaSettings = clusterSettings.getImpalaSettings();
        if (impalaSettings.enabled && !StringUtils.isBlank((String)impalaSettings.additionalUserToGrantAccessToWhenImpersonating)) {
            acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.USER, impalaSettings.additionalUserToGrantAccessToWhenImpersonating, FsAction.ALL));
        }
        if (!StringUtils.isBlank((String)hiveSettings.additionalUserToGrantAccessToWhenImpersonating)) {
            acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.USER, hiveSettings.additionalUserToGrantAccessToWhenImpersonating, FsAction.ALL));
        }
        acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.USER, null, FsAction.ALL));
        acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.OTHER, null, FsAction.NONE));
        acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.GROUP, null, FsAction.NONE));
        return acls;
    }

    private List<AclEntry> getGroupACLEntries() throws IOException, DKUSecurityException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.getGroupACLEntriesT();
        }
        try (Transaction t = this.transactionService.beginRead();){
            List<AclEntry> list = this.getGroupACLEntriesT();
            return list;
        }
    }

    private List<AclEntry> getGroupACLEntriesT() throws IOException, DKUSecurityException {
        SmartObjectRef sor;
        ArrayList<AclEntry> ret = new ArrayList<AclEntry>();
        SerializedProject sp = this.projectsDAO.getOrNullUnsafe(this.objectLoc.getProjectKey());
        HashSet fullAccessGroups = Sets.newHashSet();
        for (SerializedProject.PermissionItem pi : sp.permissions) {
            if (pi == null || pi.group == null) continue;
            if (PermissionsService.permissionItemIncludes(pi, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                GroupImpersonationTarget groupImpersonationTarget = this.impersonationService.getHadoopGroupOrNull(pi.group);
                if (groupImpersonationTarget == null) {
                    logger.warn((Object)("No group rule matching '" + pi.group + "'. No ACL set for group."));
                    continue;
                }
                fullAccessGroups.add(pi.group);
                ret.add(this.acl(AclEntryScope.ACCESS, AclEntryType.GROUP, groupImpersonationTarget.hadoopGroup, FsAction.ALL));
                continue;
            }
            if (!PermissionsService.permissionItemIncludes(pi, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
            GroupImpersonationTarget groupImpersonationTarget = this.impersonationService.getHadoopGroupOrNull(pi.group);
            if (groupImpersonationTarget == null) {
                logger.warn((Object)("No group rule matching '" + pi.group + "'. No ACL set for group."));
                continue;
            }
            ret.add(this.acl(AclEntryScope.ACCESS, AclEntryType.GROUP, groupImpersonationTarget.hadoopGroup, FsAction.READ_EXECUTE));
        }
        UsersDAO.User owner = this.usersDAO.getOrNullUnsafe(sp.owner);
        if (owner != null) {
            AuthCtx ownerAuthCtx = this.authCtxService.create(owner.login);
            UserImpersonationTarget userImpersonationTarget = this.impersonationService.getTargetUser(sp.projectKey, ownerAuthCtx);
            ret.add(this.acl(AclEntryScope.ACCESS, AclEntryType.USER, userImpersonationTarget.hadoopUser, FsAction.ALL));
        }
        if (sp.dashboardAuthorizations.hasObjectAuthorization(sor = SmartObjectRef.fromResolved(this.handler.getObjectType(), this.objectLoc.getProjectKey(), this.objectLoc.getId(), this.objectLoc.getProjectKey()), SerializedProject.ReaderAuthorization.Mode.READ)) {
            for (SerializedProject.PermissionItem permissionItem : sp.permissions) {
                if (permissionItem == null || permissionItem.group == null || !PermissionsService.permissionItemIncludes(permissionItem, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS)) continue;
                GroupImpersonationTarget itarget2 = this.impersonationService.getHadoopGroupOrNull(permissionItem.group);
                if (itarget2 == null) {
                    logger.warn((Object)("No group rule matching '" + permissionItem.group + "'. No ACL set for group."));
                    continue;
                }
                ret.add(this.acl(AclEntryScope.ACCESS, AclEntryType.GROUP, itarget2.hadoopGroup, FsAction.READ_EXECUTE));
            }
        }
        for (ExposedObject ec : sp.exposedObjects.objects) {
            if (!ec.localName.equals(this.objectLoc.getId())) continue;
            for (ExposedObject.Rule rule : ec.rules) {
                SmartObjectRef sor2;
                SerializedProject targetProject = this.projectsDAO.getOrNullUnsafe(rule.targetProject);
                if (targetProject == null) {
                    logger.warnV("Object %s (%s) is exposed to project %s which does not exist - ignoring ACLs", new Object[]{ec.localName, ec.type, rule.targetProject});
                    continue;
                }
                for (SerializedProject.PermissionItem pi : targetProject.permissions) {
                    if (pi == null || pi.group == null || !PermissionsService.permissionItemIncludes(pi, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
                    GroupImpersonationTarget itarget3 = this.impersonationService.getHadoopGroupOrNull(pi.group);
                    if (itarget3 == null) {
                        logger.warn((Object)("No group rule matching '" + pi.group + "'. No ACL set for group."));
                        continue;
                    }
                    ret.add(this.acl(AclEntryScope.ACCESS, AclEntryType.GROUP, itarget3.hadoopGroup, FsAction.READ_EXECUTE));
                }
                UsersDAO.User owner2 = this.usersDAO.getOrNullUnsafe(targetProject.owner);
                if (owner2 != null) {
                    Sets.SetView userFullAccessGroups = Sets.intersection((Set)fullAccessGroups, (Set)Sets.newHashSet(owner2.groups));
                    if (!userFullAccessGroups.isEmpty()) {
                        logger.info((Object)("Not restricting user '" + owner2.login + "' to only r-x because it has WRITE_CONF via : " + Joiner.on((String)", ").join((Iterable)userFullAccessGroups)));
                    } else {
                        AuthCtx ownerAuthCtx = this.authCtxService.create(owner2.login);
                        UserImpersonationTarget utarget = this.impersonationService.getTargetUser(sp.projectKey, ownerAuthCtx);
                        ret.add(this.acl(AclEntryScope.ACCESS, AclEntryType.USER, utarget.hadoopUser, FsAction.READ_EXECUTE));
                    }
                }
                if (!targetProject.dashboardAuthorizations.hasObjectAuthorization(sor2 = SmartObjectRef.fromResolved(this.handler.getObjectType(), this.objectLoc.getProjectKey(), this.objectLoc.getId(), targetProject.projectKey), SerializedProject.ReaderAuthorization.Mode.READ)) continue;
                for (SerializedProject.PermissionItem pi : targetProject.permissions) {
                    if (pi == null || pi.group == null || !PermissionsService.permissionItemIncludes(pi, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS)) continue;
                    GroupImpersonationTarget itarget4 = this.impersonationService.getHadoopGroupOrNull(pi.group);
                    if (itarget4 == null) {
                        logger.warn((Object)("No group rule matching '" + pi.group + "'. No ACL set for group."));
                        continue;
                    }
                    ret.add(this.acl(AclEntryScope.ACCESS, AclEntryType.GROUP, itarget4.hadoopGroup, FsAction.READ_EXECUTE));
                }
            }
        }
        for (UsersDAO.Group g : this.usersDAO.listGroupsUnsafe()) {
            if (!g.isAdmin()) continue;
            GroupImpersonationTarget groupImpersonationTarget = this.impersonationService.getHadoopGroupOrNull(g.name);
            if (groupImpersonationTarget == null) {
                logger.warn((Object)("No group rule matching '" + g.name + "'. No ACL set for group."));
                continue;
            }
            ret.add(this.acl(AclEntryScope.ACCESS, AclEntryType.GROUP, groupImpersonationTarget.hadoopGroup, FsAction.ALL));
        }
        return ret;
    }

    public void setDataUsabilityAndDeletabilityACL(AuthCtx authCtx) throws IOException, InterruptedException, DKUSecurityException {
        if (!this.impersonationService.isEnabled()) {
            return;
        }
        logger.info((Object)("Setting dataset-wide data-usability ACL: " + this.objectLoc.getFullName()));
        String lockName = "datasets.hdfs.permissions." + this.objectLoc.getFullName();
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            Path configuredRootPath;
            FileSystem niFS = this.provider.getFSForAclSynchronizationMode();
            if (niFS != null && niFS.isDirectory(configuredRootPath = new Path(this.configuredRootPathWithinAuthority))) {
                this.setDataUsabilityAndDeletabilityACLRecursivelyOnChildren(authCtx, niFS, configuredRootPath);
            }
        }
    }

    public void setDataUsabilityAndDeletabilityACL(AuthCtx authCtx, Partition partition) throws IOException, InterruptedException, DKUSecurityException {
        if (!this.impersonationService.isEnabled()) {
            return;
        }
        logger.info((Object)("Setting partition-wide data-usability ACL: " + this.objectLoc.getFullName() + "partition=" + String.valueOf(partition)));
        String lockName = "datasets.hdfs.permissions." + this.objectLoc.getFullName();
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            FileSystem niFS = this.provider.getFSForAclSynchronizationMode();
            if (niFS != null) {
                Path configuredRootPath = new Path(this.configuredRootPathWithinAuthority);
                this.setDataUsabilityAndDeletabilityACLSingleDir(authCtx, niFS, configuredRootPath);
                Path partitionPath = this.getHDFSPath(this.handler.getPartitionRelPath(partition));
                logger.info((Object)("Doing partition-specific set data-usability ACL on " + String.valueOf(partitionPath)));
                this.setDataUsabilityAndDeletabilityACLRecursivelyIncludingItself(authCtx, niFS, partitionPath);
            }
        }
    }

    private void setDataUsabilityAndDeletabilityACLSinglePath(AuthCtx authCtx, FileSystem niFS, FileStatus stat) throws IOException, DKUSecurityException, InterruptedException {
        String dssUserHadoopName = UserGroupInformation.getLoginUser().getShortUserName();
        Validate.notNull((Object)dssUserHadoopName);
        ArrayList<AclEntry> acls = new ArrayList<AclEntry>();
        HiveSettings hiveSettings = new ClusterSelector().selectForProject(authCtx, this.objectLoc.getProjectKey()).getHiveSettings();
        boolean addHiveWriteACL = hiveSettings.addWriteACLOnDataUsabilityACL;
        if (stat.isDirectory()) {
            acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.GROUP, null, FsAction.READ_EXECUTE));
            acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.OTHER, null, FsAction.READ_EXECUTE));
            acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.USER, dssUserHadoopName, FsAction.ALL));
            if (addHiveWriteACL && !StringUtils.isBlank((String)hiveSettings.additionalUserToGrantAccessToWhenImpersonating)) {
                acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.USER, hiveSettings.additionalUserToGrantAccessToWhenImpersonating, FsAction.ALL));
            }
        } else {
            acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.GROUP, null, FsAction.READ));
            acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.OTHER, null, FsAction.READ));
            acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.USER, dssUserHadoopName, FsAction.READ_WRITE));
            if (addHiveWriteACL && !StringUtils.isBlank((String)hiveSettings.additionalUserToGrantAccessToWhenImpersonating)) {
                acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.USER, hiveSettings.additionalUserToGrantAccessToWhenImpersonating, FsAction.ALL));
            }
        }
        ACLUtils.dedupACLs(acls);
        logger.info((Object)("Set data-usability ACL path=" + String.valueOf(stat.getPath()) + " set ACLs: " + StringUtils.join(acls, (String)",")));
        String owner = stat.getOwner();
        FileSystem fs = this.getFSForUser(owner);
        fs.modifyAclEntries(stat.getPath(), acls);
    }

    private void setDataUsabilityAndDeletabilityACLRecursivelyOnChildren(AuthCtx authCtx, FileSystem niFS, Path path) throws IOException, DKUSecurityException, InterruptedException {
        logger.info((Object)("Set data-usability ACL (recursive-on-children) path=" + String.valueOf(path)));
        for (FileStatus stat : niFS.listStatus(path)) {
            this.setDataUsabilityAndDeletabilityACLSinglePath(authCtx, niFS, stat);
            if (!stat.isDirectory()) continue;
            this.setDataUsabilityAndDeletabilityACLRecursivelyOnChildren(authCtx, niFS, stat.getPath());
        }
    }

    private void setDataUsabilityAndDeletabilityACLRecursivelyIncludingItself(AuthCtx authCtx, FileSystem niFS, Path path) throws IOException, DKUSecurityException, InterruptedException {
        logger.info((Object)("Set data-usability ACL (recursive-including) path=" + String.valueOf(path)));
        if (niFS.isDirectory(path)) {
            FileStatus itselfStat = niFS.getFileStatus(path);
            this.setDataUsabilityAndDeletabilityACLSinglePath(authCtx, niFS, itselfStat);
            for (FileStatus stat : niFS.listStatus(path)) {
                this.setDataUsabilityAndDeletabilityACLSinglePath(authCtx, niFS, stat);
                if (!stat.isDirectory()) continue;
                this.setDataUsabilityAndDeletabilityACLRecursivelyOnChildren(authCtx, niFS, stat.getPath());
            }
        }
    }

    private void setDataUsabilityAndDeletabilityACLSingleDir(AuthCtx authCtx, FileSystem niFS, Path path) throws IOException, DKUSecurityException, InterruptedException {
        logger.info((Object)("Set data-usability ACL (single-dir) path=" + String.valueOf(path)));
        for (FileStatus stat : niFS.listStatus(path)) {
            this.setDataUsabilityAndDeletabilityACLSinglePath(authCtx, niFS, stat);
        }
    }

    public void setDataWritabilityACL(AuthCtx authCtx, Partition partition) throws Exception {
        if (!this.impersonationService.isEnabled()) {
            return;
        }
        logger.info((Object)("Setting partition-wide data-writability ACL: " + this.objectLoc.getFullName() + "partition=" + String.valueOf(partition)));
        String lockName = "datasets.hdfs.permissions." + this.objectLoc.getFullName();
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            FileSystem niFS = this.provider.getFSForAclSynchronizationMode();
            if (niFS != null) {
                Path partitionPath;
                Path effectiveRootPath = new Path(this.effectiveRootPathWithinAuthority);
                Path currentPath = partitionPath = this.getHDFSPath(this.handler.getPartitionRelPath(partition));
                while (!currentPath.toString().equals(effectiveRootPath.toString())) {
                    logger.info((Object)("Current path= " + String.valueOf(currentPath) + "  effective=" + String.valueOf(effectiveRootPath)));
                    currentPath = currentPath.getParent();
                    this.setDataWritabilityACLOnFolder(niFS, authCtx, currentPath);
                    if (currentPath.toString().equals(effectiveRootPath.toString())) {
                        logger.info((Object)("Reached and handled configuredRootPath:" + String.valueOf(effectiveRootPath) + ", stopping"));
                        break;
                    }
                    if (currentPath.toString().startsWith(effectiveRootPath.toString())) continue;
                    throw new IOException("Not in dataset anymore ??? currentPath=" + String.valueOf(currentPath) + " effectiveRootPath=" + String.valueOf(effectiveRootPath));
                }
            }
        }
    }

    private void setDataWritabilityACLOnFolder(FileSystem niFS, AuthCtx authCtx, Path path) throws Exception {
        String dssUserHadoopName = UserGroupInformation.getLoginUser().getShortUserName();
        Validate.notNull((Object)dssUserHadoopName);
        logger.info((Object)("Set data-writability ACL folder=" + String.valueOf(path)));
        if (!niFS.isDirectory(path)) {
            logger.info((Object)("Path " + String.valueOf(path) + " is not a directory, bailing out"));
            return;
        }
        FileStatus stat = niFS.getFileStatus(path);
        UserImpersonationTarget utarget = this.impersonationService.getTargetUser(this.objectLoc.getProjectKey(), authCtx);
        ArrayList<AclEntry> acls = new ArrayList<AclEntry>();
        acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.GROUP, null, FsAction.READ_EXECUTE));
        acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.OTHER, null, FsAction.READ_EXECUTE));
        acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.USER, dssUserHadoopName, FsAction.ALL));
        acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.USER, utarget.hadoopUser, FsAction.ALL));
        ClusterSettings clusterSettings = new ClusterSelector().selectForProject(authCtx, this.objectLoc.getProjectKey());
        HiveSettings hiveSettings = clusterSettings.getHiveSettings();
        ImpalaSettings impalaSettings = clusterSettings.getImpalaSettings();
        if (impalaSettings.enabled && !StringUtils.isBlank((String)impalaSettings.additionalUserToGrantAccessToWhenImpersonating)) {
            acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.USER, impalaSettings.additionalUserToGrantAccessToWhenImpersonating, FsAction.ALL));
        }
        if (!StringUtils.isBlank((String)hiveSettings.additionalUserToGrantAccessToWhenImpersonating)) {
            acls.add(this.acl(AclEntryScope.ACCESS, AclEntryType.USER, hiveSettings.additionalUserToGrantAccessToWhenImpersonating, FsAction.ALL));
        }
        ACLUtils.dedupACLs(acls);
        logger.info((Object)(" --> modify ACL: " + StringUtils.join(acls, (String)",")));
        String owner = stat.getOwner();
        FileSystem fs = this.getFSForUser(owner);
        fs.modifyAclEntries(stat.getPath(), acls);
    }

    private AclEntry acl(AclEntryScope scope, AclEntryType type, String name, FsAction perm) {
        return ACLUtils.acl(scope, type, name, perm);
    }

    private FileSystem getFSForUser(String user) throws IOException, InterruptedException {
        FileSystem fs = this.fsCache.get(user);
        if (fs == null) {
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
            fs = HadoopLoader.getFSForUGI(this.handler.getRootPathUri(), this.handler.getFSExtraConf(), ugi);
            this.fsCache.put(user, fs);
        }
        return fs;
    }
}

