/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql.treasuredata;

import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.GenericSQLDatasetMeta;
import com.dataiku.dip.datasets.sql.PartitionedSQLQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.PartitionedSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.UnpartitionedSQLQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.UnpartitionedSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.treasuredata.TreasureDataDatasetConfig;
import com.dataiku.dip.datasets.sql.treasuredata.TreasureDataSQLTableOutput;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;

public class TreasureDataSQLDatasetMeta
extends GenericSQLDatasetMeta {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql.treasuredata");

    @Override
    public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
        return TreasureDataDatasetConfig.class;
    }

    @Override
    public String getType() {
        return "TreasureData";
    }

    @Override
    public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = (AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParams();
        String mode = config.mode == null ? "table" : config.mode;
        boolean partitioned = dataset.getPartitioningSchema() != null && dataset.getPartitioningSchema().isPartitioned();
        switch (mode) {
            case "table": {
                if (partitioned) {
                    return new TreasureDataPartitionedSQLTableDatasetHandler(authCtx, dataset, this);
                }
                return new TreasureDataUnpartitionedSQLTableDatasetHandler(authCtx, dataset, this);
            }
            case "query": {
                if (partitioned) {
                    return new PartitionedSQLQueryDatasetHandler(authCtx, dataset, this);
                }
                return new UnpartitionedSQLQueryDatasetHandler(authCtx, dataset, this);
            }
        }
        throw ErrorContext.iaef((String)"Invalid SQL dataset mode : '%s' expected 'query' or 'table'", (Object)mode, (Object[])new Object[0]);
    }

    private static class TreasureDataPartitionedSQLTableDatasetHandler
    extends PartitionedSQLTableDatasetHandler {
        public TreasureDataPartitionedSQLTableDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
            super(authCtx, dataset, meta);
        }

        @Override
        public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
            ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedAbstractConfig.connection);
            assert (targetSplit == 0);
            logger.info((Object)"Using SQL output based on the TreasureData Bulk Import API");
            return new TreasureDataSQLTableOutput(this, targetPartition, warningsContext);
        }
    }

    private static class TreasureDataUnpartitionedSQLTableDatasetHandler
    extends UnpartitionedSQLTableDatasetHandler {
        public TreasureDataUnpartitionedSQLTableDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
            super(authCtx, dataset, meta);
        }

        @Override
        public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
            ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedAbstractConfig.connection);
            assert (targetSplit == 0);
            logger.info((Object)"Using SQL output based on the TreasureData Bulk Import API");
            return new TreasureDataSQLTableOutput(this, targetPartition, warningsContext);
        }
    }
}

