/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.distinct.DistinctRecipeMeta;
import com.dataiku.dip.dataflow.exec.distinct.DistinctRecipePayloadParams;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.utils.JSON;
import java.util.stream.Collectors;

public class DistinctRecipePlaceholders {
    private DistinctRecipePlaceholders() {
    }

    public static void assertIsDistinctRecipe(SerializedRecipe sr) throws BadTemplatePlaceholderException {
        if (!DistinctRecipeMeta.META.getType().equals(sr.type)) {
            throw new BadTemplatePlaceholderException("This placeholder is only available for a Distinct recipe. " + sr.name + " has type " + sr.type + ".");
        }
    }

    public static DistinctRecipePayloadParams getPayload(FlowDocumentContext context, SerializedRecipe sr) throws PlaceholderExpectedException {
        DistinctRecipePlaceholders.assertIsDistinctRecipe(sr);
        return (DistinctRecipePayloadParams)JSON.parse((String)context.getCachedPayload(sr), DistinctRecipePayloadParams.class);
    }

    public static class DistinctKeys
    implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
        @Override
        public Class<SerializedRecipe> getInputType() {
            return SerializedRecipe.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            DistinctRecipePayloadParams params = DistinctRecipePlaceholders.getPayload(context, recipe);
            if (params.selectAllColumns) {
                return new PlaceholderOutput.Text("All columns from the input dataset");
            }
            return new PlaceholderOutput.Text(params.keys.stream().map(gk -> gk.column).collect(Collectors.joining(", ")));
        }
    }
}

