/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.univariate.LeveneTestNSamp;
import com.dataiku.dip.eda.compute.stats.LeveneCenter;
import com.dataiku.dip.eda.worksheets.cards.common.Abstract2SampTestCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractNSampTestCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.RecipeCompatibleCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import java.util.List;
import javax.annotation.Nullable;

public class LeveneTest2SampCard
extends Abstract2SampTestCard
implements RecipeCompatibleCard {
    public static final String TYPE = "levene_test_2samp";
    public LeveneCenter center;
    @Nullable
    public Double proportionToTrim;

    public LeveneTest2SampCard(Variable xColumn, Variable yColumn, String[] value1, String[] value2, LeveneCenter center, @Nullable Double proportionToTrim) {
        this.xColumn = xColumn;
        this.yColumn = yColumn;
        this.value1 = value1;
        this.value2 = value2;
        this.center = center;
        this.proportionToTrim = proportionToTrim;
    }

    private LeveneTest2SampCard() {
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new Abstract2SampTestCard.AbstractCompiled2SampTestCard(){

            @Override
            protected Computation getTestComputation() {
                return new LeveneTestNSamp(LeveneTest2SampCard.this.xColumn.name, this.getGrouping(), LeveneTest2SampCard.this.center, LeveneTest2SampCard.this.proportionToTrim);
            }

            @Override
            protected Abstract2SampTestCard.Abstract2SampTestCardResult buildTestCardResult(ComputationResult result, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups) {
                LeveneTestNSamp.LeveneTestNSampResult levene = result.as(LeveneTestNSamp.LeveneTestNSampResult.class);
                return new LeveneTest2SampCardResult(result.collectWarnings(), groups, allGroups, levene.statistic, levene.pvalue, levene.centers);
            }
        };
    }

    public static class LeveneTest2SampCardResult
    extends Abstract2SampTestCard.Abstract2SampTestCardResult {
        public double statistic;
        public double pvalue;
        public double[] centers;

        public LeveneTest2SampCardResult(List<String> warnings, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups, double statistic, double pvalue, double[] centers) {
            this.warnings = warnings;
            this.groups = groups;
            this.allGroups = allGroups;
            this.statistic = statistic;
            this.pvalue = pvalue;
            this.centers = centers;
        }

        private LeveneTest2SampCardResult() {
        }
    }
}

