/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.univariate_header;

import com.dataiku.dip.eda.worksheets.cards.CDFPlotCard;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.UnivariateCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractHeaderCard;
import com.dataiku.dip.eda.worksheets.cards.common.ColumnCard;
import com.dataiku.dip.eda.worksheets.cards.common.RecipeCompatibleCard;
import com.dataiku.dip.eda.worksheets.cards.common.fixers.ColumnCardFixer;
import com.dataiku.dip.eda.worksheets.cards.common.fixers.Fixer;
import com.dataiku.dip.eda.worksheets.cards.common.fixers.HeaderCardFixer;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.CategoricalHistogramCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.NumericalHistogramCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.QuantilesTableCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.UnivariateFrequencyTableCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.UnivariateSummaryStatsCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.utils.JSON;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;

public class UnivariateHeaderCard
extends AbstractHeaderCard
implements RecipeCompatibleCard {
    public static final String TYPE = "univariate_header";
    public boolean showHistogram;
    public boolean showQuantile;
    public boolean showFrequencyTable;
    public boolean showSummary;
    public boolean showBoxPlot;
    public boolean showCumulativeDistributionFunction;

    @VisibleForTesting
    public UnivariateHeaderCard() {
    }

    @Override
    protected UnivariateHeaderCardResult buildContainerResult(List<CardResult> columnCardResults) {
        return new UnivariateHeaderCardResult(columnCardResults);
    }

    private Fixer getColumnFixer(Variable column) {
        ColumnCardFixer columnCardFixer = new ColumnCardFixer(new ColumnCard(column));
        if (column.isContinuous()) {
            if (this.showHistogram || this.showBoxPlot) {
                columnCardFixer.addStat(new NumericalHistogramCard(), new SetColumnFixer(column).then(new Fixer(){

                    @Override
                    public Card fix(Card card) {
                        return ((NumericalHistogramCard)card).withShowBoxPlot(UnivariateHeaderCard.this.showBoxPlot).withShowHistogram(UnivariateHeaderCard.this.showHistogram);
                    }
                }));
            }
            if (this.showCumulativeDistributionFunction) {
                columnCardFixer.addStat(new CDFPlotCard(), new SetColumnFixer(column));
            }
        } else if (this.showHistogram) {
            columnCardFixer.addStat(new CategoricalHistogramCard(), new SetColumnFixer(column));
        }
        if (this.showSummary) {
            columnCardFixer.addStat(new UnivariateSummaryStatsCard(), new SetColumnFixer(column));
        }
        if (column.isContinuous()) {
            if (this.showQuantile) {
                columnCardFixer.addStat(new QuantilesTableCard(), new SetColumnFixer(column));
            }
        } else if (this.showFrequencyTable) {
            columnCardFixer.addStat(new UnivariateFrequencyTableCard(), new SetColumnFixer(column));
        }
        return columnCardFixer;
    }

    @Override
    public Fixer getFixer() {
        HeaderCardFixer fixer = new HeaderCardFixer();
        for (Variable column : this.xColumns) {
            fixer.addColumn(column, this.getColumnFixer(column));
        }
        return fixer;
    }

    public static class UnivariateHeaderCardResult
    extends AbstractHeaderCard.AbstractHeaderCardResult {
        public UnivariateHeaderCardResult(List<CardResult> results) {
            this.results = results;
        }

        private UnivariateHeaderCardResult() {
        }
    }

    static class SetColumnFixer
    extends Fixer {
        private final Variable column;

        public SetColumnFixer(Variable column) {
            this.column = column;
        }

        @Override
        public UnivariateCard fix(Card card) {
            if (card instanceof UnivariateCard) {
                UnivariateCard univariateCard = (UnivariateCard)card;
                if (Objects.equals((Object)univariateCard.column, (Object)this.column)) {
                    return univariateCard;
                }
                UnivariateCard copy = (UnivariateCard)((Object)JSON.deepCopy((Object)((Object)univariateCard)));
                copy.column = this.column;
                return copy;
            }
            throw new IllegalArgumentException("Unexpected input card: " + String.valueOf((Object)card));
        }
    }
}

