/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.worksheets.cards.univariate_header.UnivariateHeaderCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class UnivariateAnalysisSuggester
implements Suggester {
    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        if (sniffedVariables.isEmpty()) {
            return Collections.emptyList();
        }
        List variables = sniffedVariables.stream().map(Suggester::toVariable).collect(Collectors.toList());
        boolean showCumulativeDistributionFunction = variables.stream().allMatch(Variable::isContinuous);
        UnivariateHeaderCard card = new UnivariateHeaderCard();
        card.xColumns = variables;
        card.showHistogram = true;
        card.showBoxPlot = true;
        card.showQuantile = true;
        card.showSummary = true;
        card.showFrequencyTable = true;
        card.showCumulativeDistributionFunction = showCumulativeDistributionFunction;
        SuggestCards.SuggestedCard suggestion = new SuggestCards.SuggestedCard("Univariate analysis", card);
        return Collections.singletonList(suggestion);
    }
}

