/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.input;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.futures.FuturePayload;

public class BindableExportInput
implements ExportInput {
    private ExportInput exportable;
    private volatile long msBindTimeout;
    private ExportInput.InputDescription description;

    public BindableExportInput(String name, long msBindTimeout) {
        this.msBindTimeout = msBindTimeout;
        this.description = new ExportInput.InputDescription();
        this.description.description = "";
        this.description.projectKey = "";
        this.description.name = name;
        this.description.status = "Waiting for data";
    }

    public synchronized void bind(ExportInput exportable) {
        if (this.exportable != null) {
            throw new RuntimeException("Export is already bound");
        }
        this.exportable = exportable;
    }

    private void waitUntilBound() throws InterruptedException {
        long start;
        long current = start = System.currentTimeMillis();
        while (current - start < this.msBindTimeout + 1000L) {
            if (this.exportable != null) {
                return;
            }
            Thread.sleep(500L);
            current = System.currentTimeMillis();
        }
        if (this.exportable == null) {
            throw new RuntimeException("No data has been received (timeout expired)");
        }
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, StreamableDatasetSelection selection, ColumnFactory cf) throws Exception {
        this.waitUntilBound();
        this.exportable.initialize(job, selection, cf);
    }

    @Override
    public Schema getSchema() throws Exception {
        return this.exportable.getSchema();
    }

    @Override
    public ExportInput.InputDescription describe() {
        if (this.exportable != null) {
            return this.exportable.describe();
        }
        return this.description;
    }

    @Override
    public long getInputSize() {
        return this.exportable.getInputSize();
    }

    @Override
    public void close() {
        if (this.exportable != null) {
            this.exportable.close();
        }
    }

    @Override
    public void stream(ProcessorOutput output) throws Exception {
        this.exportable.stream(output);
    }

    @Override
    public FuturePayload.FuturePayloadTarget getSource() {
        return new FuturePayload.FuturePayloadTarget("Delayed data", "DATA");
    }
}

