/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.input;

import com.dataiku.dip.ProcessorWithResolvedParams;
import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.ProcessorWithSubProcess;
import com.dataiku.dip.SingleCopyAdditionalInputsLoader;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.ProcessorWithFactories;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SRPAdapter;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalayer.SingleOutputRowProcessor;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.ExportUtils;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.export.input.RemotableExportInput;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.input.TableColoring;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.AdditionalInputsHelper;
import com.dataiku.dip.shaker.TableToSchema;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.server.StreamedAdditionalInputAccessor;
import com.dataiku.dip.shaker.streamimpl.StreamPipelineFactory;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Iterables;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ExportShaker
extends RemotableExportInput {
    @Autowired
    private transient DataService dataService;
    @Autowired
    private transient TransactionService transactionService;
    @Autowired
    private transient VariablesService variablesService;
    @Autowired
    private transient DatasetsDAO datasetsDAO;
    private transient ColumnFactory cf;
    private ExportInput.InputDescription description;
    private SerializedShakerScript script;
    private Dataset inputDataset;
    private Schema schema;
    public DSSAuthCtx user;
    private StreamableDatasetSelection selection;

    public ExportShaker() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public ExportShaker(Dataset inputDataset, SerializedShakerScript ss, String name, AuthCtx user) {
        SpringUtils.getInstance().autowire((Object)this);
        this.script = ss;
        this.inputDataset = inputDataset;
        this.user = (DSSAuthCtx)user;
        this.description = new ExportInput.InputDescription();
        this.description.name = inputDataset.getName();
        this.description.projectKey = inputDataset.getProjectKey();
        this.description.description = "Apply shaker script \"" + name + "\" on dataset \"" + inputDataset.getFullName() + "\" (" + ss.steps.size() + " processors)";
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, StreamableDatasetSelection selection, ColumnFactory cf) throws Exception {
        MemScriptRunner.TableWithReport tableWithReport = this.dataService.get_NOTRANSACTION(this.inputDataset, this.script.deepCopy(), null, null, true, (AuthCtx)this.user);
        MemTable table = tableWithReport.table;
        this.cf = cf;
        this.schema = TableToSchema.inferSchemaSimple(table, true);
        this.selection = selection;
    }

    @Override
    public Schema getSchema() throws Exception {
        return this.schema;
    }

    @Override
    public ExportInput.InputDescription describe() {
        return this.description;
    }

    @Override
    public long getInputSize() {
        return -1L;
    }

    @Override
    public void close() {
    }

    @Override
    public void stream(ProcessorOutput outputStream) throws Exception {
        this.description.status = "Initializing script...";
        StreamRowFactory rf = new StreamRowFactory();
        SerializedShakerScript es = this.script.expandedDeepCopy(this.variablesService.getForProject(this.inputDataset.getProjectKey()));
        StreamPipelineFactory.StreamPipeline streamPipeline = StreamPipelineFactory.build(es.steps, BaseProcessorsFactory.PipelineContext.sharedPipelineContext(), true);
        Object last = Iterables.getLast(streamPipeline.allProcessors);
        if (!(last instanceof SingleOutputRowProcessor)) {
            throw ErrorContext.iae((String)"Could not plug output, no end of pipe");
        }
        ((SingleOutputRowProcessor)last).setProcessorOutput(outputStream);
        Object first = streamPipeline.allProcessors.get(0);
        if (!(first instanceof SingleInputRowProcessor)) {
            throw ErrorContext.iae((String)"Could not plug input");
        }
        ProcessorOutputToSIP connector = new ProcessorOutputToSIP((SingleInputRowProcessor)first);
        for (Object o : streamPipeline.allProcessors) {
            Object rproc;
            if (o instanceof ProcessorWithResourceFiles) {
                rproc = (ProcessorWithResourceFiles)o;
                rproc.setRequiredFiles(rproc.gatherRequirements());
            }
            if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithResourceFiles) {
                rproc = (ProcessorWithResourceFiles)((SRPAdapter)o).getProcessor();
                rproc.setRequiredFiles(rproc.gatherRequirements());
            }
            if (o instanceof ProcessorWithResolvedParams) {
                rproc = (ProcessorWithResolvedParams)o;
                rproc.resolve(this.user, this.inputDataset.getProjectKey());
            }
            if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithResolvedParams) {
                rproc = (ProcessorWithResolvedParams)((SRPAdapter)o).getProcessor();
                rproc.resolve(this.user, this.inputDataset.getProjectKey());
            }
            if (o instanceof ProcessorWithSubProcess) {
                rproc = (ProcessorWithSubProcess)o;
                rproc.spawn(this.user, this.inputDataset.getProjectKey(), true, null);
            }
            if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithSubProcess) {
                rproc = (ProcessorWithSubProcess)((SRPAdapter)o).getProcessor();
                rproc.spawn(this.user, this.inputDataset.getProjectKey(), true, null);
            }
            if (o instanceof SingleInputSingleOutputRowProcessor) {
                ((SingleInputSingleOutputRowProcessor)o).setFactories(this.cf, (RowFactory)rf);
                ((SingleInputSingleOutputRowProcessor)o).init();
                continue;
            }
            if (!(o instanceof ProcessorWithFactories)) continue;
            ((ProcessorWithFactories)o).setFactories(this.cf, (RowFactory)rf);
        }
        try (Transaction t = this.transactionService.beginRead();){
            StreamedAdditionalInputAccessor additionalInputsAccessor = new StreamedAdditionalInputAccessor(this.user, this.inputDataset.getProjectKey(), this.datasetsDAO);
            List<SingleCopyAdditionalInputsLoader> additionalInputLoaders = AdditionalInputsHelper.getLoadersForAllProcessors(additionalInputsAccessor, es.steps, null);
            AdditionalInputsHelper.setAdditionalInputsOnProcessors(additionalInputsAccessor, additionalInputLoaders, streamPipeline.allProcessors);
        }
        this.description.status = "Executing script...";
        UniversalSingleThreadPusher.push((AuthCtx)this.user, this.inputDataset, this.selection, (ProcessorOutput)connector, this.cf, (RowFactory)rf);
        connector.lastRowEmitted();
    }

    @Override
    public FuturePayload.FuturePayloadTarget getSource() {
        return DSSFuturePayloadUtils.forDataset(this.inputDataset).withPart("script");
    }

    public TableColoring getColoring() {
        return this.script != null ? ExportUtils.convertColoring(this.script.coloring) : null;
    }

    public SerializedDataset getSerializedDataset() {
        return this.inputDataset.serialize();
    }
}

