/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport;

import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.graphicsexport.model.ExportRequest;
import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.util.ArrayList;

public abstract class AbstractExportFormatBuilder<E extends ExportFormat> {
    protected ExportRequest exportRequest;

    public AbstractExportFormatBuilder(ExportRequest exportRequest) {
        this.exportRequest = exportRequest;
    }

    protected abstract E buildInternal();

    public E build() {
        E format = this.buildInternal();
        ((ExportFormat)format).paperSize = this.parseEnumParam("paperSize", this.exportRequest.paperSize, ExportFormat.PaperSize.class, ExportFormat.PaperSize.CUSTOM);
        ((ExportFormat)format).orientation = this.parseEnumParam("orientation", this.exportRequest.orientation, ExportFormat.Orientation.class, ExportFormat.Orientation.LANDSCAPE);
        ((ExportFormat)format).fileType = this.parseEnumParam("fileType", this.exportRequest.fileType, ExportFormat.FileType.class, ExportFormat.FileType.PDF);
        if (((ExportFormat)format).paperSize == ExportFormat.PaperSize.CUSTOM) {
            if (AbstractExportFormatBuilder.isInvalidDimension(this.exportRequest.width)) {
                throw new IllegalArgumentException("width parameter is mandatory if paperSize is missing or set to CUSTOM.");
            }
            if (AbstractExportFormatBuilder.isInvalidDimension(this.exportRequest.height)) {
                throw new IllegalArgumentException("height parameter is mandatory if paperSize is missing or set to CUSTOM.");
            }
        }
        ((ExportFormat)format).width = this.exportRequest.width;
        ((ExportFormat)format).height = this.exportRequest.height;
        return format;
    }

    private <T extends Enum> T parseEnumParam(String paramName, String value, Class<T> clazz, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        ArrayList<String> possibleValues = new ArrayList<String>();
        Field altNameField = AbstractExportFormatBuilder.getAltNameField(clazz);
        for (Enum enumConstant : (Enum[])clazz.getEnumConstants()) {
            String name = enumConstant.name();
            if (name.equalsIgnoreCase(value)) {
                return (T)enumConstant;
            }
            possibleValues.add(name);
            String altName = AbstractExportFormatBuilder.getAltName(altNameField, enumConstant);
            if (altName == null) continue;
            if (altName.equalsIgnoreCase(value)) {
                return (T)enumConstant;
            }
            possibleValues.add(altName);
        }
        throw new IllegalArgumentException("Invalid " + paramName + " parameter value. Accepted values are: " + Joiner.on((String)", ").join(possibleValues));
    }

    private static <T extends Enum> Field getAltNameField(Class<T> clazz) {
        Field altNameField = null;
        try {
            altNameField = clazz.getField("altName");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return altNameField;
    }

    private static <T extends Enum> String getAltName(Field altNameField, T enumInstance) {
        if (altNameField != null) {
            try {
                String altName = (String)altNameField.get(enumInstance);
                if (altName != null) {
                    return altName;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isInvalidDimension(Integer value) {
        return value == null || value <= 0;
    }
}

