/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive.sequencefile;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.formats.hive.HiveFileOutputWriter;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileFormatConfig;
import com.dataiku.dip.output.CanListFilesWrittenTo;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.io.Writable;

public class SequenceFileOutput
implements Output,
CanListFilesWrittenTo {
    private final Partition targetPartition;
    private final int targetSplit;
    private final SequenceFileFormatConfig config;
    private final WarningsContext warningsContext;
    private final Dataset dataset;
    private final HDFSProvider provider;

    public SequenceFileOutput(HDFSProvider provider, Dataset dataset, Partition targetPartition, int targetSplit, SequenceFileFormatConfig config, WarningsContext warningsContext) {
        this.provider = provider;
        this.dataset = dataset;
        this.targetPartition = targetPartition;
        this.targetSplit = targetSplit;
        this.config = (SequenceFileFormatConfig)Preconditions.checkNotNull((Object)config);
        this.warningsContext = warningsContext == null ? new WarningsContext() : warningsContext;
    }

    public OutputWriter getWriter(Output.WriteMode mode) throws IOException, DKUSecurityException {
        assert (mode == Output.WriteMode.APPEND);
        return new SequenceFileOutputWriter();
    }

    public List<String> list(OutputWriter writer) throws IOException, InterruptedException {
        return ((HiveFileOutputWriter)writer).gatherWritesInProgress();
    }

    public List<String> recoverList() throws IOException, CodedException, DKUSecurityException {
        return HiveFileOutputWriter.gatherPathsWrittenToAndNotCommitted(this.provider, this.targetSplit);
    }

    public class SequenceFileOutputWriter
    extends HiveFileOutputWriter {
        public SequenceFileOutputWriter() throws DKUSecurityException, IOException {
            super(SequenceFileOutput.this.provider, SequenceFileOutput.this.dataset, SequenceFileOutput.this.targetPartition, SequenceFileOutput.this.targetSplit, SequenceFileOutput.this.warningsContext, SequenceFileOutput.this.config);
        }

        @Override
        protected String getFileExtension() {
            return "seq";
        }

        @Override
        protected HiveOutputFormat<? extends Writable, ? extends Writable> getFileOutputFormat() {
            return new HiveSequenceFileOutputFormat();
        }
    }
}

