/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.utils;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.input.stream.UnpartitionedInputSplit;
import com.dataiku.dip.input.stream.UnsplittedStreamDatasetHandler;
import com.dataiku.dip.input.utils.InputStreamEnrichedStream;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExternalInputStreamInput
extends UnsplittedStreamDatasetHandler {
    InputStream is;
    String filename;
    @Nonnull
    LongSupplier lastModifiedSupplier;

    public ExternalInputStreamInput(InputStream is) {
        this.is = is;
        this.lastModifiedSupplier = () -> 0L;
    }

    public ExternalInputStreamInput(InputStream is, String filename, @Nonnull LongSupplier lastModifiedSupplier) {
        this.is = is;
        this.filename = filename;
        this.lastModifiedSupplier = lastModifiedSupplier;
    }

    @Override
    public void createManaged() throws Exception {
        throw new IllegalArgumentException("");
    }

    @Override
    public long getLatestTimestamp() throws IOException {
        return 0L;
    }

    @Override
    public StreamsInputSplit getSingleSplit() {
        return new Split();
    }

    @Override
    public DatasetReadiness getReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        return DatasetReadiness.ready(null);
    }

    @Override
    public void clearPartitions(List<Partition> partitionIdentifiers) throws Exception {
    }

    @Override
    public Dataset getDataset() {
        return null;
    }

    @Override
    public boolean isManaged() {
        return false;
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return null;
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException {
    }

    @Override
    public String suggestName() {
        return null;
    }

    @Override
    public long getRecords() throws Exception {
        return 0L;
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        return 0L;
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        return false;
    }

    @Override
    public void clearAllData() throws Exception {
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return null;
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        return null;
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        return false;
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() throws Exception {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return this.getMeta().isParallelWritable();
    }

    @Override
    public boolean outputHandlesClear() {
        return false;
    }

    class Split
    extends UnpartitionedInputSplit {
        boolean called;

        Split() {
        }

        public EnrichedInputStream nextStream() throws IOException {
            if (this.called) {
                return null;
            }
            this.called = true;
            return new InputStreamEnrichedStream(ExternalInputStreamInput.this.is).withFilename(ExternalInputStreamInput.this.filename).withLastModifiedSupplier(ExternalInputStreamInput.this.lastModifiedSupplier);
        }

        public void reset() {
            this.called = false;
        }
    }
}

