/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.im;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.integrations.AbstractHttpIntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.IntegrationChannelMeta;
import com.dataiku.dip.integrations.IntegrationChannelParams;
import com.dataiku.dip.integrations.IntegrationDirectUseEvent;
import com.dataiku.dip.integrations.IntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.integrations.IntegrationParams;
import com.dataiku.dip.integrations.im.TeamsIntegrationParams;
import com.dataiku.dip.notifications.DefaultEventMessageBuilder;
import com.dataiku.dip.scheduler.IntegrationChannelsDAO;
import com.dataiku.dip.scheduler.reports.ScenarioReportEvent;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IntegrationChannelPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.markups.Markup;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertEvent;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.BackendVariablesService;
import com.dataiku.dss.shadelib.com.google.common.base.MoreObjects;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.springframework.beans.factory.annotation.Autowired;

public class TeamsIntegrationHandler
extends AbstractHttpIntegrationEventHandler {
    @Autowired
    private BackendVariablesService backendVariablesService;
    private static final String DEFAULT_SCENARIO_MESSAGE_OFFICE365 = "${if(outcome == 'SUCCESS', '&#x2705;', '')}${if(outcome == 'FAILED', '&#x1F534;', '')}${if(outcome == 'WARNING', '&#x1F536;', '')}${if(outcome == '' || outcome == 'N/A', '&#x1F514;', '')} DSS Scenario [${scenarioName}](${scenarioRunURL}) triggered by ${triggerName}: **${outcome}**";
    private static final String DEFAULT_SCENARIO_MESSAGE_WORKFLOWS = "${if(outcome == 'SUCCESS', '\u2705', '')}${if(outcome == 'FAILED', '\ud83d\udd34', '')}${if(outcome == 'WARNING', '\ud83d\udd36', '')}${if(outcome == '' || outcome == 'N/A', '\ud83d\udd14', '')} DSS Scenario [${scenarioName}](${scenarioRunURL}) triggered by ${triggerName}: **${outcome}**";
    public static final IntegrationChannelMeta CHANNEL_META = new IntegrationChannelMeta(){

        public Class<? extends IntegrationChannelParams> paramsClass() {
            return TeamsChannelParams.class;
        }

        public String getType() {
            return "msft-teams";
        }

        public String getAssociatedIntegrationType() {
            return "msft-teams-scenario";
        }
    };
    public static final IntegrationMeta SCENARIO_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "msft-teams-scenario";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return TeamsIntegrationParams.TeamsScenarioIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new TeamsIntegrationHandler(authCtx, messaging.getConfigurationAs(TeamsIntegrationParams.TeamsScenarioIntegrationParams.class), permissionCheckContext);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
        }
    };
    public static final IntegrationMeta PROJECT_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "msft-teams-project";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return TeamsIntegrationParams.TeamsProjectIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new TeamsIntegrationHandler(authCtx, messaging.getConfigurationAs(TeamsIntegrationParams.TeamsProjectIntegrationParams.class), permissionCheckContext);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
            configuration.getConfigurationAs(TeamsIntegrationParams.TeamsProjectIntegrationParams.class).encryptFields(symetricCryptoService, security);
        }
    };
    public static final IntegrationMeta DIRECT_USE_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "msft-teams-direct";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return TeamsIntegrationParams.TeamsFreeFormIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new TeamsIntegrationHandler(authCtx, messaging.getConfigurationAs(TeamsIntegrationParams.TeamsFreeFormIntegrationParams.class), permissionCheckContext);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
            configuration.getConfigurationAs(TeamsIntegrationParams.TeamsFreeFormIntegrationParams.class).encryptFields(symetricCryptoService, security);
        }
    };
    public static final IntegrationMeta UNIFIED_MONITORING_ALERTING_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "msft-teams-unified-monitoring-alerting";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return TeamsIntegrationParams.TeamsUnifiedMonitoringIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new TeamsIntegrationHandler(authCtx, messaging.getConfigurationAs(TeamsIntegrationParams.TeamsUnifiedMonitoringIntegrationParams.class), permissionCheckContext);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
            configuration.getConfigurationAs(TeamsIntegrationParams.TeamsUnifiedMonitoringIntegrationParams.class).encryptFields(symetricCryptoService, security);
        }
    };
    private final TeamsIntegrationParams params;
    private final TeamsChannelParams channelParams;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IntegrationChannelsDAO channelsDao;
    @Autowired
    private IntegrationChannelPermissionsService integrationChannelPermissionsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.sender.teams");

    private TeamsIntegrationHandler(AuthCtx authCtx, TeamsIntegrationParams params, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
        SpringUtils.getInstance().autowire((Object)this);
        this.params = params;
        if (params.useGlobalChannel()) {
            IntegrationChannel channel;
            try (Transaction ignored = this.transactionService.beginRead();){
                channel = this.channelsDao.getMandatory(params.channelId);
            }
            if (permissionCheckContext.checkCanUseIntegrationChannel) {
                this.integrationChannelPermissionsService.checkIntegrationChannelUse(authCtx, channel);
            }
            this.channelParams = (TeamsChannelParams)channel.getConfigurationAs(TeamsChannelParams.class);
        } else {
            this.channelParams = new TeamsChannelParams();
            this.channelParams.useProxy = params.useProxy;
            this.channelParams.webhookUrl = params.webhookUrl;
            this.channelParams.webhookType = params.webhookType;
        }
    }

    @Override
    public void handleEvent(DSSEvent event, InfoMessage.InfoMessages messages) throws Exception {
        if (event instanceof IntegrationDirectUseEvent) {
            IntegrationDirectUseEvent directUseEvent = (IntegrationDirectUseEvent)event;
            TeamsIntegrationParams.TeamsFreeFormIntegrationParams directParams = (TeamsIntegrationParams.TeamsFreeFormIntegrationParams)this.params;
            StringSubstitutor substitutor = new StringSubstitutor((StringLookup)directUseEvent.lookup);
            this.sendNotification(substitutor.replace(this.channelParams.webhookUrl), this.channelParams.useProxy, this.buildDirectUseMessageCard(directUseEvent, directParams, this.channelParams.webhookType));
        } else if (event instanceof ScenarioReportEvent) {
            ScenarioReportEvent reportEvent = (ScenarioReportEvent)event;
            String webhookUrl = new StringSubstitutor((StringLookup)reportEvent.lookup).replace(this.channelParams.webhookUrl);
            this.sendNotification(webhookUrl, this.channelParams.useProxy, this.buildScenarioMessageCard(reportEvent, this.channelParams.webhookType));
        } else if (event instanceof UnifiedMonitoringAlertEvent) {
            UnifiedMonitoringAlertEvent umevent = (UnifiedMonitoringAlertEvent)event;
            StringSubstitutor substitutor = new StringSubstitutor((StringLookup)umevent.lookup);
            TeamsIntegrationParams.TeamsUnifiedMonitoringIntegrationParams umparams = (TeamsIntegrationParams.TeamsUnifiedMonitoringIntegrationParams)this.params;
            this.sendNotification(this.channelParams.webhookUrl, this.channelParams.useProxy, TeamsIntegrationHandler.buildTeamsNotificationJson(substitutor.replace(umparams.message), this.channelParams.webhookType));
        } else {
            String webhookUrl;
            if (event instanceof ProjectEvent && this.channelParams.webhookUrl != null && this.channelParams.webhookUrl.contains("${")) {
                String projectKey = ((ProjectEvent)event).getProjectKey();
                webhookUrl = new StringSubstitutor(this.backendVariablesService.getForProject(projectKey).getAllVariables()).replace(this.channelParams.webhookUrl);
            } else {
                webhookUrl = this.channelParams.webhookUrl;
            }
            this.sendNotification(webhookUrl, this.channelParams.useProxy, this.buildProjectMessageCard(event, this.channelParams.webhookType));
        }
    }

    private String buildProjectMessageCard(DSSEvent event, TeamsWebhookType webhookType) {
        TeamsIntegrationParams.TeamsProjectIntegrationParams projectParams = (TeamsIntegrationParams.TeamsProjectIntegrationParams)this.params;
        if (!projectParams.selection.shouldSend(event)) {
            return null;
        }
        String message = new DefaultEventMessageBuilder().build(event, Markup.TEAMS_MARKDOWN);
        return TeamsIntegrationHandler.buildTeamsNotificationJson(TeamsIntegrationHandler.markdownify(message), webhookType);
    }

    private String buildScenarioMessageCard(ScenarioReportEvent event, TeamsWebhookType webhookType) {
        TeamsIntegrationParams.TeamsScenarioIntegrationParams scenarioParams = (TeamsIntegrationParams.TeamsScenarioIntegrationParams)this.params;
        String defaultTemplate = webhookType == TeamsWebhookType.WORKFLOWS ? DEFAULT_SCENARIO_MESSAGE_WORKFLOWS : DEFAULT_SCENARIO_MESSAGE_OFFICE365;
        String template = StringUtils.defaultIfBlank((String)scenarioParams.message, (String)defaultTemplate).trim();
        String message = new StringSubstitutor((StringLookup)event.lookup).replace(template);
        if (message.startsWith("{") && message.endsWith("}")) {
            return message;
        }
        return TeamsIntegrationHandler.buildTeamsNotificationJson(message, webhookType);
    }

    private String buildDirectUseMessageCard(IntegrationDirectUseEvent event, TeamsIntegrationParams.TeamsFreeFormIntegrationParams directParams, TeamsWebhookType webhookType) {
        StringSubstitutor substitutor = new StringSubstitutor((StringLookup)event.lookup);
        String message = (String)MoreObjects.firstNonNull((Object)directParams.message, (Object)"${message}");
        if ((message = substitutor.replace(message)).startsWith("{") && message.endsWith("}")) {
            return message;
        }
        return TeamsIntegrationHandler.buildTeamsNotificationJson(message, webhookType);
    }

    private void sendNotification(String webhookUrl, boolean useProxy, String json) throws IOException, InterruptedException {
        boolean throttled;
        if (json == null) {
            return;
        }
        logger.info((Object)("Sending notification to Teams:" + json));
        if (StringUtils.isBlank((String)webhookUrl)) {
            throw new IllegalArgumentException("WebHook URL is empty");
        }
        int retryCount = 0;
        do {
            AbstractHttpIntegrationEventHandler.RequestResponse response;
            if (!(response = this.postJsonRequest(webhookUrl, useProxy, json, NO_AUTH)).isSuccess()) {
                throw new IOException(String.format("API call to post message on Teams failed %d: %s", response.statusCode, response.statusReason));
            }
            if (response.content.contains("Microsoft Teams endpoint returned HTTP error 429")) {
                throttled = true;
                if (retryCount > 5) {
                    throw new IOException(String.format("API call to post message on Teams failed (retried %d times - giving up) %d: %s - %s", retryCount, response.statusCode, response.statusReason, response.content));
                }
                int sleepTime = new Random().nextInt(1 << retryCount);
                logger.info((Object)String.format("Microsoft Teams webhook rejected our request for throttling reason. Will try again in %d seconds", sleepTime));
                Thread.sleep((long)sleepTime * 1000L);
                ++retryCount;
                continue;
            }
            logger.info((Object)String.format("Microsoft Teams webhook responded %d (%s): %s", response.statusCode, response.statusReason, response.content));
            throttled = false;
        } while (throttled);
    }

    private static String markdownify(String msg) {
        return msg.replaceAll("<a\\s(?!</a)href=\"([^\"]*)\"\\s*>([^<]*)</a\\s*>", "[$2]($1)").replaceAll("<br\\s*/>", "\n").replaceAll("_", "\\\\_");
    }

    private static String buildTeamsNotificationJson(String message, TeamsWebhookType webhookType) {
        if (webhookType == null || webhookType == TeamsWebhookType.OFFICE365) {
            JsonObject payload = new JsonObject();
            payload.addProperty("@type", "MessageCard");
            payload.addProperty("@context", "https://schema.org/extensions");
            payload.addProperty("themeColor", "50C0AB");
            payload.addProperty("text", message);
            return JSON.json((Object)payload);
        }
        JsonObject payload = new JsonObject();
        JsonArray attachments = new JsonArray();
        payload.add("attachments", (JsonElement)attachments);
        JsonObject attachment = new JsonObject();
        attachments.add((JsonElement)attachment);
        attachment.addProperty("contentType", "application/json");
        JsonObject content = new JsonObject();
        attachment.add("content", (JsonElement)content);
        content.addProperty("$schema", "http://adaptivecards.io/schemas/adaptive-card.json");
        content.addProperty("type", "AdaptiveCard");
        content.addProperty("version", "1.0");
        JsonArray body = new JsonArray();
        content.add("body", (JsonElement)body);
        JsonObject item = new JsonObject();
        body.add((JsonElement)item);
        item.addProperty("type", "TextBlock");
        item.addProperty("text", message);
        item.addProperty("wrap", Boolean.valueOf(true));
        return JSON.json((Object)payload);
    }

    @VisibleForTesting
    static String summarize(String msg) {
        String stripped = msg.replaceAll("<a\\s(?!</a)href=\"([^\"]*)\"\\s*>([^<]*)</a\\s*>", "$2").replaceAll("<br\\s*/>", "\n");
        String firstLine = stripped.split("\n")[0];
        return TeamsIntegrationHandler.ellipses(firstLine);
    }

    private static String ellipses(String message) {
        if (message == null) {
            return "";
        }
        if (message.length() >= 40) {
            return message.substring(0, 37) + "...";
        }
        return message;
    }

    public static class TeamsChannelParams
    extends AbstractHttpIntegrationEventHandler.HTTPChannelConfiguration {
        public String webhookUrl;
        public TeamsWebhookType webhookType = TeamsWebhookType.OFFICE365;
    }

    public static enum TeamsWebhookType {
        OFFICE365,
        WORKFLOWS;

    }
}

