/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling;

import com.dataiku.dip.labeling.LabelingAnswer;
import com.dataiku.dip.labeling.LabelingMetrics;
import com.dataiku.dip.labeling.LabelingTaskStats;
import com.dataiku.dip.labeling.score.LabelingScoreComputer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class PerAnnotatorStatsBuilder<S extends LabelingScoreComputer.AnswerScore, M extends LabelingMetrics> {
    private final Map<String, LabelerStatsBuilder> perLabelerStatsBuilder = new HashMap<String, LabelerStatsBuilder>();
    private final LabelingScoreComputer<S, M> scoreComputer;

    public PerAnnotatorStatsBuilder(LabelingScoreComputer<S, M> scoreComputer) {
        this.scoreComputer = scoreComputer;
    }

    public void fillWithAnswer(LabelingAnswer answer) {
        this.perLabelerStatsBuilder.putIfAbsent(answer.annotatorId, new LabelerStatsBuilder());
        LabelerStatsBuilder statsBuilder = this.perLabelerStatsBuilder.get(answer.annotatorId);
        statsBuilder.incrementStatus(answer.status);
        statsBuilder.incrementScore(answer);
    }

    public Map<String, LabelingTaskStats.LabelerStats> getPerLabelerStats() {
        HashMap<String, LabelingTaskStats.LabelerStats> metrics = new HashMap<String, LabelingTaskStats.LabelerStats>();
        for (String labeler : this.perLabelerStatsBuilder.keySet()) {
            metrics.put(labeler, this.perLabelerStatsBuilder.get(labeler).getLabelerStats());
        }
        return metrics;
    }

    private class LabelerStatsBuilder {
        private final Map<LabelingAnswer.AnswerStatus, Long> perAnswerStatusCount = Maps.newHashMap((Map)ImmutableMap.of((Object)((Object)LabelingAnswer.AnswerStatus.PENDING_REVIEW), (Object)0L, (Object)((Object)LabelingAnswer.AnswerStatus.REVIEWED), (Object)0L));
        private final S score;

        private LabelerStatsBuilder() {
            this.score = PerAnnotatorStatsBuilder.this.scoreComputer.initScore();
        }

        private void incrementStatus(LabelingAnswer.AnswerStatus status) {
            this.perAnswerStatusCount.put(status, 1L + this.perAnswerStatusCount.getOrDefault((Object)status, 0L));
        }

        private void incrementScore(LabelingAnswer answer) {
            PerAnnotatorStatsBuilder.this.scoreComputer.incrementScore(this.score, PerAnnotatorStatsBuilder.this.scoreComputer.score(answer));
        }

        private LabelingTaskStats.LabelerStats getLabelerStats() {
            LabelingTaskStats.LabelerStats labelerStats = new LabelingTaskStats.LabelerStats();
            labelerStats.perAnswerStatusCount = this.perAnswerStatusCount;
            labelerStats.metrics = PerAnnotatorStatsBuilder.this.scoreComputer.getMetrics(this.score);
            return labelerStats;
        }
    }
}

