/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.consensus;

import com.dataiku.dip.labeling.Label;
import com.dataiku.dip.labeling.consensus.ConsensusLabelComputer;
import com.dataiku.dip.labeling.entityextraction.NamedEntity;
import com.dataiku.dip.labeling.region.LabelingRegion;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NamedEntityExtractionMajorityConsensusLabelComputer
implements ConsensusLabelComputer<NamedEntity> {
    @Override
    public Label<NamedEntity> compute(List<LabelingRegion<NamedEntity>> regions) {
        Label.NamedEntityExtractionLabel label = new Label.NamedEntityExtractionLabel();
        for (LabelingRegion<NamedEntity> region : regions) {
            label.annotations.add(this.getMajorityNamedEntity(region));
        }
        return label;
    }

    private NamedEntity getMajorityNamedEntity(LabelingRegion<NamedEntity> region) {
        Map<NamedEntity, Long> countSameAnnotation = region.elements.stream().collect(Collectors.groupingBy(r -> (NamedEntity)r.annotation, Collectors.counting()));
        return (NamedEntity)Collections.max(countSameAnnotation.entrySet(), Comparator.comparingInt(entry -> ((Long)entry.getValue()).intValue())).getKey();
    }
}

