/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.langchain;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.llm.langchain.AbstractAgentLLMClient;
import com.dataiku.dip.llm.langchain.PythonLLMServer;
import com.dataiku.dip.llm.langchain.PythonLLMServerKernelPool;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class ToolsUsingAgentLLMClient
extends AbstractAgentLLMClient {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.agent");

    public ToolsUsingAgentLLMClient(DSSAuthCtx authCtx, String projectKey, SavedModel sm, SavedModel.SavedModelInlineVersion smiv, boolean devKernel) throws Exception {
        super(authCtx, projectKey, sm, smiv, devKernel);
    }

    @Override
    protected synchronized void initOnce() throws IOException {
        block7: {
            String pyClazz;
            String PY_CLAZZ_V1 = "dataiku.llm.python.tools_using.ToolUsingAgent";
            String PY_CLAZZ_V2 = "dataiku.llm.python.tools_using_2.ToolUsingAgent";
            String string = pyClazz = DKUApp.getParams().getBoolParam("dku.agents.visual.agenticLoopV2", false) ? "dataiku.llm.python.tools_using_2.ToolUsingAgent" : "dataiku.llm.python.tools_using.ToolUsingAgent";
            if (this.serverAPI == null) {
                this.validateParameters();
                try {
                    String envName = DKUApp.getParams().getParam("dku.llm.visualAgent.codeenv", DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.RAG_CODE_ENV));
                    String containerConfName = new ContainerExecConfigSelector().selectConfName_autoTXN(this.authCtx, this.savedModel.projectKey, this.smiv.toolsUsingAgentSettings.containerExecSelection);
                    String clusterId = new ClusterSelector().selectForProject(this.authCtx, this.savedModel.projectKey).getClusterId();
                    JsonObject config = JSON.toJsonObject((Object)this.smiv.toolsUsingAgentSettings);
                    PythonLLMServerKernelPool kernelPool = (PythonLLMServerKernelPool)SpringUtils.getBean(PythonLLMServerKernelPool.class);
                    if (this.isDevMode()) {
                        File logBaseDir = DKUApp.getFile((String[])new String[]{"saved_models", this.savedModel.projectKey, this.savedModel.id, "versions", this.smiv.versionId, "logs"});
                        PythonLLMServer server = new PythonLLMServer(this.authCtx, this.savedModel.projectKey, this.savedModel.id, this.smiv.versionId, pyClazz, null, envName, containerConfName, null, null, logBaseDir, config, null, true, false, false);
                        try {
                            server.start();
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Kernel failed to start, closing it", (Throwable)e);
                            IOUtils.closeQuietly((Closeable)server, null);
                            throw e;
                        }
                        this.serverAPI = server;
                        break block7;
                    }
                    this.serverAPI = kernelPool.getServerAPI(this.authCtx, this.savedModel.projectKey, this.savedModel.id, this.smiv, pyClazz, null, config, null, envName, containerConfName, null, null, false, clusterId, this.smiv.toolsUsingAgentSettings, this.devKernel);
                }
                catch (CustomPythonKernelException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException("Failed to initialize Python LLM", e);
                }
            }
        }
    }

    private void validateParameters() throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)this.smiv.toolsUsingAgentSettings.llmId)) {
            throw new IllegalArgumentException("Missing llmId for visual agent, model " + this.savedModel.id + " version " + this.smiv.versionId);
        }
        if (this.smiv.toolsUsingAgentSettings.llmId.startsWith("agent:" + this.savedModel.id)) {
            throw new IllegalArgumentException("Illegal self-reference for visual agent, " + this.savedModel.id + " version " + this.smiv.versionId);
        }
    }

    @Override
    public String getProviderId() {
        return "tools-using-agent";
    }
}

