/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai.api.responses;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.openai.api.responses.OpenAIResponsesChunk;
import com.dataiku.dip.llm.online.openai.api.responses.OpenAIResponsesResponse;
import com.dataiku.dip.llm.online.openai.api.responses.OpenAIResponsesResponseAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class OpenAIResponsesChunkAdapter {
    public static LLMClient.StreamedCompletionResponseChunk adaptOutputTextDelta(OpenAIResponsesChunk.OutputTextDeltaChunk chunk) {
        if (chunk.delta == null) {
            throw new IllegalArgumentException("Empty chat chunk response");
        }
        LLMClient.StreamedCompletionResponseChunk resp = new LLMClient.StreamedCompletionResponseChunk();
        resp.text = chunk.delta;
        if (chunk.logprobs != null && !chunk.logprobs.isEmpty()) {
            resp.logProbs = chunk.logprobs.stream().map(OpenAIResponsesResponseAdapter::adapt).collect(Collectors.toList());
        }
        return resp;
    }

    public static LLMClient.StreamedCompletionResponseChunk adaptReasoningSummaryDelta(OpenAIResponsesChunk.ReasoningSummaryDeltaChunk chunk) {
        if (chunk.delta == null) {
            throw new IllegalArgumentException("Empty reasoning summary chunk");
        }
        LLMClient.StreamedCompletionResponseChunk resp = new LLMClient.StreamedCompletionResponseChunk();
        resp.artifacts = new ArrayList<LLMClient.Artifact>();
        LLMClient.Artifact artifact = new LLMClient.Artifact();
        artifact.id = chunk.id;
        artifact.type = "REASONING";
        artifact.parts = new ArrayList<LLMClient.SourceItem>();
        LLMClient.SourceItem reasoningSummary = new LLMClient.SourceItem();
        reasoningSummary.type = "TEXT";
        reasoningSummary.text = chunk.delta;
        reasoningSummary.index = chunk.summaryIndex;
        artifact.parts.add(reasoningSummary);
        resp.artifacts.add(artifact);
        return resp;
    }

    public static LLMClient.StreamedCompletionResponseChunk adaptFunctionCall(OpenAIResponsesChunk.OutputItemAdded item) {
        LLMClient.StreamedCompletionResponseChunk resp = new LLMClient.StreamedCompletionResponseChunk();
        LLMClient.FunctionToolCallInfo function = new LLMClient.FunctionToolCallInfo();
        function.name = item.item.name;
        function.arguments = item.item.arguments;
        LLMClient.FunctionToolCall ftc = new LLMClient.FunctionToolCall();
        ftc.index = item.outputIndex;
        ftc.id = item.item.id;
        ftc.function = function;
        resp.toolCalls = List.of(ftc);
        return resp;
    }

    public static LLMClient.StreamedCompletionResponseChunk adaptFunctionCallDelta(OpenAIResponsesChunk.FunctionCallArgumentsDelta chunk) {
        LLMClient.StreamedCompletionResponseChunk resp = new LLMClient.StreamedCompletionResponseChunk();
        LLMClient.FunctionToolCallInfo function = new LLMClient.FunctionToolCallInfo();
        function.arguments = chunk.delta;
        LLMClient.FunctionToolCall ftc = new LLMClient.FunctionToolCall();
        ftc.index = chunk.outputIndex;
        ftc.function = function;
        resp.toolCalls = List.of(ftc);
        return resp;
    }

    public static LLMClient.StreamedCompletionResponseFooter adaptFooter(OpenAIResponsesChunk.FinalResponse responseChunk) {
        LLMClient.StreamedCompletionResponseFooter footer = new LLMClient.StreamedCompletionResponseFooter();
        footer.finishReason = OpenAIResponsesResponseAdapter.adaptFinishReason(responseChunk.response);
        if (responseChunk.response.usage != null) {
            OpenAIResponsesResponse.Usage usage = responseChunk.response.usage;
            footer.completionTokens = usage.outputTokens;
            footer.promptTokens = usage.inputTokens;
            footer.totalTokens = usage.totalTokens;
        }
        return footer;
    }
}

