/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.SplitParams;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.analysis.model.core.ResolvedPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.AgentPerf;
import com.dataiku.dip.analysis.model.prediction.BinaryClassificationModelPerf;
import com.dataiku.dip.analysis.model.prediction.ClassificationModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.ColumnImportance;
import com.dataiku.dip.analysis.model.prediction.DataEvaluationMetrics;
import com.dataiku.dip.analysis.model.prediction.LLMModelPerf;
import com.dataiku.dip.analysis.model.prediction.MulticlassModelPerf;
import com.dataiku.dip.analysis.model.prediction.OtherClassificationModelPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPerf;
import com.dataiku.dip.analysis.model.prediction.RegressionModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.RegressionModelPerf;
import com.dataiku.dip.analysis.model.prediction.TimeseriesEvaluationForecasts;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.mec.AbstractGenAIModelEvaluation;
import com.dataiku.dip.mec.AbstractModelEvaluation;
import com.dataiku.dip.mec.MECPaths;
import com.dataiku.dip.mec.TabularModelEvaluation;
import com.dataiku.dip.mec.engine.CSVSchemaAdapter;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.beans.Transient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class FullModelEvaluationId
extends ModelLikeId {
    public static final Pattern EVALUATION_ID_PATTERN = Pattern.compile("(?<evaluationId>\\w+)$");
    public static final Pattern MODEL_EVALUATION_PATTERN = Pattern.compile("^ME-(?<projectKey>\\w+)-(?<mesId>\\w+)-(?<evaluationId>\\w+)$");
    public static final Pattern SMART_MODEL_EVALUATION_PATTERN = Pattern.compile("^ME-\\*-(?<mesId>\\w+)-(?<evaluationId>\\w+)$");
    public static final String POSTCOMPUTATION_SUBFOLDER = "postcomputation";
    public static final String SAMPLE_SCORED_CSV_GZ = "sample_scored.csv.gz";
    public static final String SAMPLE_SCORED_SCHEMA_JSON = "sample_scored_schema.json";
    public static final String DRIFT_REFERENCE_CSV_GZ = "drift_reference.csv.gz";
    public static final String DRIFT_REFERENCE_SCHEMA_JSON = "drift_reference.json";
    public static final String DRIFT_REFERENCE_PREDICTION_STATISTICS_JSON = "drift_reference_prediction_statistics.json";
    public static final String DATA_METRICS_JSON = "data_metrics.json";
    public String id;
    public String evaluationId;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis.fullmodelevaluationid");

    public FullModelEvaluationId(String projectKey, String id, String evaluationId) {
        super(projectKey, ModelLikeId.ModelLikeType.MODEL_EVALUATION);
        this.id = id;
        this.evaluationId = evaluationId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String toString() {
        return String.format("ME-%s-%s-%s", this.projectKey, this.id, this.evaluationId);
    }

    @Override
    public String toSmartModelLikeId(String contextProjectKey) {
        if (StringUtils.equals((String)contextProjectKey, (String)this.projectKey)) {
            return String.format("ME-*-%s-%s", this.id, this.evaluationId);
        }
        return this.toString();
    }

    public boolean checkEvaluationFileExists(String file) {
        return DKUFileUtils.exists((File)this.getMainFolder(), (String[])new String[]{file});
    }

    public boolean hasTabularPerformance() {
        return DKUFileUtils.exists((File)this.getMainFolder(), (String[])new String[]{"perf.json"}) || DKUFileUtils.exists((File)this.getMainFolder(), (String[])new String[]{"perf.json.gz"});
    }

    public PredictionModelPerf getTabularPerformance() throws IOException {
        TabularModelEvaluation evaluation = this.getTabularModelEvaluation();
        if (null == evaluation.predictionType) {
            return evaluation.ref.parseEvaluationFile("perf.json", OtherClassificationModelPerf.class);
        }
        switch (evaluation.predictionType) {
            case BINARY_CLASSIFICATION: {
                return evaluation.ref.parseEvaluationFile("perf.json", BinaryClassificationModelPerf.class);
            }
            case MULTICLASS: {
                return evaluation.ref.parseEvaluationFile("perf.json", MulticlassModelPerf.class);
            }
            case REGRESSION: {
                RegressionModelPerf rperf = evaluation.ref.parseEvaluationFile("perf.json", RegressionModelPerf.class);
                if (rperf.metrics != null && rperf.metrics.mape != null && (rperf.metrics.mape.isInfinite() || rperf.metrics.mape.isNaN())) {
                    rperf.metrics.mape = null;
                }
                return rperf;
            }
        }
        throw new Error("Unsupported prediction type:" + String.valueOf((Object)evaluation.predictionType));
    }

    private TimeseriesForecastingModelPerf getTimeseriesForecastingPerf() throws IOException {
        return FullModelEvaluationId.parsePossiblyCompressedJsonFile(this.getEvaluationFile("perf.json"), TimeseriesForecastingModelPerf.class);
    }

    public TimeseriesForecastingModelPerf getTimeseriesForecastingPerf(boolean withPerTimeseriesMetrics) throws IOException {
        assert (this.getPredictionType() == PredictionMLTask.PredictionType.TIMESERIES_FORECAST);
        TimeseriesForecastingModelPerf modelPerf = this.getTimeseriesForecastingPerf();
        if (withPerTimeseriesMetrics) {
            modelPerf.perTimeseriesMetrics = this.getTimeseriesForecastingPerTimeseriesPerf();
        }
        return modelPerf;
    }

    public Map<String, TimeseriesForecastingModelPerf.TimeseriesForecastingMetrics> getTimeseriesForecastingPerTimeseriesPerf() throws IOException {
        TimeseriesForecastingModelPerf perf = FullModelEvaluationId.parsePossiblyCompressedJsonFile(this.getEvaluationFile("per_timeseries_perf.json"), TimeseriesForecastingModelPerf.class);
        return perf.perTimeseriesMetrics;
    }

    public TimeseriesEvaluationForecasts getTimeseriesEvaluationForecasts() throws IOException {
        assert (this.getPredictionType() == PredictionMLTask.PredictionType.TIMESERIES_FORECAST);
        return FullModelEvaluationId.parsePossiblyCompressedJsonFile(this.getEvaluationFile("forecasts.json"), TimeseriesEvaluationForecasts.class);
    }

    public boolean hasLLMPerformance() {
        return DKUFileUtils.exists((File)this.getMainFolder(), (String[])new String[]{"llm_perf.json"});
    }

    public LLMModelPerf getLLMPerformance() throws IOException {
        return this.parseEvaluationFile("llm_perf.json", LLMModelPerf.class);
    }

    public boolean hasAgentPerformance() {
        return DKUFileUtils.exists((File)this.getMainFolder(), (String[])new String[]{"agent_perf.json"});
    }

    public AgentPerf getAgentPerformance() throws IOException {
        return this.parseEvaluationFile("agent_perf.json", AgentPerf.class);
    }

    public File getEvaluationFile(String file) {
        return DKUFileUtils.getWithinFollowLink((File)this.getMainFolder(), (String[])new String[]{file});
    }

    @Transient
    public <T> T parseEvaluationFile(String file, Class<T> clazz) throws IOException {
        return FullModelEvaluationId.parseJsonFile(this.getEvaluationFile(file), clazz);
    }

    @Override
    public boolean hasResolvedPreprocessingParams() {
        File f = this.getEvaluationFile("rpreprocessing_params.json");
        return f.isFile() && f.canRead();
    }

    @Override
    public ResolvedPreprocessingParams getResolvedPreprocessingParams() throws IOException {
        File fileRPP = this.getEvaluationFile("rpreprocessing_params.json");
        if (fileRPP.exists() && fileRPP.canRead()) {
            return (ResolvedPreprocessingParams)JSON.parseFile((File)fileRPP, ResolvedPreprocessingParams.class);
        }
        return null;
    }

    @Override
    @Transient
    public Map<String, FeaturePreprocessingParams> getFeatures() throws IOException {
        return this.getResolvedPredictionPreprocessingParams().per_feature;
    }

    @Transient
    public <T extends PredictionModelIntrinsicPerf> T getIPerf(Class<T> clazz) throws IOException {
        return (T)((PredictionModelIntrinsicPerf)JSON.parseFile((File)this.getEvaluationFile("iperf.json"), clazz));
    }

    public boolean hasIPerformance() {
        return DKUFileUtils.exists((File)this.getMainFolder(), (String[])new String[]{"iperf.json"});
    }

    public PredictionModelIntrinsicPerf getIPerformance() throws IOException {
        TabularModelEvaluation evaluation = this.getTabularModelEvaluation();
        switch (evaluation.predictionType) {
            case BINARY_CLASSIFICATION: 
            case MULTICLASS: {
                return this.parseEvaluationFile("iperf.json", ClassificationModelIntrinsicPerf.class);
            }
            case REGRESSION: {
                return this.parseEvaluationFile("iperf.json", RegressionModelIntrinsicPerf.class);
            }
        }
        throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)evaluation.predictionType));
    }

    @Override
    @Transient
    public File getMainFolder() {
        File storeFolder = MECPaths.modelEvaluationStoreBaseFolder(this.projectKey, this.id);
        return DKUFileUtils.getWithinFollowLink((File)storeFolder, (String[])new String[]{this.evaluationId});
    }

    @Override
    public File getSplitFolder() {
        return this.getMainFolder();
    }

    @Override
    @Transient
    public File getFolderEnsuringSecurity() {
        return this.getMainFolder();
    }

    @Transient
    public File getModelEvaluationFile() {
        return this.getEvaluationFile("evaluation.json");
    }

    @Override
    public boolean hasResolvedCoreParams() {
        File f = this.getEvaluationFile("core_params.json");
        return f.isFile() && f.canRead();
    }

    @Override
    public ResolvedCoreParams getResolvedCoreParams() throws IOException {
        return (ResolvedCoreParams)JSON.parseFile((File)this.getEvaluationFile("core_params.json"), ResolvedCoreParams.class);
    }

    public void saveResolvedCoreParams(ResolvedCoreParams resolvedCoreParams) throws IOException {
        JSON.prettyToFile((Object)resolvedCoreParams, (File)this.getEvaluationFile("core_params.json"));
    }

    @Override
    public DataEvaluationMetrics getDataEvaluationMetrics() throws IOException {
        File dataMetricsFile = this.getEvaluationFile(DATA_METRICS_JSON);
        if (dataMetricsFile.isFile()) {
            return (DataEvaluationMetrics)JSON.parseFile((File)dataMetricsFile, DataEvaluationMetrics.class);
        }
        return null;
    }

    public boolean hasDataEvaluationMetrics() {
        return this.getEvaluationFile(DATA_METRICS_JSON).exists();
    }

    @Override
    public File getCollectorDataFile() {
        return this.getEvaluationFile("collector_data.json");
    }

    @Override
    @Transient
    public File getSubpopulationFile() {
        return DKUFileUtils.getWithinFollowLink((File)this.getPostOperationsFolder(), (String[])new String[]{"subpop.json"});
    }

    @Override
    public File getPredictionStatisticsFile() {
        return this.getEvaluationFile("prediction_statistics.json");
    }

    public File getReferencePredictionStatisticsFile() {
        return this.getEvaluationFile(DRIFT_REFERENCE_PREDICTION_STATISTICS_JSON);
    }

    public boolean hasReferencePredictionStatisticsFile() {
        File referencePredictionFile = this.getReferencePredictionStatisticsFile();
        return referencePredictionFile.isFile() && referencePredictionFile.canRead();
    }

    @Override
    public boolean hasPredictionStatisticsFile() {
        File predictionsFile = this.getPredictionStatisticsFile();
        return predictionsFile.isFile() && predictionsFile.canRead();
    }

    @Transient
    public AbstractModelEvaluation getModelEvaluation() throws IOException {
        AbstractModelEvaluation me = (AbstractModelEvaluation)JSON.parseFile((File)this.getModelEvaluationFile(), AbstractModelEvaluation.class);
        me.setTransientReference(this);
        return me;
    }

    @Transient
    public TabularModelEvaluation getTabularModelEvaluation() throws IOException {
        AbstractModelEvaluation me = this.getModelEvaluation();
        if (!me.isTabular()) {
            throw new IllegalArgumentException(String.format("The model evaluation %s is not tabular", me.ref.evaluationId));
        }
        return (TabularModelEvaluation)me;
    }

    public AbstractGenAIModelEvaluation getGenAIModelEvaluation() throws IOException {
        AbstractModelEvaluation me = this.getModelEvaluation();
        if (!me.isLLM() && !me.isAgent()) {
            throw new IllegalArgumentException(String.format("The model evaluation %s is not genai", me.ref.evaluationId));
        }
        return (AbstractGenAIModelEvaluation)me;
    }

    @Transient
    public File getDriftReferenceFile() {
        return this.getEvaluationFile(DRIFT_REFERENCE_CSV_GZ);
    }

    @Transient
    public File getDriftReferenceSchemaFile() {
        return this.getEvaluationFile(DRIFT_REFERENCE_SCHEMA_JSON);
    }

    public Schema getScoredSchema() throws IOException {
        return (Schema)JSON.parseFile((File)this.getEvaluationFile(SAMPLE_SCORED_SCHEMA_JSON), Schema.class);
    }

    public File getSampleSchemaFile() throws IOException {
        return this.getEvaluationFile("sample_schema.json");
    }

    public Schema getSampleSchema() throws IOException {
        return (Schema)JSON.parseFile((File)this.getSampleSchemaFile(), Schema.class);
    }

    public Schema getDriftReferenceSchema() throws IOException {
        return (Schema)JSON.parseFile((File)this.getEvaluationFile(DRIFT_REFERENCE_SCHEMA_JSON), Schema.class);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FullModelEvaluationId other = (FullModelEvaluationId)object;
        return StringUtils.equals((String)this.projectKey, (String)other.projectKey) && StringUtils.equals((String)this.id, (String)other.id) && StringUtils.equals((String)this.evaluationId, (String)other.evaluationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.projectKey, this.id, this.evaluationId);
    }

    @Override
    @Transient
    public File getPostOperationsFolder() {
        return this.getEvaluationFile(POSTCOMPUTATION_SUBFOLDER);
    }

    @Override
    public MLTask.BackendType getBackendType() throws IOException {
        return MLTask.BackendType.PY_MEMORY;
    }

    @Override
    public FuturePayload buildPostComputationFuturePayload() {
        FuturePayload fp = new FuturePayload();
        fp.action = "postraining-computation";
        fp.targets.add(DSSFuturePayloadUtils.forFME(this).withPart("modelevaluation-post-computation"));
        fp.displayName = "Model evaluation post computation";
        return fp;
    }

    @Override
    public ComputeResourceUsageContext getComputeResourceUsageContext(DSSAuthCtx owner) {
        return ComputeResourceUsageContext.forModelEvaluationOperation((AuthCtx)owner, (String)this.getProjectKey(), (String)this.id, (String)this.evaluationId);
    }

    @Override
    public File getSessionFolder() {
        return this.getMainFolder();
    }

    public File getSampleScoredFile() throws IOException {
        return this.getEvaluationFile(SAMPLE_SCORED_CSV_GZ);
    }

    public File getSampleFile() throws IOException {
        return this.getEvaluationFile("sample.csv.gz");
    }

    @Override
    @Nullable
    public ColumnImportance getColumnImportance() throws IOException {
        File file = this.getEvaluationFile("column_importance.json");
        if (file.isFile()) {
            return (ColumnImportance)JSON.parseFile((File)file, ColumnImportance.class);
        }
        return null;
    }

    @Override
    public Set<String> getUsedConnections() throws IOException {
        if (!this.hasResolvedPreprocessingParams()) {
            return Collections.emptySet();
        }
        return this.getResolvedPreprocessingParams().getUsedConnections();
    }

    @Override
    public boolean remapAndSaveConnections(Map<String, String> replacements) throws IOException {
        ResolvedPreprocessingParams resolvedPreprocessingParams;
        boolean replaced = false;
        if (this.hasResolvedPreprocessingParams() && (resolvedPreprocessingParams = this.getResolvedPreprocessingParams()).remapConnections(replacements)) {
            JSON.prettyToFile((Object)resolvedPreprocessingParams, (File)this.getEvaluationFile("rpreprocessing_params.json"));
            replaced = true;
        }
        return replaced;
    }

    @Override
    public boolean hasDataToStreamCSV() throws IOException {
        File sampleScoredFile = this.getSampleScoredFile();
        return sampleScoredFile.isFile() && sampleScoredFile.canRead();
    }

    @Override
    public void streamDataCSV(OutputStream out) throws Exception {
        Schema sampleSchema = this.getScoredSchema();
        File file = this.getSampleScoredFile();
        logger.info((Object)("Streaming sample data from " + String.valueOf(file)));
        try (GZIPInputStream sampleData = new GZIPInputStream(new FileInputStream(file));){
            CSVSchemaAdapter.transformCSV(sampleData, sampleSchema, false, this.getDataSchema(), out);
        }
    }

    public void streamDriftReferenceCSV(OutputStream out) throws Exception {
        Schema driftReferenceSampleSchema = this.getModelEvaluation().getDriftReferenceSchema();
        File file = this.getDriftReferenceFile();
        logger.info((Object)("Streaming drift reference sample data from " + String.valueOf(file)));
        try (GZIPInputStream referenceSampleData = new GZIPInputStream(new FileInputStream(file));){
            CSVSchemaAdapter.transformCSV(referenceSampleData, driftReferenceSampleSchema, false, driftReferenceSampleSchema, out);
        }
    }

    @Override
    public Schema getDataSchema() throws IOException {
        AbstractModelEvaluation me = this.getModelEvaluation();
        return me.getDataSchema();
    }

    @Override
    public Schema getPredictedSchema() {
        Schema predictedSchema = new Schema();
        predictedSchema.addColumn("prediction", Type.STRING);
        return predictedSchema;
    }

    @Override
    public void streamPredictedCSV(OutputStream out) throws Exception {
        Schema sampleSchema = this.getScoredSchema();
        Schema predictionSubsetSchema = new Schema();
        predictionSubsetSchema.addColumn(this.getTabularModelEvaluation().predictionVariable, Type.STRING);
        try (GZIPInputStream sampleData = new GZIPInputStream(new FileInputStream(this.getSampleScoredFile()));){
            CSVSchemaAdapter.transformCSV(sampleData, sampleSchema, false, predictionSubsetSchema, out);
        }
    }

    public static FullModelEvaluationId parse(String fullId) {
        Matcher matcher = MODEL_EVALUATION_PATTERN.matcher(fullId);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid model evaluation id: " + fullId);
        }
        return new FullModelEvaluationId(matcher.group("projectKey"), matcher.group("mesId"), matcher.group("evaluationId"));
    }

    public static FullModelEvaluationId parseSmart(String smartFullId, String contextProjectKey) {
        if (StringUtils.isEmpty((String)contextProjectKey)) {
            throw new Error("Smart id expected, but no contextProjectKey provided. Can not parse " + smartFullId);
        }
        Matcher matcher = SMART_MODEL_EVALUATION_PATTERN.matcher(smartFullId);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid smart model evaluation id: " + smartFullId);
        }
        return new FullModelEvaluationId(contextProjectKey, matcher.group("mesId"), matcher.group("evaluationId"));
    }

    @Override
    public TaggableObjectsService.TaggableObjectRef getUnderlyingStore() {
        return new TaggableObjectsService.TaggableObjectRef(this.projectKey, ITaggingService.TaggableType.MODEL_EVALUATION_STORE, this.id);
    }

    @Override
    public PredictionMLTask.PredictionType getPredictionType() throws IOException {
        return this.getTabularModelEvaluation().predictionType;
    }

    @Override
    public FullModelId getUnderlyingModel() throws IOException {
        return this.getTabularModelEvaluation().getBackingFullModelId();
    }

    @Override
    public SplitDesc getSplitDesc() throws IOException {
        SplitDesc splitDesc = new SplitDesc();
        splitDesc.format = "csv1";
        splitDesc.fullPath = SAMPLE_SCORED_CSV_GZ;
        splitDesc.schema = this.getScoredSchema();
        splitDesc.params = new SplitParams();
        splitDesc.params.ttPolicy = SplitParams.TrainTestPolicy.SPLIT_SINGLE_DATASET;
        splitDesc.params.ssdSplitMode = SplitParams.SplitMode.SORTED;
        splitDesc.params.ssdTrainingRatio = 1.0;
        splitDesc.params.kfold = true;
        return splitDesc;
    }

    public boolean hasDriftReference() {
        return this.getEvaluationFile(DRIFT_REFERENCE_SCHEMA_JSON).exists() && this.getEvaluationFile(DRIFT_REFERENCE_CSV_GZ).exists();
    }

    public boolean isLLM() {
        return this.hasLLMPerformance();
    }

    public boolean isAgent() {
        return this.hasAgentPerformance();
    }

    public boolean isGenAi() {
        return this.isLLM() || this.isAgent();
    }

    public File getSampleWithMetricsFile() {
        return this.getEvaluationFile("sample_with_metrics.csv.gz");
    }

    public File getSampleWithMetricsSchemaFile() {
        return this.getEvaluationFile("sample_with_metrics_schema.json");
    }

    public Schema getSampleWithMetricsSchema() throws IOException {
        return (Schema)JSON.parseFile((File)this.getSampleWithMetricsSchemaFile(), Schema.class);
    }
}

