/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.checks;

import com.dataiku.dip.dataquality.ReadMetricValueHelper;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.Check;
import com.dataiku.dip.metrics.checks.MetricCheck;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.j2ts.annotations.UINullable;
import org.apache.commons.lang.StringUtils;

public class MetricInNumericRangeCheck
extends MetricCheck {
    public static final String TYPE = "numericRange";
    @UINullable
    public double minimum;
    @UINullable
    public double maximum;
    @UINullable
    public double softMinimum;
    @UINullable
    public double softMaximum;
    public boolean minimumEnabled;
    public boolean maximumEnabled;
    public boolean softMinimumEnabled;
    public boolean softMaximumEnabled;

    public MetricInNumericRangeCheck() {
        this.type = TYPE;
        this.meta.withName("Metric in range (numeric)");
    }

    public MetricInNumericRangeCheck withMetricId(String metricId) {
        this.metricId = metricId;
        return this;
    }

    public MetricInNumericRangeCheck withMinimum(boolean enabled, double minimum) {
        this.minimumEnabled = enabled;
        this.minimum = minimum;
        return this;
    }

    public MetricInNumericRangeCheck withSoftMinimum(boolean enabled, double softMinimum) {
        this.softMinimumEnabled = enabled;
        this.softMinimum = softMinimum;
        return this;
    }

    public MetricInNumericRangeCheck withSoftMaximum(boolean enabled, double softMaximum) {
        this.softMaximumEnabled = enabled;
        this.softMaximum = softMaximum;
        return this;
    }

    public MetricInNumericRangeCheck withMaximum(boolean enabled, double maximum) {
        this.maximumEnabled = enabled;
        this.maximum = maximum;
        return this;
    }

    @Override
    public AbstractCheckContext.CheckResult run(AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        try {
            ReadOnlyJobsInternalDB.MetricDataPoint metricValue = context.getCurrentValue(this.metricId);
            double value = ReadMetricValueHelper.readDoubleMetricsValue(context, this.metricId);
            return this.runForResolvedValue(value, metricValue.value);
        }
        catch (ReadMetricValueHelper.ReadMetricError e) {
            return new AbstractCheckContext.CheckResult(e.outcome, e.message);
        }
    }

    public AbstractCheckContext.CheckResult runForResolvedValue(double value) {
        return this.runForResolvedValue(value, String.valueOf(value));
    }

    public AbstractCheckContext.CheckResult runForResolvedValue(double value, String strValue) {
        boolean belowSoftMaximum;
        boolean aboveMinimum = !this.minimumEnabled || value >= this.minimum;
        boolean belowMaximum = !this.maximumEnabled || value <= this.maximum;
        boolean aboveSoftMinimum = !this.softMinimumEnabled || value >= this.softMinimum;
        boolean bl = belowSoftMaximum = !this.softMaximumEnabled || value <= this.softMaximum;
        if (!aboveMinimum) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, strValue + " (< " + this.minimum + ")");
        }
        if (!belowMaximum) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, strValue + " (> " + this.maximum + ")");
        }
        if (!aboveSoftMinimum) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.WARNING, strValue + " (< " + this.softMinimum + ")");
        }
        if (!belowSoftMaximum) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.WARNING, strValue + " (> " + this.softMaximum + ")");
        }
        return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.OK, strValue);
    }

    @Override
    public Check trimForSave() {
        return this;
    }

    @Override
    public String getLegacyDatabaseId() {
        String label;
        if (this.meta != null && !StringUtils.isBlank((String)this.meta.getLabel())) {
            return this.meta.getLabel();
        }
        String string = label = this.meta != null ? this.meta.getName() : null;
        if (StringUtils.isBlank((String)label)) {
            label = this.getType();
        }
        String metricId = this.getMetricId();
        String metricName = null;
        if (StringUtils.isNotBlank((String)metricId)) {
            try {
                Metric metric = Metric.deserializeMetric(metricId);
                metricName = metric.getMeta().getFullName();
                if (StringUtils.isBlank((String)metricName)) {
                    metricName = metric.getMeta().getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank(metricName)) {
            metricName = metricId;
        }
        return label + " of " + metricName;
    }
}

