/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class LLMEvaluationProbeType
extends ProbeType {
    public static final String TYPE = "llm_evaluation";
    private static final Map<LLMEvaluationMetricsEnum, MetricMetadata> metadataPerType = Maps.newHashMap();

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        return Lists.newArrayList();
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        return Lists.newArrayList();
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> column, Probe probe) {
        return null;
    }

    @Override
    public ProbeType trimForSave() {
        return new LLMEvaluationProbeType();
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return LLMEvaluationProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(0).withName("LLM Evaluation");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return false;
    }

    static {
        for (LLMEvaluationMetricsEnum metric : LLMEvaluationMetricsEnum.values()) {
            metadataPerType.put(metric, new MetricMetadata().withName(metric.displayName).withFormat("longReadableNumber"));
        }
    }

    public static class LLMEvaluationProbeConfiguration
    implements ProbeConfiguration {
    }

    public static enum LLMEvaluationMetricsEnum {
        ANSWER_RELEVANCY("Answer relevancy"),
        MULTIMODAL_RELEVANCY("Multimodal relevancy"),
        ANSWER_SIMILARITY("Answer similarity"),
        ANSWER_CORRECTNESS("Answer correctness"),
        FAITHFULNESS("Faithfulness"),
        MULTIMODAL_FAITHFULNESS("Multimodal faithfulness"),
        CONTEXT_RECALL("Context recall"),
        CONTEXT_PRECISION("Context precision"),
        BERT_SCORE_PRECISION("BERT Score - Precision"),
        BERT_SCORE_RECALL("BERT Score - Recall"),
        BERT_SCORE_F1("BERT Score - F1 Score"),
        BLEU("BLEU"),
        ROUGE_1_PRECISION("ROUGE-1 - Precision"),
        ROUGE_1_RECALL("ROUGE-1 - Recall"),
        ROUGE_1_F1("ROUGE-1 - F1 Score"),
        ROUGE_2_PRECISION("ROUGE-2 - Precision"),
        ROUGE_2_RECALL("ROUGE-2 - Recall"),
        ROUGE_2_F1("ROUGE-2 - F1 Score"),
        ROUGE_L_PRECISION("ROUGE-L - Precision"),
        ROUGE_L_RECALL("ROUGE-L - Recall"),
        ROUGE_L_F1("ROUGE-L - F1 Score"),
        INPUT_TOKENS_PER_ROW("Input tokens ingested by the LLM, per row"),
        OUTPUT_TOKENS_PER_ROW("Output tokens generated by the LLM, per row"),
        SAMPLE_ROW_COUNT("Sample row count");

        final String displayName;

        private LLMEvaluationMetricsEnum(String displayName) {
            this.displayName = displayName;
        }
    }

    public static class LLMEvaluationMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof LLMEvaluationMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            LLMEvaluationMetric llmEvaluationMetric = (LLMEvaluationMetric)metric;
            return Metric.buildMetricIdFromParts(LLMEvaluationProbeType.TYPE, llmEvaluationMetric.metricType.name());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.get(0).equals(LLMEvaluationProbeType.TYPE)) {
                LLMEvaluationMetricsEnum metricType = LLMEvaluationMetricsEnum.valueOf(parts.get(1));
                return new LLMEvaluationMetric(metricType);
            }
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
        }
    }

    @UIModel
    public static class LLMEvaluationMetric
    extends Metric {
        public LLMEvaluationMetricsEnum metricType;

        public LLMEvaluationMetric(LLMEvaluationMetricsEnum metricType) {
            super(LLMEvaluationProbeType.TYPE, Type.DOUBLE);
            this.metricType = metricType;
            this.id = Metric.serializeMetric(this);
        }

        @Override
        public MetricMetadata getMeta() {
            return metadataPerType.get((Object)this.metricType);
        }

        @Override
        public String getColumn() {
            return null;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return this.getId();
        }

        @Override
        @Nullable
        public Probe getMatchingProbe(List<Probe> probes) {
            return new Probe(this.getType()).withConfiguration(new LLMEvaluationProbeConfiguration()).withMeta(ProbeType.getProbeType(LLMEvaluationProbeType.TYPE).getMeta());
        }
    }
}

