/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.exceptions.PivotMissingColumnException;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.GenericDataTensor;
import com.dataiku.dip.pivot.backend.dss.PivotUtils;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.EvaluateAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.GenericAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.LinoColumnFactory;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesContext;
import com.google.refine.expr.ArgsEvaluable;
import com.google.refine.expr.Evaluable;
import com.google.refine.grel.ast.FunctionCallExpr;
import com.google.refine.grel.ast.VariableExpr;
import com.google.refine.udaf.UdafControlFunctionRegistry;
import com.google.refine.udaf.UdafUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractCustomAggregator
extends GenericAggregator<Object> {
    public Expression expression;
    public LinoReader linoReader;
    public List<String> columns = new ArrayList<String>();
    public final Map<String, ColumnBlock> columnsBlock = new HashMap<String, ColumnBlock>();
    public final List<AbstractAggregator<?>> otherAggregators = new ArrayList();
    public final Properties bindings = new Properties();
    protected Object bins;
    protected final boolean formulaValidation;

    public AbstractCustomAggregator(Aggregation req, int[] bins, VariablesContext variablesContext, LinoReader linoReader) {
        super(req, new GenericDataTensor.Builder<Object>().clazz(Object.class).axisLengths(bins).initNonNullCounts(true).build());
        this.bins = bins;
        this.formulaValidation = false;
        this.init(variablesContext, linoReader);
    }

    public AbstractCustomAggregator(Aggregation req, int bins, VariablesContext variablesContext, boolean formulaValidation, LinoReader linoReader) {
        super(req, new GenericDataTensor.Builder<Object>().clazz(Object.class).axisLengths(bins).initNonNullCounts(true).build());
        this.bins = bins;
        this.formulaValidation = formulaValidation;
        this.init(variablesContext, linoReader);
    }

    private void init(VariablesContext variablesContext, LinoReader linoReader) {
        this.expression = new Expression(variablesContext != null ? variablesContext.expand(this.req.customFunction) : this.req.customFunction, UdafControlFunctionRegistry.getInstance());
        this.expression.setColumnFactory(new LinoColumnFactory(linoReader));
        this.expression.setVariablesContext(variablesContext);
        this.linoReader = linoReader;
        this.initAggregators(this.expression);
    }

    protected Object doCalculation(Evaluable evaluable, int index) {
        this.bindings.put("UDAF_BINDING_KEY", (Object)index);
        return UdafUtils.evaluate(evaluable, this.bindings);
    }

    public void setBlockIdx(int blockIdx) {
        try {
            for (String string : this.columns) {
                if (this.linoReader.isGeo(string)) {
                    this.addToColumnBlocks(string + "__dku_raw", string, blockIdx);
                    continue;
                }
                this.addToColumnBlocks(string, blockIdx);
            }
            for (AbstractAggregator abstractAggregator : this.otherAggregators) {
                if (!(abstractAggregator instanceof EvaluateAggregator)) continue;
                ((EvaluateAggregator)abstractAggregator).columnsBlock = this.columnsBlock;
                ((EvaluateAggregator)abstractAggregator).updateBindings();
            }
        }
        catch (PivotMissingColumnException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void addToColumnBlocks(String colName, int blockIdx) throws IOException {
        this.addToColumnBlocks(colName, colName, blockIdx);
    }

    private void addToColumnBlocks(String colName, String remappedColumnName, int blockIdx) throws IOException {
        ColumnBlock columnBlock = this.linoReader.readColumnBlock(colName, blockIdx);
        this.columnsBlock.put(remappedColumnName, columnBlock);
    }

    public void initAggregators(Expression expression) {
        this.columns = expression.getVariables();
        this.initAggregators(expression.evaluable, expression.variablesContext);
    }

    public void initAggregators(Evaluable evaluable, VariablesContext variablesContext) {
        if (UdafUtils.isAggFunction(evaluable)) {
            this.otherAggregators.add(this.buildAggregatorEnriched(PivotUtils.buildAggregator(variablesContext, this.linoReader, this.formulaValidation, UdafUtils.buildAggregation(evaluable, this.linoReader), this.bins), (FunctionCallExpr)evaluable));
        }
        if (evaluable instanceof ArgsEvaluable) {
            for (int i = 0; i < ((ArgsEvaluable)evaluable)._args.length; ++i) {
                this.initAggregators(((ArgsEvaluable)evaluable)._args[i], variablesContext);
            }
        }
    }

    private AbstractAggregator<?> buildAggregatorEnriched(AbstractAggregator<?> baseAggregator, FunctionCallExpr functionCallExpr) {
        UdafUtils.numberOfArgumentsChecker(functionCallExpr);
        Evaluable evaluable = functionCallExpr._args[0];
        if (evaluable instanceof VariableExpr) {
            baseAggregator.parentReference = functionCallExpr;
            return baseAggregator;
        }
        return new EvaluateAggregator(baseAggregator, evaluable, functionCallExpr, this.expression.variablesContext, this.formulaValidation);
    }

    @Override
    public void close() throws Exception {
        super.close();
        for (AbstractAggregator<?> otherAggregator : this.otherAggregators) {
            otherAggregator.close();
        }
    }

    @Override
    public void initMerge() {
        super.initMerge();
        this.otherAggregators.forEach(AbstractAggregator::initMerge);
    }

    @Override
    public void initMerge(int[] axisLengths) {
        super.initMerge(axisLengths);
        this.otherAggregators.forEach(agg -> agg.initMerge(axisLengths));
    }

    @Override
    public void initMerge(int axisLength) {
        super.initMerge(axisLength);
        this.otherAggregators.forEach(agg -> agg.initMerge(axisLength));
    }

    @Override
    public void postProcessEndPhase2() {
        super.postProcessEndPhase2();
        this.otherAggregators.forEach(AbstractAggregator::postProcessEndPhase2);
    }

    @Override
    public void handleBlock(ColumnBlock block, int start, int rows, int[] coords, int[] bins, boolean[] filters, boolean fillAxes) throws IOException {
        for (AbstractAggregator<?> agg : this.otherAggregators) {
            agg.handleBlock(this.columnsBlock.get(agg.req.column), start, rows, coords, bins, filters, fillAxes);
        }
    }

    @Override
    public Object mergeValues(Object v1, Object v2) {
        throw new NotImplementedException("Not able to merge that type of values");
    }
}

