/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.cache;

import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.cache.FacetCache;
import com.dataiku.dip.pivot.backend.sql.cache.LRUList;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicStatsCache {
    private FacetCache facetCache;
    private LRUList<CachedStats> data;

    public BasicStatsCache(int size, FacetCache facetCache) {
        this.facetCache = facetCache;
        this.data = new LRUList(size);
    }

    public synchronized void put(List<RowFilter> filters, BasicStatsBuilder.BasicStats stats) {
        ArrayList<RowFilter> noFilter = new ArrayList<RowFilter>();
        for (Map.Entry<String, BasicStatsBuilder.ColStats> entry : stats.columnStats.entrySet()) {
            if (entry.getValue().type == AxisDef.Type.ALPHANUM) continue;
            RowFilter rf = new RowFilter();
            rf.column = entry.getKey();
            rf.columnType = entry.getValue().type;
            FilterFacet ff = new FilterFacet();
            ff.maxValue = entry.getValue().maxValue;
            ff.minValue = entry.getValue().minValue;
            this.facetCache.put(filters, rf, ff);
        }
        this.put(filters, stats.totalAfterFiltering);
        this.put(noFilter, stats.totalBeforeFiltering);
    }

    public synchronized void put(List<RowFilter> filters, long count) {
        CachedStats cs2 = new CachedStats();
        cs2.totalAfterFiltering = count;
        cs2.filters = FilterUtils.intersectAndSort(filters);
        this.data.addAndCollect(cs2);
    }

    public synchronized List<CachedStats> findWithLessRestrictiveFilters(List<RowFilter> filters) {
        ArrayList<CachedStats> rfs = new ArrayList<CachedStats>();
        for (CachedStats cf : this.data) {
            if (!FilterUtils.isIncludedIn(filters, cf.filters)) continue;
            rfs.add(cf);
        }
        return rfs;
    }

    public synchronized List<CachedStats> findWithMoreRestrictiveFilters(List<RowFilter> filters) {
        ArrayList<CachedStats> rfs = new ArrayList<CachedStats>();
        for (CachedStats cf : this.data) {
            if (!FilterUtils.isIncludedIn(cf.filters, filters)) continue;
            rfs.add(cf);
        }
        return rfs;
    }

    private synchronized Long findNumberOfRecords(List<RowFilter> filters) {
        for (CachedStats cs2 : this.data) {
            if (!FilterUtils.isEquivalent(cs2.filters, filters)) continue;
            return cs2.totalAfterFiltering;
        }
        List<CachedStats> lessRestrictives = this.findWithLessRestrictiveFilters(filters);
        List<CachedStats> moreRestrictives = this.findWithMoreRestrictiveFilters(filters);
        for (CachedStats less : lessRestrictives) {
            for (CachedStats more : moreRestrictives) {
                if (less.totalAfterFiltering != more.totalAfterFiltering) continue;
                return less.totalAfterFiltering;
            }
        }
        return null;
    }

    public synchronized BasicStatsBuilder.BasicStats get(List<RowFilter> filters, List<AxisDef> columnDefinitions) {
        BasicStatsBuilder.BasicStats stats = new BasicStatsBuilder.BasicStats();
        stats.columnStats = new HashMap<String, BasicStatsBuilder.ColStats>();
        for (AxisDef columnDefinition : columnDefinitions) {
            RowFilter rf = new RowFilter();
            rf.column = columnDefinition.column;
            rf.columnType = columnDefinition.type;
            FilterFacet ff = this.facetCache.get(filters, rf);
            if (ff == null) {
                return null;
            }
            BasicStatsBuilder.ColStats colStat = new BasicStatsBuilder.ColStats();
            colStat.maxValue = ff.maxValue;
            colStat.minValue = ff.minValue;
            stats.columnStats.put(columnDefinition.column, colStat);
        }
        ArrayList<RowFilter> noFilter = new ArrayList<RowFilter>();
        Long totalUnfiltered = this.findNumberOfRecords(noFilter);
        if (totalUnfiltered == null) {
            return null;
        }
        stats.totalBeforeFiltering = totalUnfiltered;
        Long totalFiltered = this.findNumberOfRecords(filters);
        if (totalFiltered == null) {
            return null;
        }
        stats.totalAfterFiltering = totalFiltered;
        return stats;
    }

    private static class CachedStats {
        public List<RowFilter> filters;
        public long totalAfterFiltering;

        private CachedStats() {
        }
    }
}

