/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel;

import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.frontend.color.DiscretePalette;
import com.dataiku.dip.pivot.frontend.color.PaletteFactory;
import com.dataiku.dip.pivot.frontend.excel.StdAggrDataSheet2DBuilder;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.axes.AxisFactory;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.AreaChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.BarChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.BaseChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.LineChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.series.Series1D;
import com.dataiku.dip.pivot.frontend.excel.xssf.series.SeriesFactory;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.DisplayAxis;
import com.dataiku.dip.pivot.frontend.model.MeasureDef;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.AxisCrossBetween;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.AxisOrientation;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.AxisPosition;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.LegendPosition;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFSheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.io.IOException;
import org.openxmlformats.schemas.drawingml.x2006.chart.STBarGrouping;
import org.openxmlformats.schemas.drawingml.x2006.chart.STGrouping;

public class AreaBarLine2DExporter {
    public static XSSFWorkbook export(ChartDef chartDef, PivotTableTensorResponse response, int animationFrameIdx) throws IOException {
        BaseChart chart;
        DiscretePalette palette = PaletteFactory.buildIndexedPalette(chartDef.colorOptions.colorPalette);
        SeriesFactory serieFactory = new SeriesFactory();
        XSSFWorkbook workbook = new XSSFWorkbook();
        StdAggrDataSheet2DBuilder.DataSheet2DRef dataSheetRef = StdAggrDataSheet2DBuilder.buildMatrixSheet(workbook, chartDef, response, animationFrameIdx);
        XSSFSheet chartSheet = workbook.createSheet("Chart");
        XSSFChart poiChart = ChartUtils.createChart(chartSheet);
        AxisFactory axisFactory = new AxisFactory(poiChart);
        MeasureDef firstMeasureDef = chartDef.genericMeasures.get(0);
        AxisPosition axisPosition = firstMeasureDef != null && DisplayAxis.axis1.equals((Object)firstMeasureDef.displayAxis) ? AxisPosition.LEFT : AxisPosition.RIGHT;
        XDDFValueAxis valueAxis = axisFactory.buildValueAxis(axisPosition);
        valueAxis.setOrientation(AxisOrientation.MIN_MAX);
        valueAxis.setCrossBetween(AxisCrossBetween.BETWEEN);
        if (axisPosition == AxisPosition.RIGHT) {
            valueAxis.setCrosses(AxisCrosses.MAX);
        }
        valueAxis.setTitle(com.dataiku.dip.pivot.frontend.ChartUtils.getNiceMeasureName(firstMeasureDef, false));
        if (chartDef.xAxisFormatting.isLogScale) {
            valueAxis.setLogBase(10.0);
        }
        XDDFCategoryAxis bottomAxis = axisFactory.buildCategoryAxis(AxisPosition.BOTTOM);
        bottomAxis.setVisible(axisPosition == AxisPosition.LEFT);
        bottomAxis.setTitle(com.dataiku.dip.pivot.frontend.ChartUtils.getNiceDimensionName(ChartUtils.getGenericDimension(chartDef), false));
        ChartUtils.crossAxes((XDDFChartAxis)valueAxis, (XDDFChartAxis)bottomAxis);
        int drawnReferenceLines = 0;
        switch (chartDef.type) {
            case grouped_columns: {
                BarChart barChart1D = new BarChart();
                barChart1D.setGrouping(STBarGrouping.CLUSTERED);
                chart = barChart1D;
                drawnReferenceLines = ChartUtils.drawReferenceLines(response, dataSheetRef.getSheet(), (XDDFChart)poiChart, chartDef);
                break;
            }
            case stacked_columns: {
                BarChart stackedBarChart1D = new BarChart();
                switch (chartDef.variant) {
                    case normal: {
                        stackedBarChart1D.setGrouping(STBarGrouping.STACKED);
                        break;
                    }
                    case stacked_100: {
                        stackedBarChart1D.setGrouping(STBarGrouping.PERCENT_STACKED);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperation("Excel chart export is not possible when the variant is " + String.valueOf((Object)chartDef.variant));
                    }
                }
                chart = stackedBarChart1D;
                break;
            }
            case stacked_area: {
                AreaChart areaChart1D = new AreaChart();
                switch (chartDef.variant) {
                    case stacked_100: {
                        areaChart1D.setGrouping(STGrouping.PERCENT_STACKED);
                        break;
                    }
                    case normal: {
                        areaChart1D.setGrouping(STGrouping.STACKED);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperation("Excel chart export is not possible when the variant is " + String.valueOf((Object)chartDef.variant));
                    }
                }
                chart = areaChart1D;
                break;
            }
            case lines: {
                chart = new LineChart();
                drawnReferenceLines = ChartUtils.drawReferenceLines(response, dataSheetRef.getSheet(), (XDDFChart)poiChart, chartDef);
                break;
            }
            default: {
                throw new RuntimeException("Unreachable");
            }
        }
        serieFactory.initIndex(drawnReferenceLines);
        ChartUtils.drawGridLines((XDDFChart)poiChart, chartDef);
        bottomAxis.setVisible(true);
        for (int i = 0; i < dataSheetRef.getSerieCount(); ++i) {
            Series1D series = serieFactory.build1D(dataSheetRef.getSerieTitleSource(i), dataSheetRef.getSerieSource(i), dataSheetRef.getXAxisSource());
            series.setColor(palette.apply(i));
            series.setSmoothed(chartDef.smoothing);
            series.setMarker(i);
            chart.addSeries(series);
        }
        XDDFChartLegend legend = poiChart.getOrAddLegend();
        legend.setPosition(LegendPosition.RIGHT);
        ChartUtils.setOverlay(legend, false);
        chart.plot((XDDFChart)poiChart, new XDDFChartAxis[]{bottomAxis, valueAxis});
        workbook.setSheetOrder("Chart", 0);
        workbook.setActiveSheet(0);
        return workbook;
    }
}

