/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel;

import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.frontend.color.Color;
import com.dataiku.dip.pivot.frontend.excel.CellStyler;
import com.dataiku.dip.pivot.frontend.excel.GroupedXYDataSheet1DBuilder;
import com.dataiku.dip.pivot.frontend.excel.StdAggrDataSheet1DBuilder;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartTextSource;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.SheetUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.axes.AxisFactory;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.BubbleChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.series.Series3D;
import com.dataiku.dip.pivot.frontend.excel.xssf.series.SeriesFactory;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellRangeAddress;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellReference;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.AxisPosition;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFSheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BubbleChartExporter {
    public static XSSFWorkbook export(ChartDef chartDef, PivotTableTensorResponse response, int animationFrameIdx) {
        CellRangeAddress zSerieSourceRange;
        SeriesFactory seriesFactory = new SeriesFactory();
        XSSFWorkbook workbook = new XSSFWorkbook();
        CellStyler styler = new CellStyler((Workbook)workbook);
        CellStyle headerStyle = styler.getHeaderStyle();
        StdAggrDataSheet1DBuilder.DataSheet1DRef dataSheetRef = GroupedXYDataSheet1DBuilder.buildSheet(workbook, chartDef, response, animationFrameIdx);
        XSSFSheet dataSheet = dataSheetRef.getSheet();
        int rowOffset = dataSheet.getLastRowNum() + 2;
        XSSFSheet chartSheet = workbook.createSheet("Chart");
        XSSFChart poiChart = ChartUtils.createChart(chartSheet);
        ChartUtils.setChartTitle(poiChart, dataSheetRef.getTitleSource());
        AxisFactory axisFactory = new AxisFactory(poiChart);
        XDDFValueAxis leftAxis = axisFactory.buildValueAxis(AxisPosition.LEFT);
        XDDFValueAxis bottomAxis = axisFactory.buildValueAxis(AxisPosition.BOTTOM);
        ChartUtils.crossAxes((XDDFChartAxis)bottomAxis, (XDDFChartAxis)leftAxis);
        BubbleChart chart = new BubbleChart();
        ChartTextSource titleSource = dataSheetRef.getTitleSource();
        XDDFDataSource<String> labelsSource = dataSheetRef.getAxisSource();
        int nextAvailableColumn = 0;
        if (chartDef.sizeMeasure.size() > 0) {
            int sizeSerieIdx = 2;
            zSerieSourceRange = dataSheetRef.getAggregationSourceRange(sizeSerieIdx);
        } else {
            SheetUtils.writeCell(dataSheet, rowOffset, nextAvailableColumn, "Bubble size").setCellStyle(headerStyle);
            for (int i = 0; i < labelsSource.getPointCount(); ++i) {
                CellStyle style = styler.getValueStyle(i == labelsSource.getPointCount() - 1, false);
                SheetUtils.writeCell(dataSheet, 1 + i + rowOffset, nextAvailableColumn, 1.0).setCellStyle(style);
            }
            zSerieSourceRange = new CellRangeAddress(rowOffset + 1, rowOffset + 1 + labelsSource.getPointCount(), nextAvailableColumn, nextAvailableColumn);
            ++nextAvailableColumn;
        }
        XDDFNumericalDataSource<Double> xSerieSource = dataSheetRef.getAggregationSource(0);
        BubbleChartExporter.fitAxisLimitsToData(xSerieSource, bottomAxis);
        XDDFNumericalDataSource<Double> ySerieSource = dataSheetRef.getAggregationSource(1);
        BubbleChartExporter.fitAxisLimitsToData(ySerieSource, leftAxis);
        if (chartDef.colorMeasure.size() == 0) {
            XDDFNumericalDataSource zSerieSource = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)dataSheet, (CellRangeAddress)zSerieSourceRange);
            Series3D mainSeries = seriesFactory.build3D(titleSource, xSerieSource, ySerieSource, (XDDFNumericalDataSource<Double>)zSerieSource, labelsSource);
            mainSeries.setColor(Color.fromRGB(245.0, 160.0, 17.0));
            chart.addSeries(mainSeries);
        } else {
            int colorSeriesIdx = chartDef.sizeMeasure.size() > 0 ? 3 : 2;
            String colorSeriesTitle = dataSheetRef.getAggregationTitleSource(colorSeriesIdx).getTextString();
            CellRangeAddress colorSeriesSourceRange = dataSheetRef.getAggregationSourceRange(colorSeriesIdx);
            XSSFSheet colorSeriesSourceSheet = dataSheetRef.getSheet();
            int nbBins = 20;
            double minVal = Double.POSITIVE_INFINITY;
            double maxVal = Double.NEGATIVE_INFINITY;
            for (int row = colorSeriesSourceRange.getFirstRow(); row <= colorSeriesSourceRange.getLastRow(); ++row) {
                Double val = SheetUtils.readNumCell(colorSeriesSourceSheet, row, colorSeriesSourceRange.getFirstColumn());
                if (val == null) continue;
                minVal = Math.min(val, minVal);
                maxVal = Math.max(val, maxVal);
            }
            if (minVal == maxVal) {
                nbBins = 1;
            }
            double step = (maxVal - minVal) / (double)nbBins;
            for (int i = 0; i < nbBins; ++i) {
                boolean isLast;
                double binStart = minVal + step * (double)i;
                double binEnd = minVal + step * (double)(i + 1);
                boolean isFirst = i == 0;
                boolean bl = isLast = i == nbBins - 1;
                if (isFirst) {
                    binStart = minVal;
                } else if (isLast) {
                    binEnd = maxVal;
                }
                SheetUtils.writeCell(dataSheet, rowOffset, nextAvailableColumn, binStart + " < " + colorSeriesTitle + " < " + binEnd).setCellStyle(headerStyle);
                for (int k = 0; k < zSerieSourceRange.getNumberOfCells(); ++k) {
                    CellReference colorCellRef = new CellReference(colorSeriesSourceRange.getFirstRow() + k, colorSeriesSourceRange.getFirstColumn());
                    String colorCellAbsoluteRef = colorCellRef.formatAsString();
                    CellReference sizeCellRef = new CellReference(zSerieSourceRange.getFirstRow() + k, zSerieSourceRange.getFirstColumn());
                    String sizeCellAbsoluteRef = sizeCellRef.formatAsString();
                    String formula = "IF(AND(" + colorCellAbsoluteRef + ">=" + binStart + "," + colorCellAbsoluteRef + (isLast ? "<=" : "<") + binEnd + ")," + sizeCellAbsoluteRef + ",\"\")";
                    CellStyle style = styler.getValueStyle(k == zSerieSourceRange.getNumberOfCells() - 1, false);
                    SheetUtils.writeFormula(dataSheet, rowOffset + k + 1, nextAvailableColumn, formula).setCellStyle(style);
                }
                CellRangeAddress thisRange = new CellRangeAddress(rowOffset + 1, rowOffset + 1 + zSerieSourceRange.getNumberOfCells(), nextAvailableColumn, nextAvailableColumn);
                XDDFNumericalDataSource zSerieSource = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)dataSheet, (CellRangeAddress)thisRange);
                Series3D partialSerie = seriesFactory.build3D(titleSource, xSerieSource, ySerieSource, (XDDFNumericalDataSource<Double>)zSerieSource, labelsSource);
                double ratio = (double)(1 + i) / (double)nbBins;
                int gray = (int)((1.0 - ratio) * 250.0);
                partialSerie.setColor(Color.fromRGB(gray, gray, gray));
                chart.addSeries(partialSerie);
                ++nextAvailableColumn;
            }
        }
        chart.plot((XDDFChart)poiChart, new XDDFChartAxis[]{bottomAxis, leftAxis});
        workbook.setSheetOrder("Chart", 0);
        workbook.setActiveSheet(0);
        return workbook;
    }

    private static void fitAxisLimitsToData(XDDFDataSource<Double> data, XDDFValueAxis axis) {
        double xMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < data.getPointCount(); ++i) {
            Double v = (Double)data.getPointAt(i);
            if (v == null || Double.isNaN(v)) continue;
            xMax = Math.max(v, xMax);
            xMin = Math.min(v, xMin);
        }
        double range = xMax - xMin;
        axis.setMaximum(xMax + range * 0.05);
        axis.setMinimum(xMin - range * 0.05);
    }

    private BubbleChartExporter() {
    }
}

