/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.datasets.custompython.CustomPythonDatasetDesc;
import com.dataiku.dip.datasets.custompython.CustomPythonDatasetMeta;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.plugins.LoadedPythonDataset;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class CustomPythonDatasetsService
extends CustomPythonElementService<CustomPythonDatasetDesc, LoadedPythonDataset> {
    @Override
    public String getFolderName() {
        return "python-connectors";
    }

    @Override
    public String getPrefix() {
        return "connector";
    }

    @Override
    protected String getCodeExtension(LoadedPythonDataset desc) {
        return ".py";
    }

    @Override
    public Class<CustomPythonDatasetDesc> getDescClass() {
        return CustomPythonDatasetDesc.class;
    }

    @Override
    public Class<LoadedPythonDataset> getLoadedDescClass() {
        return LoadedPythonDataset.class;
    }

    @Override
    protected void removeElement(LoadedPythonDataset desc) {
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "CustomPython_" + elementId;
    }

    @Override
    protected LoadedPythonDataset load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedPythonDataset loaded = new LoadedPythonDataset(elementType, pluginId, elementId, (CustomPythonDatasetDesc)JSON.parseFile((File)file, CustomPythonDatasetDesc.class));
        CustomPythonDatasetMeta meta = new CustomPythonDatasetMeta(loaded);
        DatasetHandlerFactory.checkDuplicateDatasetMeta(pluginId, elementId, elementType, CustomPythonDatasetMeta.class);
        DatasetHandlerFactory.registerDatasetType(meta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomPythonDatasetDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomPythonDatasetsService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }
}

