/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.python;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class PythonRecipeStatusComputerBase
extends RecipeStatusComputer {
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected GenericRecipesValidationService validationService;
    private static Logger logger = Logger.getLogger((String)"dip.python.recipe.status");

    public PythonRecipeStatusComputerBase(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    public static void checkPythonCompile(InfoMessage.InfoMessages messages, String payload, String envName, String projectKey) throws Exception {
        block11: {
            try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"python-recipe-validation", (String)"recipe");){
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                if (payload == null) {
                    throw new IllegalArgumentException("Python recipe has no payload");
                }
                DKUFileUtils.writeFileUTF8((File)new File((File)tmpDir, "script.py"), (String)payload);
                DKUFileUtils.writeFileUTF8((File)new File((File)tmpDir, "compiler.py"), (String)DKUtils.getResourceFileContentUTF8((String)"com/dataiku/dip/recipes/code/python/pycompiler.py"));
                CodeEnvResolutionService codeEnvResolutionService = (CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class);
                List<Object> cmd = Lists.newArrayList();
                cmd.add(new File((File)tmpDir, "compiler.py").getAbsolutePath());
                cmd = codeEnvResolutionService.getPythonCmd(envName, projectKey, cmd);
                builder.command(cmd);
                builder.environment().putAll(codeEnvResolutionService.getEnvironmentVariablesForPythonCmd(envName, projectKey));
                builder.directory((File)tmpDir);
                String compilerOutput = new String(DKUtils.execAndGetOutput((ProcessBuilder)builder, (String)"Python compilation test failed"), StandardCharsets.UTF_8);
                String[] lines = compilerOutput.split("\r?\n");
                if (lines.length == 0) {
                    throw new IOException("Python compilation did not give any results");
                }
                if (lines[0].equals("OK")) {
                    break block11;
                }
                if (lines[0].equals("NOK")) {
                    if (lines.length < 6) {
                        throw new IOException("Unexpected python compilation result: " + compilerOutput);
                    }
                    int line = Integer.parseInt(lines[3]);
                    int col = StringUtils.isNumeric((String)lines[4]) ? Integer.parseInt(lines[4]) : 0;
                    messages.addMessage(InfoMessage.fatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, (String)(lines[1] + ": " + lines[2]), (Object[])new Object[0]).withPos(line, col).withCodeContext(lines[5]));
                    break block11;
                }
                throw new IOException("Unexpected python compilation result: " + compilerOutput);
            }
        }
    }
}

